////////////////////////////////////////////////////////////////////////////////
//  Author        : Todd Snyder
//  Description   : TriState buffer implementation
////////////////////////////////////////////////////////////////////////////////

// Notes :

////////////////////////////////////////////////////////////////////////////////
/// Imports
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
/// Interfaces
////////////////////////////////////////////////////////////////////////////////
(* always_ready, always_enabled *)
interface TriState#(type t);
   interface Inout#(t)     io;
   method    t             _read;
endinterface: TriState

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
///
/// Implementation
///
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
module mkTriState#(Bool oe, t i)(TriState#(t))
   provisos(Bits#(t, st));

   TriState#(t) _a <- vMkTriState(oe, i);
   return _a;
endmodule


import "BVI" TriState =
module vMkTriState#(Bool oe, t i)(TriState#(t))
   provisos(Bits#(t, st));

   default_clock clk();
   default_reset rst();

   parameter     width = valueof(st);

   ifc_inout     io(IO);

   port          I  = i;
   port          OE = oe;

   method O      _read;

   path (I,  IO);
   path (I,  O);
   path (OE, IO);
   path (OE, O);

   schedule _read CF _read;
endmodule: vMkTriState
