/*
 * Decompiled with CFR 0.152.
 */
package top.scaleda.verilog.annotation.instantiation;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import top.scaleda.idea.ScaledaBundle;
import top.scaleda.verilog.annotation.instantiation.RemoveEmptyParameterAssignmentsIntent;
import top.scaleda.verilog.annotation.instantiation.RemoveRedundantAssignments;
import top.scaleda.verilog.psi.nodes.instantiation.ListOfParameterAssignmentsPsiNode;
import top.scaleda.verilog.psi.nodes.instantiation.ModuleInstantiationPsiNode;
import top.scaleda.verilog.psi.nodes.instantiation.NamedParameterAssignmentPsiNode;
import top.scaleda.verilog.psi.nodes.instantiation.OrderedParameterAssignmentPsiNode;
import top.scaleda.verilog.psi.nodes.instantiation.ParameterValueAssignmentPsiNode;
import top.scaleda.verilog.psi.nodes.module.ModuleDeclarationPsiNode;
import top.scaleda.verilog.psi.nodes.signal.parameter.ParameterIdentifierPsiNode;

@ScalaSignature(bytes="\u0006\u0005m2Aa\u0001\u0003\u0001\u001f!)!\u0005\u0001C\u0001G!)a\u0005\u0001C!O\t\u0019Sj\u001c3vY\u0016\u0004\u0016M]1nKR,'/Q:tS\u001etW.\u001a8ug\u0006sgn\u001c;bi>\u0014(BA\u0003\u0007\u00035Ign\u001d;b]RL\u0017\r^5p]*\u0011q\u0001C\u0001\u000bC:tw\u000e^1uS>t'BA\u0005\u000b\u0003\u001d1XM]5m_\u001eT!a\u0003\u0007\u0002\u000fM\u001c\u0017\r\\3eC*\tQ\"A\u0002u_B\u001c\u0001aE\u0002\u0001!a\u0001\"!\u0005\f\u000e\u0003IQ!a\u0005\u000b\u0002\t1\fgn\u001a\u0006\u0002+\u0005!!.\u0019<b\u0013\t9\"C\u0001\u0004PE*,7\r\u001e\t\u00033\u0001j\u0011A\u0007\u0006\u0003\u000fmQ!a\u0005\u000f\u000b\u0005uq\u0012\u0001C5oi\u0016dG.\u001b6\u000b\u0003}\t1aY8n\u0013\t\t#DA\u0005B]:|G/\u0019;pe\u00061A(\u001b8jiz\"\u0012\u0001\n\t\u0003K\u0001i\u0011\u0001B\u0001\tC:tw\u000e^1uKR\u0019\u0001F\f\u001c\u0011\u0005%bS\"\u0001\u0016\u000b\u0003-\nQa]2bY\u0006L!!\f\u0016\u0003\tUs\u0017\u000e\u001e\u0005\u0006_\t\u0001\r\u0001M\u0001\bK2,W.\u001a8u!\t\tD'D\u00013\u0015\t\u0019D$A\u0002qg&L!!\u000e\u001a\u0003\u0015A\u001b\u0018.\u00127f[\u0016tG\u000fC\u00038\u0005\u0001\u0007\u0001(\u0001\u0004i_2$WM\u001d\t\u00033eJ!A\u000f\u000e\u0003!\u0005sgn\u001c;bi&|g\u000eS8mI\u0016\u0014\b")
public class ModuleParameterAssignmentsAnnotator
implements Annotator {
    public void annotate(PsiElement element, AnnotationHolder holder) {
        Seq<ParameterIdentifierPsiNode> paramSlots;
        if (!(element instanceof ParameterValueAssignmentPsiNode)) {
            return;
        }
        ParameterValueAssignmentPsiNode e = (ParameterValueAssignmentPsiNode)element;
        Option<ListOfParameterAssignmentsPsiNode> listOfParameterAssignmentsPsiNode = e.getListOfParameterAssignments();
        if (listOfParameterAssignmentsPsiNode.isEmpty()) {
            holder.newAnnotation(HighlightSeverity.WEAK_WARNING, ScaledaBundle.message("annotation.empty.parameter.list", new Object[0])).withFix((IntentionAction)new RemoveEmptyParameterAssignmentsIntent(e)).highlightType(ProblemHighlightType.WEAK_WARNING).create();
            return;
        }
        ModuleInstantiationPsiNode instance = (ModuleInstantiationPsiNode)PsiTreeUtil.getParentOfType((PsiElement)element, ModuleInstantiationPsiNode.class);
        if (instance == null) {
            return;
        }
        PsiElement reference = instance.getReference().resolve();
        if (reference == null) {
            return;
        }
        ModuleDeclarationPsiNode module = (ModuleDeclarationPsiNode)reference;
        Seq<NamedParameterAssignmentPsiNode> named = ((ListOfParameterAssignmentsPsiNode)((Object)listOfParameterAssignmentsPsiNode.get())).getNamedParameterAssignments();
        Seq<OrderedParameterAssignmentPsiNode> ordered = ((ListOfParameterAssignmentsPsiNode)((Object)listOfParameterAssignmentsPsiNode.get())).getOrderedParameterAssignments();
        if (ordered.nonEmpty() && (paramSlots = module.getParameters()).length() < ordered.length()) {
            holder.newAnnotation(HighlightSeverity.ERROR, ScaledaBundle.message("annotation.redundant.parameters", module.getName(), BoxesRunTime.boxToInteger((int)paramSlots.length()), BoxesRunTime.boxToInteger((int)ordered.length()))).withFix((IntentionAction)new RemoveRedundantAssignments((ListOfParameterAssignmentsPsiNode)((Object)listOfParameterAssignmentsPsiNode.get()), ordered, paramSlots.length())).highlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL).create();
        }
        if (named.nonEmpty()) {
            return;
        }
    }
}

