/*
 * Decompiled with CFR 0.152.
 */
package top.scaleda.kernel.utils;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.sys.package$;
import top.scaleda.kernel.utils.EnvironmentUtils$Backup$;
import top.scaleda.kernel.utils.OS$;

public final class Paths$ {
    public static final Paths$ MODULE$ = new Paths$();
    private static final String SCALEDA_HOME = "SCALEDA_HOME";

    public String SCALEDA_HOME() {
        return SCALEDA_HOME;
    }

    public File createDirIfNonExists(File f) {
        Object object = !f.exists() ? BoxesRunTime.boxToBoolean((boolean)f.mkdirs()) : BoxedUnit.UNIT;
        return f;
    }

    public Option<String> getEnvHome() {
        Map<String, String> systemEnv = System.getenv();
        if (systemEnv.containsKey(this.SCALEDA_HOME())) {
            return new Some((Object)systemEnv.get(this.SCALEDA_HOME()));
        }
        return None$.MODULE$;
    }

    public File getGlobalConfigDir() {
        Option<String> option = this.getEnvHome();
        if (option instanceof Some) {
            Some some = (Some)option;
            String path = (String)some.value();
            return this.createDirIfNonExists(new File(path));
        }
        if (None$.MODULE$.equals(option)) {
            return this.createDirIfNonExists(new File(OS$.MODULE$.getUserHome(), ".scaleda"));
        }
        throw new MatchError(option);
    }

    public File getToolchainsDir() {
        return this.createDirIfNonExists(new File(this.getGlobalConfigDir(), "toolchains"));
    }

    public File getBinaryDir() {
        return this.createDirIfNonExists(new File(this.getGlobalConfigDir(), "bin"));
    }

    public File getDatabaseDir() {
        return this.createDirIfNonExists(new File(this.getGlobalConfigDir(), "database"));
    }

    public File getIpDir() {
        return this.createDirIfNonExists(new File(this.getGlobalConfigDir(), "ip"));
    }

    public File getUserAuthorization() {
        return new File(this.getGlobalConfigDir(), "authorization.yml");
    }

    public String getServerTemporalDir(boolean isWindows) {
        File f;
        return (isWindows ? (f = new File((String)EnvironmentUtils$Backup$.MODULE$.env().getOrElse((Object)"TEMP", (Function0 & Serializable)() -> new File(MODULE$.pwd(), ".tmp").getAbsolutePath()), "scaledaTmp")) : new File("/tmp", "scaledaTmp")).getAbsolutePath().replace('\\', '/');
    }

    public boolean getServerTemporalDir$default$1() {
        return OS$.MODULE$.isWindows();
    }

    public File pwd() {
        return new File(System.getProperty("user.dir"));
    }

    public Option<String> findExecutableOnPath(String name) {
        Option option;
        Object object = new Object();
        try {
            File possibleFile = new File(name);
            if (possibleFile.exists()) {
                return new Some((Object)possibleFile.getAbsolutePath());
            }
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])((String)package$.MODULE$.env().getOrElse((Object)"PATH", (Function0 & Serializable)() -> "")).split(File.pathSeparator)), (Function1 & Serializable)dirname -> {
                Paths$.$anonfun$findExecutableOnPath$2(name, object, dirname);
                return BoxedUnit.UNIT;
            });
            option = None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    public static final /* synthetic */ void $anonfun$findExecutableOnPath$2(String name$1, Object nonLocalReturnKey1$1, String dirname) {
        File file = new File(dirname, name$1);
        if (file.isFile() && file.canExecute()) {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)file.getAbsolutePath()));
        }
    }

    private Paths$() {
    }
}

