/*
 * Decompiled with CFR 0.152.
 */
package top.scaleda.kernel.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.file.DeletingPathVisitor;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import sourcecode.Line;
import sourcecode.Name;
import top.scaleda.kernel.project.ScaledaProject;
import top.scaleda.kernel.project.config.IPInstance;
import top.scaleda.kernel.project.config.ProjectConfig;
import top.scaleda.kernel.project.config.ProjectConfig$;
import top.scaleda.kernel.project.config.TaskConfig;
import top.scaleda.kernel.project.ip.ExportConfig;
import top.scaleda.kernel.toolchain.impl.Vivado$;
import top.scaleda.kernel.toolchain.runner.ScaledaRuntime;
import top.scaleda.kernel.utils.ImplicitPathReplace;
import top.scaleda.kernel.utils.KernelFileUtils;
import top.scaleda.kernel.utils.KernelLogger$;
import top.scaleda.kernel.utils.serialise.YAMLHelper$;
import top.scaleda.verilog.parser.VerilogParser;
import top.scaleda.verilog.parser.VerilogParserBaseVisitor;
import top.scaleda.verilog.utils.ModuleUtils$;

public final class KernelFileUtils$ {
    public static final KernelFileUtils$ MODULE$ = new KernelFileUtils$();

    public boolean isLegalName(String s) {
        boolean bl;
        Object object = new Object();
        try {
            if (s.isBlank()) {
                return false;
            }
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\\", "/", "*", "?", "\"", "'", "<", ">", "|", ":"})).foreach((Function1 & Serializable)f -> {
                KernelFileUtils$.$anonfun$isLegalName$1(s, object, f);
                return BoxedUnit.UNIT;
            });
            bl = true;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public Option<String> toCanonicalPath(String path, ScaledaProject project) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            Option<String> option = project.projectBase();
            if (option instanceof Some) {
                Some some = (Some)option;
                String base = (String)some.value();
                return new Some((Object)new File(new File(base), path).getCanonicalPath().replace('\\', '/'));
            }
            if (None$.MODULE$.equals(option)) {
                return None$.MODULE$;
            }
            throw new MatchError(option);
        }
        return new Some((Object)file.getCanonicalPath().replace('\\', '/'));
    }

    public Option<String> toProjectRelativePath(String path, ScaledaProject project) {
        if (project.projectBase().isEmpty()) {
            return None$.MODULE$;
        }
        File file = new File(path);
        if (file.isAbsolute()) {
            Some some;
            Path pathAbs = Paths.get(file.getAbsolutePath(), new String[0]);
            Path pathBase = Paths.get((String)project.projectBase().get(), new String[0]);
            try {
                some = new Some((Object)((Object)pathBase.relativize(pathAbs)).toString().replace('\\', '/'));
            }
            catch (Throwable throwable) {
                some = None$.MODULE$;
            }
            return some;
        }
        return new Some((Object)file.getPath().replace('\\', '/'));
    }

    public Seq<File> scanDirectory(scala.collection.immutable.Set<String> suffixing, File directory, int level, int maxLevel) {
        if (level > maxLevel) {
            return (Seq)Nil$.MODULE$;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            return (Seq)Nil$.MODULE$;
        }
        return (Seq)((IterableOps)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])files), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isDirectory()))), (Function1 & Serializable)d -> MODULE$.scanDirectory(suffixing, (File)d, level + 1, maxLevel), ClassTag$.MODULE$.apply(Seq.class))), (Object)Nil$.MODULE$, (Function2 & Serializable)(x$2, x$3) -> (Seq)x$2.$plus$plus((IterableOnce)x$3))).$plus$plus((IterableOnce)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])files), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)KernelFileUtils$.$anonfun$scanDirectory$4(x$4)))), (Function1 & Serializable)f -> {
            String fileName = f.getName();
            if (suffixing.exists((Function1 & Serializable)suffix -> BoxesRunTime.boxToBoolean((boolean)fileName.endsWith(new java.lang.StringBuilder(1).append(".").append(suffix).toString())))) {
                return new .colon.colon(f, (List)Nil$.MODULE$);
            }
            return (Seq)Nil$.MODULE$;
        }, ClassTag$.MODULE$.apply(Seq.class))), (Object)Nil$.MODULE$, (Function2 & Serializable)(x$5, x$6) -> (Seq)x$5.$plus$plus((IterableOnce)x$6)));
    }

    public int scanDirectory$default$3() {
        return 0;
    }

    public int scanDirectory$default$4() {
        return 128;
    }

    public Seq<File> getAllSourceFiles(scala.collection.immutable.Set<String> sources, scala.collection.immutable.Set<String> suffix, ScaledaProject project) {
        return (Seq)((IterableOnceOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)sources.filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$7))))).map((Function1 & Serializable)x$8 -> MODULE$.toCanonicalPath((String)x$8, project))).filter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.nonEmpty()))).map((Function1 & Serializable)f -> new File((String)f.get()))).map((Function1 & Serializable)f -> {
            if (f.exists()) {
                if (f.isDirectory()) {
                    return MODULE$.scanDirectory(suffix, (File)f, MODULE$.scanDirectory$default$3(), MODULE$.scanDirectory$default$4());
                }
                return new .colon.colon(f, (List)Nil$.MODULE$);
            }
            return (Seq)Nil$.MODULE$;
        })).reduceOption((Function2 & Serializable)(x$10, x$11) -> (Seq)x$10.$plus$plus((IterableOnce)x$11)).getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$);
    }

    public scala.collection.immutable.Set<String> getAllSourceFiles$default$2() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"v"}));
    }

    public Seq<String> getModuleTitle(File verilogFile) {
        VerilogParser.Source_textContext tree = ModuleUtils$.MODULE$.parseVerilogFileAST(verilogFile);
        public class Top_scaleda_kernel_utils_KernelFileUtils$ModuleIdentifierVisitor$1
        extends VerilogParserBaseVisitor<String> {
            private final ListBuffer<String> title;

            public ListBuffer<String> title() {
                return this.title;
            }

            public String visitModule_identifier(VerilogParser.Module_identifierContext ctx) {
                VerilogParser.IdentifierContext identifier = ctx.identifier();
                if (identifier != null) {
                    TerminalNode simpleIdentifier = identifier.Simple_identifier();
                    if (simpleIdentifier != null) {
                        String moduleName = simpleIdentifier.getText();
                        this.title().$plus$eq((Object)simpleIdentifier.getText());
                        return moduleName;
                    }
                    return null;
                }
                return null;
            }

            public Top_scaleda_kernel_utils_KernelFileUtils$ModuleIdentifierVisitor$1() {
                this.title = new ListBuffer();
            }
        }
        Top_scaleda_kernel_utils_KernelFileUtils$ModuleIdentifierVisitor$1 visitor = new Top_scaleda_kernel_utils_KernelFileUtils$ModuleIdentifierVisitor$1();
        visitor.visit((ParseTree)tree);
        return visitor.title().toSeq();
    }

    public Option<File> getModuleFileFromSet(scala.collection.immutable.Set<String> sources, String module, ScaledaProject project) {
        Option option;
        Object object = new Object();
        try {
            this.getAllSourceFiles(sources, this.getAllSourceFiles$default$2(), project).foreach((Function1 & Serializable)f -> {
                Seq<String> readModule = MODULE$.getModuleTitle((File)f);
                Seq matched = (Seq)readModule.filter((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)KernelFileUtils$.$anonfun$getModuleFileFromSet$2(module, x$12)));
                KernelLogger$.MODULE$.debug(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new java.lang.StringBuilder(68).append("getModuleFile filter for ").append(f).append(", target module: ").append(module).append(", read module: ").append(readModule).append(", matched: ").append(matched).toString()}), new Line(200), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/utils/KernelFileUtils.scala"), new Name("getModuleFileFromSet"));
                if (matched.nonEmpty()) {
                    throw new NonLocalReturnControl(object, (Object)new Some(f));
                }
                return None$.MODULE$;
            });
            KernelLogger$.MODULE$.warn(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new java.lang.StringBuilder(41).append("cannot get module file! module=").append(module).append(", sources=").append(sources.mkString(", ")).toString()}), new Line(207), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/utils/KernelFileUtils.scala"), new Name("getModuleFileFromSet"));
            option = None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    public int insertAfterModuleHead(File original, File output, String moduleName, String insert) {
        VerilogParser.Source_textContext tree = ModuleUtils$.MODULE$.parseVerilogFileAST(original);
        public class Top_scaleda_kernel_utils_KernelFileUtils$ModuleHeadVisitor$1
        extends VerilogParserBaseVisitor<Object> {
            private final String moduleName;
            private int headerEndAt;

            public String moduleName() {
                return this.moduleName;
            }

            public int headerEndAt() {
                return this.headerEndAt;
            }

            public void headerEndAt_$eq(int x$1) {
                this.headerEndAt = x$1;
            }

            public int visitModule_head(VerilogParser.Module_headContext ctx) {
                TerminalNode simpleIdentifier;
                VerilogParser.IdentifierContext _identifier;
                VerilogParser.Module_identifierContext identifier = ctx.module_identifier();
                if (identifier != null && (_identifier = identifier.identifier()) != null && (simpleIdentifier = _identifier.Simple_identifier()) != null) {
                    String string = simpleIdentifier.getText();
                    String string2 = this.moduleName();
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        int line = ctx.getStop().getStopIndex();
                        this.headerEndAt_$eq(line);
                        return line;
                    }
                }
                return -1;
            }

            public Top_scaleda_kernel_utils_KernelFileUtils$ModuleHeadVisitor$1(String moduleName) {
                this.moduleName = moduleName;
                this.headerEndAt = -1;
            }
        }
        Top_scaleda_kernel_utils_KernelFileUtils$ModuleHeadVisitor$1 visitor = new Top_scaleda_kernel_utils_KernelFileUtils$ModuleHeadVisitor$1(moduleName);
        visitor.visit((ParseTree)tree);
        BufferedSource source = Source$.MODULE$.fromFile(original, Codec$.MODULE$.fallbackSystemCodec());
        String sourceText = source.mkString();
        int lineStart = StringOps$.MODULE$.count$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(sourceText), 0, visitor.headerEndAt())), (Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)KernelFileUtils$.$anonfun$insertAfterModuleHead$1(BoxesRunTime.unboxToChar((Object)x$13))));
        String newText = new StringBuilder(sourceText).insert(visitor.headerEndAt() + 1, insert).toString();
        KernelLogger$.MODULE$.info(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new java.lang.StringBuilder(44).append("insertAfterModuleHead ").append(original).append(" -> ").append(output).append(", insert in index ").append(visitor.headerEndAt() + 1).toString()}), new Line(251), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/utils/KernelFileUtils.scala"), new Name("insertAfterModuleHead"));
        source.close();
        FileOutputStream outputStream = new FileOutputStream(output);
        outputStream.write(newText.getBytes());
        outputStream.close();
        return lineStart;
    }

    public void deleteDirectory(Path path) {
        if (path.toFile().exists()) {
            Files.walkFileTree(path, (FileVisitor<? super Path>)DeletingPathVisitor.withLongCounters());
            return;
        }
    }

    public boolean confirmFileParentPath(File file) {
        File parent = file.getParentFile();
        if (!parent.exists()) {
            return parent.mkdirs();
        }
        return true;
    }

    public Map<String, ProjectConfig> parseIpParentDirectory(File path) {
        if (path.exists() && path.isDirectory()) {
            File[] list = path.listFiles();
            if (list != null) {
                return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])list), (Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)x$14.isDirectory()))), (Function1 & Serializable)p -> new Tuple2(p, MODULE$.parseIpInDirectory((File)p)), ClassTag$.MODULE$.apply(Tuple2.class))), (Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)KernelFileUtils$.$anonfun$parseIpParentDirectory$3(x$15)))), (Function1 & Serializable)p -> new Tuple2((Object)((File)p._1()).getAbsolutePath(), ((Option)p._2()).get()), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }
            return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        }
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public Option<ProjectConfig> parseIpInDirectory(File path) {
        File[] list = path.listFiles(new FilenameFilter(){

            public boolean accept(File file, String s) {
                String string = s;
                String string2 = ProjectConfig$.MODULE$.defaultConfigFile();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        });
        if (list == null) {
            return None$.MODULE$;
        }
        return ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])list), (Function1 & Serializable)f -> {
            BufferedSource source = Source$.MODULE$.fromFile(f, Codec$.MODULE$.fallbackSystemCodec());
            String text = source.mkString();
            source.close();
            if (text.contains("exports")) {
                Object object;
                try {
                    ProjectConfig projectConfig = YAMLHelper$.MODULE$.apply(text, ProjectConfig.class);
                    object = projectConfig.exports().nonEmpty() ? new Some((Object)projectConfig) : None$.MODULE$;
                }
                catch (Throwable e) {
                    KernelLogger$.MODULE$.warn(ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"parse IP failed:", e}), new Line(312), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/utils/KernelFileUtils.scala"), new Name("parseIpInDirectory"));
                    object = None$.MODULE$;
                }
                return object;
            }
            return None$.MODULE$;
        }, ClassTag$.MODULE$.apply(Option.class)))).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public String parseAsAbsolutePath(String path, ScaledaProject project) {
        return (String)this.toCanonicalPath(path, project).getOrElse((Function0 & Serializable)() -> path);
    }

    public File ipCacheDirectory(ScaledaProject project) {
        return new File((String)project.projectBase().getOrElse((Function0 & Serializable)() -> ""), ".cache");
    }

    public scala.collection.immutable.Set<String> getAllCachedIpHash(ScaledaProject project) {
        File[] list = this.ipCacheDirectory(project).listFiles();
        if (list != null) {
            return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])list), (Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)x$16.isDirectory()))), (Function1 & Serializable)x$17 -> x$17.getName(), ClassTag$.MODULE$.apply(String.class))).toSet();
        }
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
    }

    public void removeIpFileCache(String hash, ScaledaProject project) {
        File parent = this.ipCacheDirectory(project);
        if (parent.exists()) {
            File f = new File(parent, hash);
            if (f.exists()) {
                this.deleteDirectory(f.toPath());
                return;
            }
            return;
        }
    }

    public void createIpFileCache(File ipFile, Option<String> hash, ScaledaProject project) {
        String hashUse = (String)hash.getOrElse((Function0 & Serializable)() -> DigestUtils.sha256Hex((InputStream)new FileInputStream(ipFile)));
        File parent = this.ipCacheDirectory(project);
        File targetDirectory = new File(parent, hashUse);
        Object object = targetDirectory.isFile() ? BoxesRunTime.boxToBoolean((boolean)targetDirectory.delete()) : BoxedUnit.UNIT;
        if (targetDirectory.isDirectory() && !ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])targetDirectory.listFiles()))) {
            return;
        }
        Object object2 = !targetDirectory.exists() ? BoxesRunTime.boxToBoolean((boolean)targetDirectory.mkdirs()) : BoxedUnit.UNIT;
        try (FileInputStream fileInputStream = new FileInputStream(ipFile);){
            try {
                ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);
                ZipEntry zipEntry = zipInputStream.getNextEntry();
                int ZIP_BUFFER_SIZE = 1024;
                byte[] buffer = new byte[ZIP_BUFFER_SIZE];
                while (zipEntry != null) {
                    String fileName = zipEntry.getName();
                    if (!zipEntry.isDirectory()) {
                        File newFile = new File(targetDirectory, fileName);
                        new File(newFile.getParent()).mkdirs();
                        FileOutputStream fileOutputStream = new FileOutputStream(newFile);
                        int len = 0;
                        while ((len = zipInputStream.read(buffer)) > 0) {
                            fileOutputStream.write(buffer, 0, len);
                        }
                        fileOutputStream.close();
                    }
                    zipInputStream.closeEntry();
                    zipEntry = zipInputStream.getNextEntry();
                }
                zipInputStream.closeEntry();
                zipInputStream.close();
            }
            catch (Throwable e) {
                KernelLogger$.MODULE$.warn(ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"Cannot extract IP File", ipFile, ": ", e}), new Line(390), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/utils/KernelFileUtils.scala"), new Name("createIpFileCache"));
                e.printStackTrace();
            }
        }
    }

    public Option<String> createIpFileCache$default$2() {
        return None$.MODULE$;
    }

    public void doUpdateIpFilesCache(scala.collection.immutable.Set<String> ipFiles, ScaledaProject project) {
        scala.collection.immutable.Set ipRealFiles = (scala.collection.immutable.Set)((IterableOps)((IterableOps)ipFiles.map((Function1 & Serializable)x$18 -> MODULE$.parseAsAbsolutePath((String)x$18, project))).map((Function1 & Serializable)x$19 -> new File((String)x$19))).filter((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)KernelFileUtils$.$anonfun$doUpdateIpFilesCache$3(f)));
        scala.collection.immutable.Set ipFilesHashes = (scala.collection.immutable.Set)ipRealFiles.map((Function1 & Serializable)f -> new Tuple2(f, (Object)DigestUtils.sha256Hex((InputStream)new FileInputStream((File)f))));
        scala.collection.immutable.Set<String> allHashes = this.getAllCachedIpHash(project);
        ((IterableOnceOps)allHashes.filter((Function1 & Serializable)h -> BoxesRunTime.boxToBoolean((boolean)KernelFileUtils$.$anonfun$doUpdateIpFilesCache$5(ipFilesHashes, h)))).foreach((Function1 & Serializable)hash -> {
            KernelFileUtils$.MODULE$.removeIpFileCache(hash, project);
            return BoxedUnit.UNIT;
        });
        ipFilesHashes.foreach((Function1 & Serializable)h -> {
            KernelFileUtils$.MODULE$.createIpFileCache((File)h._1(), (Option<String>)new Some(h._2()), project);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void doUpdateIpStubsCache(Map<String, ProjectConfig> ips, Seq<IPInstance> instances, File stubsCacheDir) {
        Map contextHashes = ((IterableOnceOps)instances.map((Function1 & Serializable)p -> new Tuple2((Object)new java.lang.StringBuilder(1).append(p.typeId()).append("-").append(p.module()).toString(), (Object)DigestUtils.sha256Hex((String)p.getRenderOptions().toString())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Object object = stubsCacheDir.exists() && stubsCacheDir.isFile() ? BoxesRunTime.boxToBoolean((boolean)stubsCacheDir.delete()) : BoxedUnit.UNIT;
        Object object2 = !stubsCacheDir.exists() ? BoxesRunTime.boxToBoolean((boolean)stubsCacheDir.mkdirs()) : BoxedUnit.UNIT;
        File[] list = stubsCacheDir.listFiles();
        scala.collection.immutable.Set existHashes = list != null ? Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])list), (Function1 & Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)x$21.exists()))), (Function1 & Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)x$22.isDirectory()))), (Function1 & Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])x$23.list()))))), (Function1 & Serializable)x$24 -> x$24.getName(), ClassTag$.MODULE$.apply(String.class))).toSet() : (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
        Map needUpdates = (Map)contextHashes.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)KernelFileUtils$.$anonfun$doUpdateIpStubsCache$6(existHashes, x0$1)));
        scala.collection.immutable.Set needRemove = (scala.collection.immutable.Set)existHashes.filter((Function1 & Serializable)h -> BoxesRunTime.boxToBoolean((boolean)KernelFileUtils$.$anonfun$doUpdateIpStubsCache$7(contextHashes, h)));
        needRemove.foreach((Function1 & Serializable)h -> {
            File f = new File(stubsCacheDir, (String)h);
            if (f.exists()) {
                if (f.isFile()) {
                    return BoxesRunTime.boxToBoolean((boolean)f.delete());
                }
                if (f.isDirectory()) {
                    MODULE$.deleteDirectory(f.toPath());
                    return BoxedUnit.UNIT;
                }
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        });
        Map stubsUpdates = (Map)ips.flatMap((Function1 & Serializable)ip -> (Seq)((IterableOps)instances.filter((Function1 & Serializable)i -> BoxesRunTime.boxToBoolean((boolean)KernelFileUtils$.$anonfun$doUpdateIpStubsCache$11(needUpdates, ip, i)))).map((Function1 & Serializable)i -> {
            String idAndModule = new java.lang.StringBuilder(1).append(i.typeId()).append("-").append(i.module()).toString();
            ExportConfig qual$1 = (ExportConfig)((ProjectConfig)ip._2()).exports().get();
            Map<String, Object> x$1 = i.getRenderOptions();
            ImplicitPathReplace x$2 = qual$1.renderStub$default$2(x$1);
            return new Tuple2((Object)idAndModule, (Object)new Tuple2(needUpdates.apply((Object)idAndModule), (Object)qual$1.renderStub(x$1, x$2)));
        }));
        Object object3 = !stubsCacheDir.exists() ? BoxesRunTime.boxToBoolean((boolean)stubsCacheDir.mkdirs()) : BoxedUnit.UNIT;
        stubsUpdates.foreach((Function1 & Serializable)x0$2 -> {
            KernelFileUtils$.$anonfun$doUpdateIpStubsCache$13(stubsCacheDir, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<File> handleIpInstances(TaskConfig task, File targetDirectory, scala.collection.immutable.Set<String> targetAction, ScaledaProject manifest) {
        Map<String, ProjectConfig> ips = task.getAllIps(manifest);
        Seq<IPInstance> ipInstances = task.getIpInstances(manifest);
        Seq unsupportedIpInstances = (Seq)ipInstances.filterNot((Function1 & Serializable)i -> BoxesRunTime.boxToBoolean((boolean)KernelFileUtils$.$anonfun$handleIpInstances$1(ips, targetAction, i)));
        if (unsupportedIpInstances.nonEmpty()) {
            KernelLogger$.MODULE$.warn(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"unsupported IP instances:", ((IterableOnceOps)unsupportedIpInstances.map((Function1 & Serializable)i -> i.typeId())).mkString(", ")}), new Line(513), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/utils/KernelFileUtils.scala"), new Name("handleIpInstances"));
        }
        Seq supportedIpInstances = (Seq)ipInstances.filter((Function1 & Serializable)i -> BoxesRunTime.boxToBoolean((boolean)KernelFileUtils$.$anonfun$handleIpInstances$6(unsupportedIpInstances, i)));
        Seq targetTemplateFiles = (Seq)supportedIpInstances.flatMap((Function1 & Serializable)p -> {
            Tuple2 tuple2 = new Tuple2((Object)p.typeId(), p.getRenderOptions());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String id = (String)tuple2._1();
            Map context = (Map)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)id, (Object)context);
            String id2 = (String)tuple22._1();
            Map context2 = (Map)tuple22._2();
            return (Seq)Option$.MODULE$.option2Iterable(ips.find((Function1 & Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)KernelFileUtils$.$anonfun$handleIpInstances$9(id2, x$29))).map((Function1 & Serializable)ip -> {
                Tuple2 tuple2 = ip;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String path = (String)tuple2._1();
                ProjectConfig ipExports = (ProjectConfig)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)path, (Object)ipExports);
                String path2 = (String)tuple22._1();
                ProjectConfig ipExports2 = (ProjectConfig)tuple22._2();
                ExportConfig e = (ExportConfig)ipExports2.exports().get();
                Map x$1 = context2;
                Some x$2 = new Some((Object)path2);
                ImplicitPathReplace x$3 = e.renderTemplate$default$3((Map<String, Object>)x$1, (Option<String>)x$2);
                Map targetData = (Map)e.renderTemplate((Map<String, Object>)x$1, (Option<String>)x$2, x$3).map((Function1 & Serializable)t -> new Tuple2((Object)new java.lang.StringBuilder(2).append(id2).append("-").append(p.module()).append("-").append(t._1()).toString(), t._2()));
                Seq renderedFile = ((Seq)targetData.toSeq().map((Function1 & Serializable)t -> {
                    Object object;
                    File targetFile = new File(targetDirectory, (String)t._1());
                    if (!targetFile.exists()) {
                        targetFile.getParentFile().mkdirs();
                        object = BoxesRunTime.boxToBoolean((boolean)targetFile.createNewFile());
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    PrintWriter writer = new PrintWriter(targetFile);
                    writer.write((String)t._2());
                    writer.close();
                    return targetFile;
                })).toSeq();
                return renderedFile;
            })).foldLeft((Object)Nil$.MODULE$, (Function2 & Serializable)(a, b) -> (Seq)a.$plus$plus((IterableOnce)b));
        });
        return targetTemplateFiles;
    }

    public Seq<File> doUpdateStubCacheFromRuntime(ScaledaRuntime rt, ScaledaProject project) {
        Map ips = (Map)rt.task().getAllIps(project).filter((Function1 & Serializable)x$31 -> BoxesRunTime.boxToBoolean((boolean)KernelFileUtils$.$anonfun$doUpdateStubCacheFromRuntime$1(x$31)));
        Seq<IPInstance> ipInstances = rt.task().getIpInstances(project);
        File stubsCacheDir = new File(this.ipCacheDirectory(project), "stubs");
        this.doUpdateIpStubsCache((Map<String, ProjectConfig>)ips, ipInstances, stubsCacheDir);
        Seq<File> ipStubsSources = this.getAllSourceFiles((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{stubsCacheDir.getAbsolutePath()}))), this.getAllSourceFiles$default$2(), project);
        return ipStubsSources;
    }

    public void doUpdateStubCacheFromProject(ScaledaProject project) {
        ProjectConfig$.MODULE$.getConfig(project).foreach((Function1 & Serializable)c -> {
            KernelFileUtils$.$anonfun$doUpdateStubCacheFromProject$1(project, c);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$isLegalName$1(String s$1, Object nonLocalReturnKey1$1, String f) {
        if (s$1.contains(f)) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
        }
    }

    public static final /* synthetic */ boolean $anonfun$scanDirectory$4(File x$4) {
        return !x$4.isDirectory();
    }

    public static final /* synthetic */ boolean $anonfun$getModuleFileFromSet$2(String module$1, String x$12) {
        String string = x$12;
        String string2 = module$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$insertAfterModuleHead$1(char x$13) {
        return x$13 == '\n';
    }

    public static final /* synthetic */ boolean $anonfun$parseIpParentDirectory$3(Tuple2 x$15) {
        return ((Option)x$15._2()).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$doUpdateIpFilesCache$3(File f) {
        return f.exists() && f.isFile();
    }

    public static final /* synthetic */ boolean $anonfun$doUpdateIpFilesCache$6(String h$1, Tuple2 x$20) {
        Object object = x$20._2();
        String string = h$1;
        return !(object != null ? !object.equals(string) : string != null);
    }

    public static final /* synthetic */ boolean $anonfun$doUpdateIpFilesCache$5(scala.collection.immutable.Set ipFilesHashes$1, String h) {
        return !ipFilesHashes$1.exists((Function1 & Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)KernelFileUtils$.$anonfun$doUpdateIpFilesCache$6(h, x$20)));
    }

    public static final /* synthetic */ boolean $anonfun$doUpdateIpStubsCache$6(scala.collection.immutable.Set existHashes$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String idAndModule = (String)tuple2._1();
            String hash = (String)tuple2._2();
            return !existHashes$1.contains((Object)idAndModule) && !existHashes$1.contains((Object)hash);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$doUpdateIpStubsCache$8(String h$2, Tuple2 x$25) {
        Object object = x$25._2();
        String string = h$2;
        return !(object != null ? !object.equals(string) : string != null);
    }

    public static final /* synthetic */ boolean $anonfun$doUpdateIpStubsCache$7(Map contextHashes$1, String h) {
        return !contextHashes$1.exists((Function1 & Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)KernelFileUtils$.$anonfun$doUpdateIpStubsCache$8(h, x$25)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$doUpdateIpStubsCache$11(Map needUpdates$1, Tuple2 ip$1, IPInstance i) {
        if (!needUpdates$1.contains((Object)new java.lang.StringBuilder(1).append(i.typeId()).append("-").append(i.module()).toString())) return false;
        String string = i.typeId();
        String string2 = ((ExportConfig)((ProjectConfig)ip$1._2()).exports().get()).id();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public static final /* synthetic */ void $anonfun$doUpdateIpStubsCache$13(File stubsCacheDir$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String name = (String)tuple2._1();
            Tuple2 tuple22 = (Tuple2)tuple2._2();
            if (tuple22 != null) {
                String hash = (String)tuple22._1();
                String stub = (String)tuple22._2();
                File hashFile = new File(stubsCacheDir$1, hash);
                Object object = !hashFile.exists() ? BoxesRunTime.boxToBoolean((boolean)hashFile.mkdirs()) : BoxedUnit.UNIT;
                File stubFile = new File(hashFile, new java.lang.StringBuilder(2).append(name).append(".v").toString());
                PrintWriter writer = new PrintWriter(stubFile);
                writer.write(stub);
                writer.close();
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$handleIpInstances$2(IPInstance i$1, Tuple2 x$26) {
        String string = ((ExportConfig)((ProjectConfig)x$26._2()).exports().get()).id();
        String string2 = i$1.typeId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final boolean doTestVendor$1(String vendor, Map targetSupports$1, scala.collection.immutable.Set targetAction$1) {
        if (!targetSupports$1.contains((Object)vendor)) {
            return false;
        }
        if (((SeqOps)targetSupports$1.apply((Object)vendor)).contains((Object)"all")) {
            return true;
        }
        return targetAction$1.intersect((Set)((IterableOnceOps)targetSupports$1.apply((Object)vendor)).toSet()).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$handleIpInstances$1(Map ips$1, scala.collection.immutable.Set targetAction$1, IPInstance i) {
        Option ipFound = ips$1.find((Function1 & Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)KernelFileUtils$.$anonfun$handleIpInstances$2(i, x$26)));
        Map targetSupports = (Map)ipFound.map((Function1 & Serializable)ip -> ((ExportConfig)((ProjectConfig)ip._2()).exports().get()).getSupports()).getOrElse((Function0 & Serializable)() -> (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        if (KernelFileUtils$.doTestVendor$1(Vivado$.MODULE$.internalID(), targetSupports, targetAction$1) || KernelFileUtils$.doTestVendor$1("generic", targetSupports, targetAction$1)) {
            return true;
        }
        return ipFound.nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$handleIpInstances$7(IPInstance i$2, IPInstance x$27) {
        String string = x$27.module();
        String string2 = i$2.module();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$handleIpInstances$6(Seq unsupportedIpInstances$1, IPInstance i) {
        return !unsupportedIpInstances$1.exists((Function1 & Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)KernelFileUtils$.$anonfun$handleIpInstances$7(i, x$27)));
    }

    public static final /* synthetic */ boolean $anonfun$handleIpInstances$9(String id$1, Tuple2 x$29) {
        String string = ((ExportConfig)((ProjectConfig)x$29._2()).exports().get()).id();
        String string2 = id$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$doUpdateStubCacheFromRuntime$1(Tuple2 x$31) {
        return ((ProjectConfig)x$31._2()).exports().nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$doUpdateStubCacheFromProject$2(Tuple2 x$32) {
        return ((ProjectConfig)x$32._2()).exports().nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$doUpdateStubCacheFromProject$1(ScaledaProject project$3, ProjectConfig c) {
        Map ips = (Map)c.getAllIps(project$3).filter((Function1 & Serializable)x$32 -> BoxesRunTime.boxToBoolean((boolean)KernelFileUtils$.$anonfun$doUpdateStubCacheFromProject$2(x$32)));
        Seq<IPInstance> ipInstances = c.getIpInstances(project$3);
        File stubsCacheDir = new File(MODULE$.ipCacheDirectory(project$3), "stubs");
        MODULE$.doUpdateIpStubsCache((Map<String, ProjectConfig>)ips, ipInstances, stubsCacheDir);
    }

    private KernelFileUtils$() {
    }
}

