/*
 * Decompiled with CFR 0.152.
 */
package top.scaleda.kernel.toolchain;

import java.io.File;
import java.io.FilenameFilter;
import java.io.Serializable;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import sourcecode.Line;
import sourcecode.Name;
import top.scaleda.kernel.project.detect.BasicProjectDetector;
import top.scaleda.kernel.project.importer.BasicTargetParser;
import top.scaleda.kernel.toolchain.Toolchain;
import top.scaleda.kernel.toolchain.ToolchainPresetProvider;
import top.scaleda.kernel.toolchain.ToolchainProfile;
import top.scaleda.kernel.toolchain.executor.Executor;
import top.scaleda.kernel.toolchain.impl.BSC;
import top.scaleda.kernel.toolchain.impl.BSC$;
import top.scaleda.kernel.toolchain.impl.IVerilog;
import top.scaleda.kernel.toolchain.impl.IVerilog$;
import top.scaleda.kernel.toolchain.impl.MLFSP;
import top.scaleda.kernel.toolchain.impl.MLFSP$;
import top.scaleda.kernel.toolchain.impl.Quartus;
import top.scaleda.kernel.toolchain.impl.Quartus$;
import top.scaleda.kernel.toolchain.impl.Vivado;
import top.scaleda.kernel.toolchain.impl.Vivado$;
import top.scaleda.kernel.toolchain.impl.Yosys;
import top.scaleda.kernel.toolchain.impl.Yosys$;
import top.scaleda.kernel.utils.KernelLogger$;
import top.scaleda.kernel.utils.Paths$;
import top.scaleda.kernel.utils.serialise.YAMLHelper$;

public final class Toolchain$ {
    public static final Toolchain$ MODULE$ = new Toolchain$();
    private static final Map<String, Tuple3<String, Function1<Executor, Toolchain>, Set<Enumeration.Value>>> toolchains = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Vivado$.MODULE$.internalID()), (Object)new Tuple3((Object)Vivado$.MODULE$.userFriendlyName(), (Function1 & Serializable)executor -> new Vivado((Executor)executor), Vivado$.MODULE$.supportedTask())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Quartus$.MODULE$.internalID()), (Object)new Tuple3((Object)Quartus$.MODULE$.userFriendlyName(), (Function1 & Serializable)executor -> new Quartus((Executor)executor), Quartus$.MODULE$.supportedTask())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)IVerilog$.MODULE$.internalID()), (Object)new Tuple3((Object)IVerilog$.MODULE$.userFriendlyName(), (Function1 & Serializable)executor -> new IVerilog((Executor)executor), IVerilog$.MODULE$.supportedTask())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Yosys$.MODULE$.internalID()), (Object)new Tuple3((Object)Yosys$.MODULE$.userFriendlyName(), (Function1 & Serializable)executor -> new Yosys((Executor)executor), Yosys$.MODULE$.supportedTask())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MLFSP$.MODULE$.internalID()), (Object)new Tuple3((Object)MLFSP$.MODULE$.userFriendlyName(), (Function1 & Serializable)executor -> new MLFSP((Executor)executor), MLFSP$.MODULE$.supportedTask())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BSC$.MODULE$.internalID()), (Object)new Tuple3((Object)BSC$.MODULE$.userFriendlyName(), (Function1 & Serializable)executor -> new BSC((Executor)executor), BSC$.MODULE$.supportedTask()))}));
    private static final String defaultConfigDirectory = Paths$.MODULE$.getToolchainsDir().getAbsolutePath();
    private static ListBuffer<ToolchainProfile> cachedProfiles = new ListBuffer();

    public Map<String, Tuple3<String, Function1<Executor, Toolchain>, Set<Enumeration.Value>>> toolchains() {
        return toolchains;
    }

    public String[] toolchainIds() {
        return (String[])this.toolchains().keys().toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public String[] toolchainNames() {
        return (String[])((IterableOnceOps)this.toolchains().map((Function1 & Serializable)x$1 -> (String)((Tuple3)x$1._2())._1())).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public Map<String, ToolchainPresetProvider> toolchainPresetHandler() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Vivado$.MODULE$.internalID()), (Object)Vivado$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)IVerilog$.MODULE$.internalID()), (Object)IVerilog$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Quartus$.MODULE$.internalID()), (Object)Quartus$.MODULE$)}));
    }

    public Seq<Tuple2<String, BasicProjectDetector>> projectDetectors() {
        return new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Vivado$.MODULE$.internalID()), (Object)Vivado$.MODULE$), (List)Nil$.MODULE$);
    }

    public Map<String, BasicTargetParser> targetParser() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Vivado$.MODULE$.internalID()), (Object)Vivado$.MODULE$)}));
    }

    private String defaultConfigDirectory() {
        return defaultConfigDirectory;
    }

    private ListBuffer<ToolchainProfile> cachedProfiles() {
        return cachedProfiles;
    }

    private void cachedProfiles_$eq(ListBuffer<ToolchainProfile> x$1) {
        cachedProfiles = x$1;
    }

    public ListBuffer<ToolchainProfile> profiles(String path, boolean cache) {
        if (cache && this.cachedProfiles().nonEmpty()) {
            return this.cachedProfiles();
        }
        ListBuffer profiles = new ListBuffer();
        File directory = new File(path);
        if (directory.isFile()) {
            throw new RuntimeException(new StringBuilder(10).append(directory.getAbsolutePath()).append(" is a file").toString());
        }
        Object object = !directory.exists() ? BoxesRunTime.boxToBoolean((boolean)directory.mkdirs()) : BoxedUnit.UNIT;
        File[] files = directory.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".yml");
            }
        });
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])files), (Function1 & Serializable)f -> {
            ToolchainProfile newItem = YAMLHelper$.MODULE$.apply((File)f, ToolchainProfile.class);
            newItem.file_$eq((Option<File>)new Some(f));
            return (ListBuffer)profiles.$plus$eq((Object)newItem);
        });
        KernelLogger$.MODULE$.debug(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(16).append(profiles.size()).append(" profiles loaded").toString()}), new Line(107), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/toolchain/Toolchain.scala"), new Name("profiles"));
        this.cachedProfiles_$eq((ListBuffer<ToolchainProfile>)profiles);
        return this.cachedProfiles();
    }

    public String profiles$default$1() {
        return this.defaultConfigDirectory();
    }

    public boolean profiles$default$2() {
        return false;
    }

    public void syncProfile(ToolchainProfile profile) {
        Option<File> option = profile.file();
        if (option instanceof Some) {
            Some some = (Some)option;
            File f = (File)some.value();
            if (profile.removed()) {
                this.removeProfile(profile);
                return;
            }
            YAMLHelper$.MODULE$.apply(profile, f);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            String shortname = profile.profileName().toLowerCase().replaceAll("[^a-z0-9]+", "-");
            YAMLHelper$.MODULE$.apply(profile, new File(this.defaultConfigDirectory(), new StringBuilder(4).append(shortname).append(".yml").toString()));
            return;
        }
        throw new MatchError(option);
    }

    public boolean removeProfile(ToolchainProfile profile) {
        Option<File> option = profile.file();
        if (option instanceof Some) {
            Some some = (Some)option;
            File f = (File)some.value();
            return f.delete();
        }
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        throw new MatchError(option);
    }

    private Toolchain$() {
    }
}

