/*
 * Decompiled with CFR 0.152.
 */
package top.scaleda.kernel.shell.command;

import io.grpc.ManagedChannel;
import io.grpc.stub.StreamObserver;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import sourcecode.File;
import sourcecode.Line;
import sourcecode.Name;
import top.scaleda.kernel.database.UserException;
import top.scaleda.kernel.net.RemoteClient$;
import top.scaleda.kernel.net.fuse.FuseDataProvider;
import top.scaleda.kernel.net.fuse.FuseTransferClient$;
import top.scaleda.kernel.net.fuse.FuseTransferClientObserver;
import top.scaleda.kernel.net.fuse.fs.FuseTransferMessage;
import top.scaleda.kernel.net.fuse.fs.FuseTransferMessage$;
import top.scaleda.kernel.net.fuse.fs.RemoteFuseTransferGrpc;
import top.scaleda.kernel.net.remote.RemoteGrpc;
import top.scaleda.kernel.net.remote.RunReplyType;
import top.scaleda.kernel.net.remote.RunReplyType$RUN_REPLY_TYPE_COMMAND_ID$;
import top.scaleda.kernel.net.remote.RunReplyType$RUN_REPLY_TYPE_ERR_AUTH$;
import top.scaleda.kernel.net.remote.RunReplyType$RUN_REPLY_TYPE_RETURN$;
import top.scaleda.kernel.net.remote.RunReplyType$RUN_REPLY_TYPE_STDERR$;
import top.scaleda.kernel.net.remote.RunReplyType$RUN_REPLY_TYPE_STDOUT$;
import top.scaleda.kernel.net.remote.RunRequest;
import top.scaleda.kernel.net.remote.RunRequest$;
import top.scaleda.kernel.net.remote.StopCommandReply;
import top.scaleda.kernel.net.remote.StopCommandRequest;
import top.scaleda.kernel.net.remote.StopCommandRequest$;
import top.scaleda.kernel.net.remote.StringTriple;
import top.scaleda.kernel.net.remote.StringTriple$;
import top.scaleda.kernel.shell.ScaledaRunHandler;
import top.scaleda.kernel.shell.command.CommandDeps;
import top.scaleda.kernel.shell.command.CommandOutputStream;
import top.scaleda.kernel.shell.command.CommandRunner;
import top.scaleda.kernel.shell.command.RemoteCommandDeps;
import top.scaleda.kernel.shell.command.RemoteCommandRunner$;
import top.scaleda.kernel.utils.KernelLogger$;
import top.scaleda.kernel.utils.serialise.BinarySerializeHelper$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dc\u0001\u0002\f\u0018\u0001\tB\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\t]\u0001\u0011\t\u0011)A\u0005_!)!\u0007\u0001C\u0001g!)q\u0007\u0001C\u0005q!9\u0001\n\u0001b\u0001\n\u0003I\u0005B\u0002*\u0001A\u0003%!\nC\u0004T\u0001\u0001\u0007I\u0011\u0001+\t\u000fe\u0003\u0001\u0019!C\u00015\"1\u0001\r\u0001Q!\nUCq!\u0019\u0001C\u0002\u0013\u0005#\r\u0003\u0004l\u0001\u0001\u0006Ia\u0019\u0005\u0006Y\u0002!\t%\u001c\u0005\u0006c\u0002!\tE\u001d\u0005\bm\u0002\u0011\r\u0011\"\u0003c\u0011\u00199\b\u0001)A\u0005G\")\u0001\u0010\u0001C!s\u001e)!p\u0006E\u0001w\u001a)ac\u0006E\u0001y\"1!G\u0005C\u0001\u0003\u0003Aq!a\u0001\u0013\t\u0003\t)\u0001C\u0005\u00020I\t\n\u0011\"\u0001\u00022\t\u0019\"+Z7pi\u0016\u001cu.\\7b]\u0012\u0014VO\u001c8fe*\u0011\u0001$G\u0001\bG>lW.\u00198e\u0015\tQ2$A\u0003tQ\u0016dGN\u0003\u0002\u001d;\u000511.\u001a:oK2T!AH\u0010\u0002\u000fM\u001c\u0017\r\\3eC*\t\u0001%A\u0002u_B\u001c\u0001aE\u0002\u0001G\u001d\u0002\"\u0001J\u0013\u000e\u0003]I!AJ\f\u0003\u001b\r{W.\\1oIJ+hN\\3s!\t!\u0003&\u0003\u0002*/\t)\u0012IY:ue\u0006\u001cGoQ8n[\u0006tGMU;o]\u0016\u0014\u0018\u0001\u00023faN\u0004\"\u0001\n\u0017\n\u00055:\"aC\"p[6\fg\u000e\u001a#faN\f\u0011C]3n_R,7i\\7nC:$G)\u001a9t!\t!\u0003'\u0003\u00022/\t\t\"+Z7pi\u0016\u001cu.\\7b]\u0012$U\r]:\u0002\rqJg.\u001b;?)\r!TG\u000e\t\u0003I\u0001AQAK\u0002A\u0002-BQAL\u0002A\u0002=\n1B]3qY\u0006\u001cW\rU1uQR\u0011\u0011H\u0012\t\u0003u\rs!aO!\u0011\u0005qzT\"A\u001f\u000b\u0005y\n\u0013A\u0002\u001fs_>$hHC\u0001A\u0003\u0015\u00198-\u00197b\u0013\t\u0011u(\u0001\u0004Qe\u0016$WMZ\u0005\u0003\t\u0016\u0013aa\u0015;sS:<'B\u0001\"@\u0011\u00159E\u00011\u0001:\u0003\r\u0019(oY\u0001\be\u0016\fX/Z:u+\u0005Q\u0005CA&Q\u001b\u0005a%BA'O\u0003\u0019\u0011X-\\8uK*\u0011qjG\u0001\u0004]\u0016$\u0018BA)M\u0005)\u0011VO\u001c*fcV,7\u000f^\u0001\te\u0016\fX/Z:uA\u0005I1m\\7nC:$\u0017\nZ\u000b\u0002+B\u0019akV\u001d\u000e\u0003}J!\u0001W \u0003\r=\u0003H/[8o\u00035\u0019w.\\7b]\u0012LEm\u0018\u0013fcR\u00111L\u0018\t\u0003-rK!!X \u0003\tUs\u0017\u000e\u001e\u0005\b?\"\t\t\u00111\u0001V\u0003\rAH%M\u0001\u000bG>lW.\u00198e\u0013\u0012\u0004\u0013A\u0002;ie\u0016\fG-F\u0001d!\t!\u0017.D\u0001f\u0015\t1w-\u0001\u0003mC:<'\"\u00015\u0002\t)\fg/Y\u0005\u0003U\u0016\u0014a\u0001\u00165sK\u0006$\u0017a\u0002;ie\u0016\fG\rI\u0001\u0004eVtW#\u00018\u0011\u0005\u0011z\u0017B\u00019\u0018\u0005M\u0019u.\\7b]\u0012|U\u000f\u001e9viN#(/Z1n\u00031\u0019\u0017M\u001c+fe6Lg.\u0019;f+\u0005\u0019\bC\u0001,u\u0013\t)xHA\u0004C_>dW-\u00198\u0002+Q,'/\\5oCR,\u0007*\u00198eY\u0016$\u0006N]3bI\u00061B/\u001a:nS:\fG/\u001a%b]\u0012dW\r\u00165sK\u0006$\u0007%A\u0006e_R+'/\\5oCR,G#A.\u0002'I+Wn\u001c;f\u0007>lW.\u00198e%Vtg.\u001a:\u0011\u0005\u0011\u00122C\u0001\n~!\t1f0\u0003\u0002\u0000\u007f\t1\u0011I\\=SK\u001a$\u0012a_\u0001\bKb,7-\u001e;f)%Y\u0016qAA\u0005\u0003?\tY\u0003C\u0003/)\u0001\u0007q\u0006C\u0004\u0002\fQ\u0001\r!!\u0004\u0002\u0011\r|W.\\1oIN\u0004R!a\u0004\u0002\u001a-rA!!\u0005\u0002\u00169\u0019A(a\u0005\n\u0003\u0001K1!a\u0006@\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0007\u0002\u001e\t\u00191+Z9\u000b\u0007\u0005]q\bC\u0004\u0002\"Q\u0001\r!a\t\u0002\u000f!\fg\u000e\u001a7feB!\u0011QEA\u0014\u001b\u0005I\u0012bAA\u00153\t\t2kY1mK\u0012\f'+\u001e8IC:$G.\u001a:\t\u0011\u00055B\u0003%AA\u0002M\fA\"[4o_J,WI\u001d:peN\f\u0011#\u001a=fGV$X\r\n3fM\u0006,H\u000e\u001e\u00135+\t\t\u0019DK\u0002t\u0003kY#!a\u000e\u0011\t\u0005e\u00121I\u0007\u0003\u0003wQA!!\u0010\u0002@\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0003z\u0014AC1o]>$\u0018\r^5p]&!\u0011QIA\u001e\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class RemoteCommandRunner
extends CommandRunner {
    private final RemoteCommandDeps remoteCommandDeps;
    private final RunRequest request;
    private Option<String> commandId;
    private final Thread thread;
    private final Thread terminateHandleThread;

    public static boolean execute$default$4() {
        return RemoteCommandRunner$.MODULE$.execute$default$4();
    }

    public static void execute(RemoteCommandDeps remoteCommandDeps, Seq<CommandDeps> commands, ScaledaRunHandler handler, boolean ignoreErrors) {
        RemoteCommandRunner$.MODULE$.execute(remoteCommandDeps, commands, handler, ignoreErrors);
    }

    private String replacePath(String src) {
        return src.replace('\\', '/');
    }

    public RunRequest request() {
        return this.request;
    }

    public Option<String> commandId() {
        return this.commandId;
    }

    public void commandId_$eq(Option<String> x$1) {
        this.commandId = x$1;
    }

    @Override
    public Thread thread() {
        return this.thread;
    }

    @Override
    public CommandOutputStream run() {
        this.thread().setDaemon(true);
        this.thread().setName(new StringBuilder(22).append("remote-command-runner-").append(this.args().headOption().getOrElse((Function0 & Serializable)() -> "unknown")).toString());
        this.thread().start();
        return new CommandOutputStream((Future<Object>)this.returnValue().future(), this.stdOut(), this.stdErr());
    }

    @Override
    public boolean canTerminate() {
        return this.commandId().nonEmpty();
    }

    private Thread terminateHandleThread() {
        return this.terminateHandleThread;
    }

    @Override
    public void doTerminate() {
        this.terminate_$eq(true);
        if (!this.terminateHandleThread().isAlive()) {
            this.terminateHandleThread().start();
            return;
        }
    }

    public RemoteCommandRunner(CommandDeps deps, RemoteCommandDeps remoteCommandDeps) {
        this.remoteCommandDeps = remoteCommandDeps;
        super(deps);
        this.request = new RunRequest(deps.args(), deps.path(), (Seq<StringTriple>)((Seq)deps.envs().map((Function1 & Serializable)t -> new StringTriple((String)t._1(), (String)t._2(), StringTriple$.MODULE$.$lessinit$greater$default$3()))), remoteCommandDeps.projectRoot().getAbsolutePath().replace('\\', '/'), remoteCommandDeps.runId(), RunRequest$.MODULE$.$lessinit$greater$default$6());
        this.commandId = None$.MODULE$;
        this.thread = new Thread(() -> {
            try {
                Object fuseStartWaits = new Object();
                BooleanRef fuseStarted = BooleanRef.create((boolean)false);
                Thread shellThread = new Thread(() -> {
                    Object object = fuseStartWaits;
                    synchronized (object) {
                        fuseStartWaits.wait(7000L);
                    }
                    if (!fuseStarted$1.elem) {
                        throw new TimeoutException("FUSE starting error");
                    }
                    KernelLogger$.MODULE$.info(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"shell thread started"}), new Line(51), new File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/command/RemoteCommandRunner.scala"), new Name("shellThread"));
                    Tuple2<RemoteGrpc.RemoteBlockingStub, Function0<ManagedChannel>> tuple2 = RemoteClient$.MODULE$.apply($this.remoteCommandDeps.host(), $this.remoteCommandDeps.port());
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    RemoteGrpc.RemoteBlockingStub client = (RemoteGrpc.RemoteBlockingStub)tuple2._1();
                    Function0 shutdown = (Function0)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)client, (Object)shutdown);
                    RemoteGrpc.RemoteBlockingStub client2 = (RemoteGrpc.RemoteBlockingStub)tuple22._1();
                    Function0 shutdown2 = (Function0)tuple22._2();
                    client2.run(this.request()).foreach((Function1 & Serializable)r -> {
                        RunReplyType runReplyType = r.replyType();
                        if (RunReplyType$RUN_REPLY_TYPE_STDOUT$.MODULE$.equals(runReplyType)) {
                            this.stdOut().put(r.strValue());
                            return BoxedUnit.UNIT;
                        }
                        if (RunReplyType$RUN_REPLY_TYPE_STDERR$.MODULE$.equals(runReplyType)) {
                            this.stdErr().put(r.strValue());
                            return BoxedUnit.UNIT;
                        }
                        if (RunReplyType$RUN_REPLY_TYPE_RETURN$.MODULE$.equals(runReplyType)) {
                            return this.returnValue().success((Object)BoxesRunTime.boxToInteger((int)r.intValue()));
                        }
                        if (RunReplyType$RUN_REPLY_TYPE_ERR_AUTH$.MODULE$.equals(runReplyType)) {
                            throw new UserException("User Authorization failed!");
                        }
                        if (RunReplyType$RUN_REPLY_TYPE_COMMAND_ID$.MODULE$.equals(runReplyType)) {
                            KernelLogger$.MODULE$.info(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"recv command id:", r.strValue()}), new Line(60), new File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/command/RemoteCommandRunner.scala"), new Name("shellThread"));
                            this.commandId_$eq((Option<String>)new Some((Object)r.strValue()));
                            return BoxedUnit.UNIT;
                        }
                        KernelLogger$.MODULE$.error(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(17).append("invalid message: ").append(r).toString()}), new Line(62), new File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/command/RemoteCommandRunner.scala"), new Name("shellThread"));
                        return BoxedUnit.UNIT;
                    });
                    shutdown2.apply();
                });
                shellThread.setName("scaleda-run-shell-thread");
                shellThread.start();
                Thread fsThread = new Thread(() -> {
                    boolean fsRunning = true;
                    None$ shutdown = None$.MODULE$;
                    while (fsRunning) {
                        try {
                            try {
                                FuseDataProvider dataProvider = new FuseDataProvider($this.remoteCommandDeps.projectRoot());
                                Tuple4<RemoteFuseTransferGrpc.RemoteFuseTransferStub, StreamObserver<FuseTransferMessage>, FuseTransferClientObserver, Function0<ManagedChannel>> tuple4 = FuseTransferClient$.MODULE$.asStream(dataProvider, $this.remoteCommandDeps.host(), $this.remoteCommandDeps.port());
                                if (tuple4 == null) {
                                    throw new MatchError(tuple4);
                                }
                                RemoteFuseTransferGrpc.RemoteFuseTransferStub _client = (RemoteFuseTransferGrpc.RemoteFuseTransferStub)tuple4._1();
                                StreamObserver stream = (StreamObserver)tuple4._2();
                                FuseTransferClientObserver observer = (FuseTransferClientObserver)tuple4._3();
                                Function0 _shutdown = (Function0)tuple4._4();
                                Tuple4 tuple42 = new Tuple4((Object)_client, (Object)stream, (Object)observer, (Object)_shutdown);
                                RemoteFuseTransferGrpc.RemoteFuseTransferStub _client2 = (RemoteFuseTransferGrpc.RemoteFuseTransferStub)tuple42._1();
                                StreamObserver stream2 = (StreamObserver)tuple42._2();
                                FuseTransferClientObserver observer2 = (FuseTransferClientObserver)tuple42._3();
                                Function0 _shutdown2 = (Function0)tuple42._4();
                                shutdown = new Some((Object)_shutdown2);
                                try {
                                    stream2.onNext((Object)FuseTransferMessage$.MODULE$.of(0L, "login", BinarySerializeHelper$.MODULE$.fromAny($this.remoteCommandDeps.runId())));
                                    KernelLogger$.MODULE$.info(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"shell thread started, wait server side fuse mount..."}), new Line(84), new File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/command/RemoteCommandRunner.scala"), new Name("fsThread"));
                                    Object object = observer2.initFlag();
                                    synchronized (object) {
                                        observer2.initFlag().wait(10000L);
                                    }
                                    if (!observer2.initDone()) {
                                        throw new TimeoutException("fuse server side mount timeout");
                                    }
                                    KernelLogger$.MODULE$.info(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"recv init signal"}), new Line(89), new File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/command/RemoteCommandRunner.scala"), new Name("fsThread"));
                                    Thread.sleep(5000L);
                                    KernelLogger$.MODULE$.info(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fs thread notifies shell thread"}), new Line(93), new File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/command/RemoteCommandRunner.scala"), new Name("fsThread"));
                                    Object object2 = fuseStartWaits;
                                    synchronized (object2) {
                                        fuseStarted$1.elem = true;
                                        fuseStartWaits.notify();
                                    }
                                    while (true) {
                                        Thread.sleep(100L);
                                    }
                                }
                                catch (InterruptedException e) {
                                    stream2.onCompleted();
                                    throw e;
                                }
                            }
                            catch (InterruptedException _e) {
                                KernelLogger$.MODULE$.info(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fs data provider interrupted"}), new Line(108), new File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/command/RemoteCommandRunner.scala"), new Name("fsThread"));
                                fsRunning = false;
                            }
                            catch (TimeoutException e) {
                                KernelLogger$.MODULE$.warn(ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"time out for:", e, "data provider exit"}), new Line(111), new File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/command/RemoteCommandRunner.scala"), new Name("fsThread"));
                                fsRunning = false;
                            }
                            catch (Throwable e) {
                                KernelLogger$.MODULE$.warn(ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"fs data provider restart", e}), new Line(114), new File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/command/RemoteCommandRunner.scala"), new Name("fsThread"));
                                Thread.sleep(100L);
                            }
                        }
                        finally {
                            shutdown.foreach((Function1 & Serializable)f -> f.apply());
                            shutdown = None$.MODULE$;
                        }
                    }
                    KernelLogger$.MODULE$.info(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fs data provider exit done"}), new Line(121), new File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/command/RemoteCommandRunner.scala"), new Name("fsThread"));
                }, "scaleda-run-fuse-thread");
                fsThread.setDaemon(false);
                fsThread.start();
                shellThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(this){
                    private final /* synthetic */ RemoteCommandRunner $outer;

                    public void uncaughtException(Thread thread, Throwable throwable) {
                        if (!this.$outer.returnValue().isCompleted()) {
                            this.$outer.returnValue().failure(throwable);
                            return;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                shellThread.join();
                if (fsThread.isAlive()) {
                    fsThread.interrupt();
                    fsThread.join();
                }
                KernelLogger$.MODULE$.info(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Thread.currentThread().getName(), "exits"}), new Line(136), new File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/command/RemoteCommandRunner.scala"), new Name("thread"));
            }
            finally {
                if (!this.returnValue().isCompleted()) {
                    this.returnValue().failure((Throwable)new RuntimeException("Error"));
                }
            }
        });
        this.terminateHandleThread = new Thread(() -> {
            while (this.commandId().isEmpty()) {
                Thread.sleep(100L);
            }
            KernelLogger$.MODULE$.info(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(35).append("command id done: ").append(this.commandId().get()).append(", will stopCommand").toString()}), new Line(153), new File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/command/RemoteCommandRunner.scala"), new Name("terminateHandleThread"));
            Thread.currentThread().setName(new StringBuilder(19).append("terminating-remote-").append(this.commandId().get()).toString());
            Tuple2<RemoteGrpc.RemoteBlockingStub, Function0<ManagedChannel>> tuple2 = RemoteClient$.MODULE$.apply($this.remoteCommandDeps.host(), $this.remoteCommandDeps.port());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            RemoteGrpc.RemoteBlockingStub client = (RemoteGrpc.RemoteBlockingStub)tuple2._1();
            Function0 shutdown = (Function0)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)client, (Object)shutdown);
            RemoteGrpc.RemoteBlockingStub client2 = (RemoteGrpc.RemoteBlockingStub)tuple22._1();
            Function0 shutdown2 = (Function0)tuple22._2();
            this.terminating_$eq(true);
            StopCommandReply reply = client2.stopCommand(new StopCommandRequest((String)this.commandId().get(), 15000L, StopCommandRequest$.MODULE$.apply$default$3()));
            shutdown2.apply();
            if (reply.ok()) {
                this.terminated_$eq(true);
                KernelLogger$.MODULE$.warn(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Terminate done"}), new Line(161), new File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/command/RemoteCommandRunner.scala"), new Name("terminateHandleThread"));
                return;
            }
            KernelLogger$.MODULE$.warn(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot terminate remote command:", reply.reason()}), new Line(163), new File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/command/RemoteCommandRunner.scala"), new Name("terminateHandleThread"));
        });
        this.terminateHandleThread().setDaemon(true);
    }
}

