/*
 * Decompiled with CFR 0.152.
 */
package top.scaleda.kernel.shell;

import io.grpc.ManagedChannel;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scopt.OParser;
import scopt.OParser$;
import scopt.OParserBuilder;
import scopt.Read$;
import sourcecode.Line;
import sourcecode.Name;
import top.scaleda.kernel.bin.ExtractAssets$;
import top.scaleda.kernel.configuration.ScaledaKernelConfiguration;
import top.scaleda.kernel.configuration.ScaledaKernelConfiguration$;
import top.scaleda.kernel.database.dao.User;
import top.scaleda.kernel.language.AbstractLanguage;
import top.scaleda.kernel.language.SupportedLanguages$;
import top.scaleda.kernel.net.RemoteClient$;
import top.scaleda.kernel.net.remote.Empty;
import top.scaleda.kernel.net.remote.Empty$;
import top.scaleda.kernel.net.remote.ProfilesReply;
import top.scaleda.kernel.net.remote.RemoteGrpc;
import top.scaleda.kernel.net.remote.RemoteLoginReply;
import top.scaleda.kernel.net.remote.RemoteRegisterReply;
import top.scaleda.kernel.net.user.ScaledaRegisterLogin;
import top.scaleda.kernel.net.user.ScaledaRegisterLogin$;
import top.scaleda.kernel.project.ScaledaProject;
import top.scaleda.kernel.project.ScaledaProject$;
import top.scaleda.kernel.project.config.IPInstance;
import top.scaleda.kernel.project.config.ProjectConfig;
import top.scaleda.kernel.project.config.ProjectConfig$;
import top.scaleda.kernel.project.config.TargetConfig;
import top.scaleda.kernel.project.config.TaskConfig;
import top.scaleda.kernel.project.detect.BasicProjectDetector;
import top.scaleda.kernel.project.importer.BasicTargetParser;
import top.scaleda.kernel.project.ip.ExportConfig;
import top.scaleda.kernel.server.ScaledaServerMain$;
import top.scaleda.kernel.shell.ScaledaRun$;
import top.scaleda.kernel.shell.ScaledaRunKernelHandler$;
import top.scaleda.kernel.shell.ScaledaRunKernelRemoteHandler$;
import top.scaleda.kernel.shell.ShellArgs;
import top.scaleda.kernel.shell.ShellArgs$;
import top.scaleda.kernel.shell.ShellExceptionHandler;
import top.scaleda.kernel.shell.ShellRunMode$;
import top.scaleda.kernel.template.Template$;
import top.scaleda.kernel.toolchain.Toolchain$;
import top.scaleda.kernel.toolchain.ToolchainProfile;
import top.scaleda.kernel.toolchain.executor.Executor;
import top.scaleda.kernel.toolchain.runner.ScaledaRuntime;
import top.scaleda.kernel.utils.EnvironmentUtils$Backup$;
import top.scaleda.kernel.utils.KernelLogger$;
import top.scaleda.kernel.utils.Paths$;
import top.scaleda.kernel.utils.ScaledaClean$;
import top.scaleda.kernel.utils.ScaledaShellLogger$;
import top.scaleda.kernel.utils.serialise.JSONHelper$;

public final class ScaledaShellMain$ {
    public static final ScaledaShellMain$ MODULE$ = new ScaledaShellMain$();

    private void loadConfig(String projectRootPath, ScaledaProject project) {
        File projectConfigFile;
        KernelLogger$.MODULE$.debug(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(12).append("loadConfig(").append(projectRootPath).append(")").toString()}), new Line(47), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaShellMain.scala"), new Name("loadConfig"));
        File rootDir = new File(projectRootPath);
        if (rootDir.exists() && rootDir.isDirectory()) {
            project.projectBase_$eq((Option<String>)new Some((Object)rootDir.getAbsolutePath()));
        }
        if ((projectConfigFile = new File(projectRootPath, ProjectConfig$.MODULE$.defaultConfigFile())).exists() && !projectConfigFile.isDirectory()) {
            project.configFile_$eq((Option<String>)new Some((Object)projectConfigFile.getAbsolutePath()));
            Option<ProjectConfig> config = ProjectConfig$.MODULE$.getConfig(project);
            KernelLogger$.MODULE$.debug(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(16).append("project config: ").append(config).toString()}), new Line(57), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaShellMain.scala"), new Name("loadConfig"));
            return;
        }
    }

    private Option<String> preParseArgs(String[] args, scala.collection.immutable.Seq<String> option) {
        Option option2;
        Object object = new Object();
        try {
            BooleanRef found = BooleanRef.create((boolean)false);
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])args), (Function1 & Serializable)arg -> {
                ScaledaShellMain$.$anonfun$preParseArgs$1(option, found, object, arg);
                return BoxedUnit.UNIT;
            });
            option2 = None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option2 = (Option)ex.value();
            }
            throw ex;
        }
        return option2;
    }

    public void main(String[] args) {
        KernelLogger$.MODULE$.addLogger(ScaledaShellLogger$.MODULE$);
        KernelLogger$.MODULE$.info(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"This is Scaleda-Shell, an EDA tool for FPGAs"}), new Line(78), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaShellMain.scala"), new Name("main"));
        ScaledaProject project = new ScaledaProject(ScaledaProject$.MODULE$.$lessinit$greater$default$1(), ScaledaProject$.MODULE$.$lessinit$greater$default$2());
        Thread.currentThread().setUncaughtExceptionHandler(new ShellExceptionHandler());
        Template$.MODULE$.initJinja();
        EnvironmentUtils$Backup$ environmentUtils$Backup$ = EnvironmentUtils$Backup$.MODULE$;
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        if (!ExtractAssets$.MODULE$.isInstalled()) {
            ExtractAssets$.MODULE$.run();
            KernelLogger$.MODULE$.debug(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"All assets ready"}), new Line(93), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaShellMain.scala"), new Name("main"));
        }
        this.preParseArgs(args, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"-C", (List)new .colon.colon((Object)"--workdir", (List)Nil$.MODULE$))).foreach((Function1 & Serializable)a -> {
            ScaledaShellMain$.MODULE$.loadConfig(a, project);
            return BoxedUnit.UNIT;
        });
        if (project.configFile().isEmpty()) {
            this.loadConfig(Paths$.MODULE$.pwd().getAbsolutePath(), project);
        }
        if (project.configFile().isEmpty()) {
            KernelLogger$.MODULE$.info(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"No project config detected!"}), new Line(105), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaShellMain.scala"), new Name("main"));
        }
        OParserBuilder builder = OParser$.MODULE$.builder();
        OParser shellParser = OParser$.MODULE$.sequence(builder.programName("scaleda"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OParser[]{builder.head((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"scaleda"})), builder.help("help").text("Prints this usage text"), builder.opt('C', "workdir", Read$.MODULE$.fileRead()).action((Function2 & Serializable)(x, c) -> {
            File x$1 = x;
            String x$2 = c.copy$default$1();
            String x$3 = c.copy$default$2();
            Enumeration.Value x$4 = c.copy$default$4();
            String x$5 = c.copy$default$5();
            String x$6 = c.copy$default$6();
            User x$7 = c.copy$default$7();
            String x$8 = c.copy$default$8();
            Map<String, String> x$9 = c.copy$default$9();
            String x$10 = c.copy$default$10();
            boolean x$11 = c.copy$default$11();
            String x$12 = c.copy$default$12();
            String x$13 = c.copy$default$13();
            return c.copy(x$2, x$3, x$1, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13);
        }).text("Working directory"), builder.opt('h', "host", Read$.MODULE$.stringRead()).action((Function2 & Serializable)(x, c) -> {
            String x$14 = x;
            String x$15 = c.copy$default$1();
            String x$16 = c.copy$default$2();
            File x$17 = c.copy$default$3();
            Enumeration.Value x$18 = c.copy$default$4();
            String x$19 = c.copy$default$6();
            User x$20 = c.copy$default$7();
            String x$21 = c.copy$default$8();
            Map<String, String> x$22 = c.copy$default$9();
            String x$23 = c.copy$default$10();
            boolean x$24 = c.copy$default$11();
            String x$25 = c.copy$default$12();
            String x$26 = c.copy$default$13();
            return c.copy(x$15, x$16, x$17, x$18, x$14, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26);
        }).text("Set server host for RPC"), builder.opt('u', "username", Read$.MODULE$.stringRead()).action((Function2 & Serializable)(x, c) -> {
            User user = c.user();
            user.setUsername((String)x);
            User x$27 = user;
            String x$28 = c.copy$default$1();
            String x$29 = c.copy$default$2();
            File x$30 = c.copy$default$3();
            Enumeration.Value x$31 = c.copy$default$4();
            String x$32 = c.copy$default$5();
            String x$33 = c.copy$default$6();
            String x$34 = c.copy$default$8();
            Map<String, String> x$35 = c.copy$default$9();
            String x$36 = c.copy$default$10();
            boolean x$37 = c.copy$default$11();
            String x$38 = c.copy$default$12();
            String x$39 = c.copy$default$13();
            return c.copy(x$28, x$29, x$30, x$31, x$32, x$33, x$27, x$34, x$35, x$36, x$37, x$38, x$39);
        }).text("Specify username"), builder.opt('p', "password", Read$.MODULE$.stringRead()).action((Function2 & Serializable)(x, c) -> {
            User user = c.user();
            user.setPassword((String)x);
            User x$40 = user;
            String x$41 = c.copy$default$1();
            String x$42 = c.copy$default$2();
            File x$43 = c.copy$default$3();
            Enumeration.Value x$44 = c.copy$default$4();
            String x$45 = c.copy$default$5();
            String x$46 = c.copy$default$6();
            String x$47 = c.copy$default$8();
            Map<String, String> x$48 = c.copy$default$9();
            String x$49 = c.copy$default$10();
            boolean x$50 = c.copy$default$11();
            String x$51 = c.copy$default$12();
            String x$52 = c.copy$default$13();
            return c.copy(x$41, x$42, x$43, x$44, x$45, x$46, x$40, x$47, x$48, x$49, x$50, x$51, x$52);
        }).text("Specify password"), builder.cmd("remote").children((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OParser[]{builder.cmd("serve").text("\tRun as server").action((Function2 & Serializable)(x$2, c) -> {
            Enumeration.Value x$53 = ShellRunMode$.MODULE$.Serve();
            String x$54 = c.copy$default$1();
            String x$55 = c.copy$default$2();
            File x$56 = c.copy$default$3();
            String x$57 = c.copy$default$5();
            String x$58 = c.copy$default$6();
            User x$59 = c.copy$default$7();
            String x$60 = c.copy$default$8();
            Map<String, String> x$61 = c.copy$default$9();
            String x$62 = c.copy$default$10();
            boolean x$63 = c.copy$default$11();
            String x$64 = c.copy$default$12();
            String x$65 = c.copy$default$13();
            return c.copy(x$54, x$55, x$56, x$53, x$57, x$58, x$59, x$60, x$61, x$62, x$63, x$64, x$65);
        }), builder.cmd("login").text("\tLogin into server").action((Function2 & Serializable)(x$3, c) -> {
            Enumeration.Value x$66 = ShellRunMode$.MODULE$.Login();
            String x$67 = c.copy$default$1();
            String x$68 = c.copy$default$2();
            File x$69 = c.copy$default$3();
            String x$70 = c.copy$default$5();
            String x$71 = c.copy$default$6();
            User x$72 = c.copy$default$7();
            String x$73 = c.copy$default$8();
            Map<String, String> x$74 = c.copy$default$9();
            String x$75 = c.copy$default$10();
            boolean x$76 = c.copy$default$11();
            String x$77 = c.copy$default$12();
            String x$78 = c.copy$default$13();
            return c.copy(x$67, x$68, x$69, x$66, x$70, x$71, x$72, x$73, x$74, x$75, x$76, x$77, x$78);
        }), builder.cmd("register").text("\tCreate account in server").action((Function2 & Serializable)(x$4, c) -> {
            Enumeration.Value x$79 = ShellRunMode$.MODULE$.Register();
            String x$80 = c.copy$default$1();
            String x$81 = c.copy$default$2();
            File x$82 = c.copy$default$3();
            String x$83 = c.copy$default$5();
            String x$84 = c.copy$default$6();
            User x$85 = c.copy$default$7();
            String x$86 = c.copy$default$8();
            Map<String, String> x$87 = c.copy$default$9();
            String x$88 = c.copy$default$10();
            boolean x$89 = c.copy$default$11();
            String x$90 = c.copy$default$12();
            String x$91 = c.copy$default$13();
            return c.copy(x$80, x$81, x$82, x$79, x$83, x$84, x$85, x$86, x$87, x$88, x$89, x$90, x$91);
        }).children((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OParser[]{builder.opt('n', "nickname", Read$.MODULE$.stringRead()).action((Function2 & Serializable)(x, c) -> {
            User user = c.user();
            user.setNickname((String)x);
            User x$92 = user;
            String x$93 = c.copy$default$1();
            String x$94 = c.copy$default$2();
            File x$95 = c.copy$default$3();
            Enumeration.Value x$96 = c.copy$default$4();
            String x$97 = c.copy$default$5();
            String x$98 = c.copy$default$6();
            String x$99 = c.copy$default$8();
            Map<String, String> x$100 = c.copy$default$9();
            String x$101 = c.copy$default$10();
            boolean x$102 = c.copy$default$11();
            String x$103 = c.copy$default$12();
            String x$104 = c.copy$default$13();
            return c.copy(x$93, x$94, x$95, x$96, x$97, x$98, x$92, x$99, x$100, x$101, x$102, x$103, x$104);
        }).text("Specify nickname")})), builder.cmd("refresh").text("\tRefresh token").action((Function2 & Serializable)(x$5, c) -> {
            Enumeration.Value x$105 = ShellRunMode$.MODULE$.RefreshToken();
            String x$106 = c.copy$default$1();
            String x$107 = c.copy$default$2();
            File x$108 = c.copy$default$3();
            String x$109 = c.copy$default$5();
            String x$110 = c.copy$default$6();
            User x$111 = c.copy$default$7();
            String x$112 = c.copy$default$8();
            Map<String, String> x$113 = c.copy$default$9();
            String x$114 = c.copy$default$10();
            boolean x$115 = c.copy$default$11();
            String x$116 = c.copy$default$12();
            String x$117 = c.copy$default$13();
            return c.copy(x$106, x$107, x$108, x$105, x$109, x$110, x$111, x$112, x$113, x$114, x$115, x$116, x$117);
        })})), builder.cmd("list").children((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OParser[]{builder.cmd("profiles").text("\tShow loaded profiles").action((Function2 & Serializable)(x$6, c) -> {
            Enumeration.Value x$118 = ShellRunMode$.MODULE$.ListProfiles();
            String x$119 = c.copy$default$1();
            String x$120 = c.copy$default$2();
            File x$121 = c.copy$default$3();
            String x$122 = c.copy$default$5();
            String x$123 = c.copy$default$6();
            User x$124 = c.copy$default$7();
            String x$125 = c.copy$default$8();
            Map<String, String> x$126 = c.copy$default$9();
            String x$127 = c.copy$default$10();
            boolean x$128 = c.copy$default$11();
            String x$129 = c.copy$default$12();
            String x$130 = c.copy$default$13();
            return c.copy(x$119, x$120, x$121, x$118, x$122, x$123, x$124, x$125, x$126, x$127, x$128, x$129, x$130);
        }), builder.cmd("tasks").text("\tShow loaded tasks").action((Function2 & Serializable)(x$7, c) -> {
            Enumeration.Value x$131 = ShellRunMode$.MODULE$.ListTasks();
            String x$132 = c.copy$default$1();
            String x$133 = c.copy$default$2();
            File x$134 = c.copy$default$3();
            String x$135 = c.copy$default$5();
            String x$136 = c.copy$default$6();
            User x$137 = c.copy$default$7();
            String x$138 = c.copy$default$8();
            Map<String, String> x$139 = c.copy$default$9();
            String x$140 = c.copy$default$10();
            boolean x$141 = c.copy$default$11();
            String x$142 = c.copy$default$12();
            String x$143 = c.copy$default$13();
            return c.copy(x$132, x$133, x$134, x$131, x$135, x$136, x$137, x$138, x$139, x$140, x$141, x$142, x$143);
        }), builder.cmd("configurations").text("\tShow all configurations to run").action((Function2 & Serializable)(x$8, c) -> {
            Enumeration.Value x$144 = ShellRunMode$.MODULE$.ListConfigurations();
            String x$145 = c.copy$default$1();
            String x$146 = c.copy$default$2();
            File x$147 = c.copy$default$3();
            String x$148 = c.copy$default$5();
            String x$149 = c.copy$default$6();
            User x$150 = c.copy$default$7();
            String x$151 = c.copy$default$8();
            Map<String, String> x$152 = c.copy$default$9();
            String x$153 = c.copy$default$10();
            boolean x$154 = c.copy$default$11();
            String x$155 = c.copy$default$12();
            String x$156 = c.copy$default$13();
            return c.copy(x$145, x$146, x$147, x$144, x$148, x$149, x$150, x$151, x$152, x$153, x$154, x$155, x$156);
        })})), builder.cmd("manage").children((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OParser[]{builder.cmd("install").text("\tInstall necessary binaries force").action((Function2 & Serializable)(x$9, c) -> {
            Enumeration.Value x$157 = ShellRunMode$.MODULE$.Install();
            String x$158 = c.copy$default$1();
            String x$159 = c.copy$default$2();
            File x$160 = c.copy$default$3();
            String x$161 = c.copy$default$5();
            String x$162 = c.copy$default$6();
            User x$163 = c.copy$default$7();
            String x$164 = c.copy$default$8();
            Map<String, String> x$165 = c.copy$default$9();
            String x$166 = c.copy$default$10();
            boolean x$167 = c.copy$default$11();
            String x$168 = c.copy$default$12();
            String x$169 = c.copy$default$13();
            return c.copy(x$158, x$159, x$160, x$157, x$161, x$162, x$163, x$164, x$165, x$166, x$167, x$168, x$169);
        }), builder.cmd("clean").text("\tClean all data on device").action((Function2 & Serializable)(x$10, c) -> {
            Enumeration.Value x$170 = ShellRunMode$.MODULE$.Clean();
            String x$171 = c.copy$default$1();
            String x$172 = c.copy$default$2();
            File x$173 = c.copy$default$3();
            String x$174 = c.copy$default$5();
            String x$175 = c.copy$default$6();
            User x$176 = c.copy$default$7();
            String x$177 = c.copy$default$8();
            Map<String, String> x$178 = c.copy$default$9();
            String x$179 = c.copy$default$10();
            boolean x$180 = c.copy$default$11();
            String x$181 = c.copy$default$12();
            String x$182 = c.copy$default$13();
            return c.copy(x$171, x$172, x$173, x$170, x$174, x$175, x$176, x$177, x$178, x$179, x$180, x$181, x$182);
        })})), builder.cmd("create").text("Create Scaleda Project").action((Function2 & Serializable)(x$11, c) -> {
            Enumeration.Value x$183 = ShellRunMode$.MODULE$.Create();
            String x$184 = c.copy$default$1();
            String x$185 = c.copy$default$2();
            File x$186 = c.copy$default$3();
            String x$187 = c.copy$default$5();
            String x$188 = c.copy$default$6();
            User x$189 = c.copy$default$7();
            String x$190 = c.copy$default$8();
            Map<String, String> x$191 = c.copy$default$9();
            String x$192 = c.copy$default$10();
            boolean x$193 = c.copy$default$11();
            String x$194 = c.copy$default$12();
            String x$195 = c.copy$default$13();
            return c.copy(x$184, x$185, x$186, x$183, x$187, x$188, x$189, x$190, x$191, x$192, x$193, x$194, x$195);
        }).children((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OParser[]{builder.opt('n', "name", Read$.MODULE$.stringRead()).text("Specify project name, default is 'scaleda-rtl'").action((Function2 & Serializable)(name, c) -> {
            String x$196 = name;
            String x$197 = c.copy$default$1();
            String x$198 = c.copy$default$2();
            File x$199 = c.copy$default$3();
            Enumeration.Value x$200 = c.copy$default$4();
            String x$201 = c.copy$default$5();
            String x$202 = c.copy$default$6();
            User x$203 = c.copy$default$7();
            String x$204 = c.copy$default$8();
            Map<String, String> x$205 = c.copy$default$9();
            boolean x$206 = c.copy$default$11();
            String x$207 = c.copy$default$12();
            String x$208 = c.copy$default$13();
            return c.copy(x$197, x$198, x$199, x$200, x$201, x$202, x$203, x$204, x$205, x$196, x$206, x$207, x$208);
        }), builder.opt("empty", Read$.MODULE$.stringRead()).text("Create empty project, do not detect project structure").action((Function2 & Serializable)(x$12, c) -> {
            boolean x$209 = false;
            String x$210 = c.copy$default$1();
            String x$211 = c.copy$default$2();
            File x$212 = c.copy$default$3();
            Enumeration.Value x$213 = c.copy$default$4();
            String x$214 = c.copy$default$5();
            String x$215 = c.copy$default$6();
            User x$216 = c.copy$default$7();
            String x$217 = c.copy$default$8();
            Map<String, String> x$218 = c.copy$default$9();
            String x$219 = c.copy$default$10();
            String x$220 = c.copy$default$12();
            String x$221 = c.copy$default$13();
            return c.copy(x$210, x$211, x$212, x$213, x$214, x$215, x$216, x$217, x$218, x$219, false, x$220, x$221);
        })})), builder.cmd("run").text("Run task").action((Function2 & Serializable)(x$13, c) -> {
            Enumeration.Value x$222 = ShellRunMode$.MODULE$.Run();
            String x$223 = c.copy$default$1();
            String x$224 = c.copy$default$2();
            File x$225 = c.copy$default$3();
            String x$226 = c.copy$default$5();
            String x$227 = c.copy$default$6();
            User x$228 = c.copy$default$7();
            String x$229 = c.copy$default$8();
            Map<String, String> x$230 = c.copy$default$9();
            String x$231 = c.copy$default$10();
            boolean x$232 = c.copy$default$11();
            String x$233 = c.copy$default$12();
            String x$234 = c.copy$default$13();
            return c.copy(x$223, x$224, x$225, x$222, x$226, x$227, x$228, x$229, x$230, x$231, x$232, x$233, x$234);
        }).children((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OParser[]{builder.opt('c', "config", Read$.MODULE$.stringRead()).action((Function2 & Serializable)(x, c) -> {
            String x$235 = x;
            String x$236 = c.copy$default$1();
            String x$237 = c.copy$default$2();
            File x$238 = c.copy$default$3();
            Enumeration.Value x$239 = c.copy$default$4();
            String x$240 = c.copy$default$5();
            String x$241 = c.copy$default$6();
            User x$242 = c.copy$default$7();
            Map<String, String> x$243 = c.copy$default$9();
            String x$244 = c.copy$default$10();
            boolean x$245 = c.copy$default$11();
            String x$246 = c.copy$default$12();
            String x$247 = c.copy$default$13();
            return c.copy(x$236, x$237, x$238, x$239, x$240, x$241, x$242, x$235, x$243, x$244, x$245, x$246, x$247);
        }).text("Specify configure"), builder.opt('t', "task", Read$.MODULE$.stringRead()).action((Function2 & Serializable)(x, c) -> c.copy((String)x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7(), c.copy$default$8(), c.copy$default$9(), c.copy$default$10(), c.copy$default$11(), c.copy$default$12(), c.copy$default$13())).text("Specify the task"), builder.opt('r', "target", Read$.MODULE$.stringRead()).action((Function2 & Serializable)(x, c) -> {
            String x$248 = x;
            String x$249 = c.copy$default$1();
            File x$250 = c.copy$default$3();
            Enumeration.Value x$251 = c.copy$default$4();
            String x$252 = c.copy$default$5();
            String x$253 = c.copy$default$6();
            User x$254 = c.copy$default$7();
            String x$255 = c.copy$default$8();
            Map<String, String> x$256 = c.copy$default$9();
            String x$257 = c.copy$default$10();
            boolean x$258 = c.copy$default$11();
            String x$259 = c.copy$default$12();
            String x$260 = c.copy$default$13();
            return c.copy(x$249, x$248, x$250, x$251, x$252, x$253, x$254, x$255, x$256, x$257, x$258, x$259, x$260);
        }).text("Specify the target, otherwise will auto fill"), builder.opt('p', "profile", Read$.MODULE$.stringRead()).action((Function2 & Serializable)(x, c) -> {
            String x$261 = x;
            String x$262 = c.copy$default$1();
            String x$263 = c.copy$default$2();
            File x$264 = c.copy$default$3();
            Enumeration.Value x$265 = c.copy$default$4();
            String x$266 = c.copy$default$5();
            User x$267 = c.copy$default$7();
            String x$268 = c.copy$default$8();
            Map<String, String> x$269 = c.copy$default$9();
            String x$270 = c.copy$default$10();
            boolean x$271 = c.copy$default$11();
            String x$272 = c.copy$default$12();
            String x$273 = c.copy$default$13();
            return c.copy(x$262, x$263, x$264, x$265, x$266, x$261, x$267, x$268, x$269, x$270, x$271, x$272, x$273);
        }).text("Specify profile name, otherwise will auto fill"), builder.opt('e', "environment", Read$.MODULE$.stringRead()).action((Function2 & Serializable)(x, c) -> {
            Map x$274 = (Map)c.extraEnvs().$plus$plus((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(x), ';')), (Function1 & Serializable)m -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(m), '=')))), (Object)StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(m), '=')[1]), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            String x$275 = c.copy$default$1();
            String x$276 = c.copy$default$2();
            File x$277 = c.copy$default$3();
            Enumeration.Value x$278 = c.copy$default$4();
            String x$279 = c.copy$default$5();
            String x$280 = c.copy$default$6();
            User x$281 = c.copy$default$7();
            String x$282 = c.copy$default$8();
            String x$283 = c.copy$default$10();
            boolean x$284 = c.copy$default$11();
            String x$285 = c.copy$default$12();
            String x$286 = c.copy$default$13();
            return c.copy(x$275, x$276, x$277, x$278, x$279, x$280, x$281, x$282, (Map<String, String>)x$274, x$283, x$284, x$285, x$286);
        }).text("Specify environment, example ENV_A=a;ENV_B=b")})), builder.cmd("tools").text("Useful tools").children((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OParser[]{builder.cmd("ast").text("Parse & show AST of a file").action((Function2 & Serializable)(x$14, c) -> {
            Enumeration.Value x$287 = ShellRunMode$.MODULE$.ParseAST();
            String x$288 = c.copy$default$1();
            String x$289 = c.copy$default$2();
            File x$290 = c.copy$default$3();
            String x$291 = c.copy$default$5();
            String x$292 = c.copy$default$6();
            User x$293 = c.copy$default$7();
            String x$294 = c.copy$default$8();
            Map<String, String> x$295 = c.copy$default$9();
            String x$296 = c.copy$default$10();
            boolean x$297 = c.copy$default$11();
            String x$298 = c.copy$default$12();
            String x$299 = c.copy$default$13();
            return c.copy(x$288, x$289, x$290, x$287, x$291, x$292, x$293, x$294, x$295, x$296, x$297, x$298, x$299);
        }).children((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OParser[]{builder.opt('f', "file", Read$.MODULE$.stringRead()).action((Function2 & Serializable)(x, c) -> {
            String x$300 = x;
            String x$301 = c.copy$default$1();
            String x$302 = c.copy$default$2();
            File x$303 = c.copy$default$3();
            Enumeration.Value x$304 = c.copy$default$4();
            String x$305 = c.copy$default$5();
            String x$306 = c.copy$default$6();
            User x$307 = c.copy$default$7();
            String x$308 = c.copy$default$8();
            Map<String, String> x$309 = c.copy$default$9();
            String x$310 = c.copy$default$10();
            boolean x$311 = c.copy$default$11();
            String x$312 = c.copy$default$13();
            return c.copy(x$301, x$302, x$303, x$304, x$305, x$306, x$307, x$308, x$309, x$310, x$311, x$300, x$312);
        }).text("Specify file"), builder.opt('t', "type", Read$.MODULE$.stringRead()).action((Function2 & Serializable)(x, c) -> {
            String x$313 = x;
            String x$314 = c.copy$default$1();
            String x$315 = c.copy$default$2();
            File x$316 = c.copy$default$3();
            Enumeration.Value x$317 = c.copy$default$4();
            String x$318 = c.copy$default$5();
            String x$319 = c.copy$default$6();
            User x$320 = c.copy$default$7();
            String x$321 = c.copy$default$8();
            Map<String, String> x$322 = c.copy$default$9();
            String x$323 = c.copy$default$10();
            boolean x$324 = c.copy$default$11();
            String x$325 = c.copy$default$12();
            return c.copy(x$314, x$315, x$316, x$317, x$318, x$319, x$320, x$321, x$322, x$323, x$324, x$325, x$313);
        }).text(new StringBuilder(39).append("Specify file language type, available: ").append(((IterableOnceOps)SupportedLanguages$.MODULE$.all().map((Function1 & Serializable)x$15 -> x$15.getName())).mkString(", ")).toString()).optional()}))}))}));
        OParser$.MODULE$.parse(shellParser, (Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)new ShellArgs(ShellArgs$.MODULE$.apply$default$1(), ShellArgs$.MODULE$.apply$default$2(), ShellArgs$.MODULE$.apply$default$3(), ShellArgs$.MODULE$.apply$default$4(), ShellArgs$.MODULE$.apply$default$5(), ShellArgs$.MODULE$.apply$default$6(), ShellArgs$.MODULE$.apply$default$7(), ShellArgs$.MODULE$.apply$default$8(), ShellArgs$.MODULE$.apply$default$9(), ShellArgs$.MODULE$.apply$default$10(), ShellArgs$.MODULE$.apply$default$11(), ShellArgs$.MODULE$.apply$default$12(), ShellArgs$.MODULE$.apply$default$13())).foreach((Function1 & Serializable)shellConfig -> {
            ScaledaShellMain$.$anonfun$main$33(project, shellConfig);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$preParseArgs$1(scala.collection.immutable.Seq option$1, BooleanRef found$1, Object nonLocalReturnKey1$1, String arg) {
        if (option$1.contains((Object)arg)) {
            found$1.elem = true;
            return;
        }
        if (found$1.elem) {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)arg));
        }
    }

    private static final void requireHost$1(ShellArgs shellConfig) {
        Predef$.MODULE$.require(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(shellConfig.serverHost())), (Function0 & Serializable)() -> "server host must provide");
    }

    private static final void requireHostUserPassword$1(ShellArgs shellConfig) {
        ScaledaShellMain$.requireHost$1(shellConfig);
        Predef$.MODULE$.require(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(shellConfig.user().getUsername())), (Function0 & Serializable)() -> "Username required");
        Predef$.MODULE$.require(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(shellConfig.user().getPassword())), (Function0 & Serializable)() -> "Password required");
    }

    public static final /* synthetic */ void $anonfun$main$35(Tuple2 stub) {
        Tuple2 tuple2 = stub;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        RemoteGrpc.RemoteBlockingStub client = (RemoteGrpc.RemoteBlockingStub)tuple2._1();
        RemoteGrpc.RemoteBlockingStub client2 = client;
        ProfilesReply profiles = client2.getProfiles(new Empty(Empty$.MODULE$.apply$default$1()));
        if (profiles.profiles().nonEmpty()) {
            KernelLogger$.MODULE$.info(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"remote profile list:"}), new Line(263), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaShellMain.scala"), new Name("main"));
            profiles.profiles().foreach((Function1 & Serializable)p -> {
                KernelLogger$.MODULE$.info(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{String.valueOf(JSONHelper$.MODULE$.apply(p))}), new Line(265), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaShellMain.scala"), new Name("main"));
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$main$43(ObjectRef targetName$1, ObjectRef taskName$1, Tuple2 f) {
        Tuple2 tuple2 = f;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TargetConfig target = (TargetConfig)tuple2._1();
        TaskConfig task = (TaskConfig)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)target, (Object)task);
        TargetConfig target2 = (TargetConfig)tuple22._1();
        TaskConfig task2 = (TaskConfig)tuple22._2();
        targetName$1.elem = target2.name();
        taskName$1.elem = task2.name();
    }

    public static final /* synthetic */ void $anonfun$main$45(ObjectRef targetName$1, Tuple2 f) {
        Tuple2 tuple2 = f;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TargetConfig target = (TargetConfig)tuple2._1();
        TargetConfig target2 = target;
        targetName$1.elem = target2.name();
    }

    public static final /* synthetic */ void $anonfun$main$42(ShellArgs shellConfig$1, ScaledaProject project$1, ProjectConfig c) {
        Object object;
        String profileHost = shellConfig$1.serverHost();
        ObjectRef taskName = ObjectRef.create((Object)shellConfig$1.taskName());
        ObjectRef targetName = ObjectRef.create((Object)shellConfig$1.targetName());
        String profileName = shellConfig$1.profileName();
        String configureName = shellConfig$1.configureName();
        ObjectRef extraEnvs = ObjectRef.create(shellConfig$1.extraEnvs());
        Map<String, ScaledaKernelConfiguration> configurations = ScaledaKernelConfiguration$.MODULE$.configurations(project$1);
        if (configurations.contains((Object)configureName)) {
            ScaledaKernelConfiguration configuration = (ScaledaKernelConfiguration)configurations.apply((Object)configureName);
            taskName.elem = configuration.configuration().scaleda().taskName();
            targetName.elem = configuration.configuration().scaleda().targetName();
            profileHost = configuration.configuration().scaleda().profileHost();
            profileName = configuration.configuration().scaleda().profileName();
            extraEnvs.elem = JSONHelper$.MODULE$.apply(configuration.configuration().scaleda().extraEnvs(), Map.class);
            object = BoxedUnit.UNIT;
        } else {
            Object object2;
            if (((String)taskName.elem).isEmpty()) {
                if (c.taskNames().length > 1) {
                    KernelLogger$.MODULE$.warn(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Multiple tasks available"}), new Line(301), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaShellMain.scala"), new Name("main"));
                }
                object2 = c.headTargetTask().map((Function1 & Serializable)f -> {
                    ScaledaShellMain$.$anonfun$main$43(targetName, taskName, f);
                    return BoxedUnit.UNIT;
                }).getOrElse((Function0)(JFunction0.mcV.sp & Serializable)() -> KernelLogger$.MODULE$.error(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"No task available"}), new Line(309), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaShellMain.scala"), new Name("main")));
            } else {
                object2 = BoxedUnit.UNIT;
            }
            object = ((String)targetName.elem).isEmpty() ? c.taskByName((String)taskName.elem).map((Function1 & Serializable)f -> {
                ScaledaShellMain$.$anonfun$main$45(targetName, f);
                return BoxedUnit.UNIT;
            }).getOrElse((Function0)(JFunction0.mcV.sp & Serializable)() -> KernelLogger$.MODULE$.error(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Task name error"}), new Line(318), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaShellMain.scala"), new Name("main"))) : BoxedUnit.UNIT;
        }
        if (c.taskByTaskTargetName((String)taskName.elem, (String)targetName.elem).isEmpty()) {
            KernelLogger$.MODULE$.error(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(26).append("Cannot find target-task: ").append((String)targetName.elem).append("-").append((String)taskName.elem).toString()}), new Line(323), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaShellMain.scala"), new Name("main"));
            return;
        }
        KernelLogger$.MODULE$.info(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(33).append("Run target-task-profile-host: ").append((String)targetName.elem).append("-").append((String)taskName.elem).append("-").append(profileName).append("-").append(profileHost).toString()}), new Line(325), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaShellMain.scala"), new Name("main"));
        ScaledaRun$.MODULE$.generateRuntimeFromName((String)targetName.elem, (String)taskName.elem, profileName, profileHost, project$1).map((Function1 & Serializable)x$18 -> {
            Map x$326 = (Map)extraEnvs$1.elem;
            String x$327 = x$18.copy$default$1();
            TargetConfig x$328 = x$18.copy$default$2();
            TaskConfig x$329 = x$18.copy$default$3();
            ToolchainProfile x$330 = x$18.copy$default$4();
            Executor x$331 = x$18.copy$default$5();
            File x$332 = x$18.copy$default$6();
            Map<String, Object> x$333 = x$18.copy$default$8();
            Enumeration.Value x$334 = x$18.copy$default$9();
            ScaledaProject x$335 = x$18.copy$default$10();
            return x$18.copy(x$327, x$328, x$329, x$330, x$331, x$332, (Map<String, String>)x$326, x$333, x$334, x$335);
        }).map((Function1 & Serializable)x$19 -> ScaledaRun$.MODULE$.preprocess((ScaledaRuntime)x$19, true)).map((Function1 & Serializable)rt -> {
            ScaledaRun$.MODULE$.runTask(rt.profile().isRemoteProfile() ? ScaledaRunKernelRemoteHandler$.MODULE$ : ScaledaRunKernelHandler$.MODULE$, rt);
            return BoxedUnit.UNIT;
        }).getOrElse((Function0)(JFunction0.mcV.sp & Serializable)() -> KernelLogger$.MODULE$.error(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot generate runtime!"}), new Line(337), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaShellMain.scala"), new Name("main")));
    }

    public static final /* synthetic */ boolean $anonfun$main$51(File workingDir$1, Tuple2 t) {
        return ((BasicProjectDetector)t._2()).detect(workingDir$1);
    }

    public static final /* synthetic */ boolean $anonfun$main$54(String ext$1, AbstractLanguage x$20) {
        return x$20.getExtensions().contains((Object)ext$1);
    }

    public static final /* synthetic */ void $anonfun$main$33(ScaledaProject project$1, ShellArgs shellConfig) {
        None$ stub2 = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(shellConfig.serverHost())) ? new Some(RemoteClient$.MODULE$.apply(shellConfig.serverHost(), RemoteClient$.MODULE$.apply$default$2())) : None$.MODULE$;
        File workingDir = shellConfig.workingDir();
        Option<ProjectConfig> config2 = ProjectConfig$.MODULE$.getConfig(project$1);
        KernelLogger$.MODULE$.debug(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(14).append("shell config: ").append(shellConfig).toString()}), new Line(251), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaShellMain.scala"), new Name("main"));
        Enumeration.Value value = shellConfig.runMode();
        Enumeration.Value value2 = ShellRunMode$.MODULE$.ListProfiles();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            KernelLogger$.MODULE$.info(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"local profile list:"}), new Line(254), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaShellMain.scala"), new Name("main"));
            Toolchain$.MODULE$.profiles(Toolchain$.MODULE$.profiles$default$1(), Toolchain$.MODULE$.profiles$default$2()).foreach((Function1 & Serializable)p -> {
                KernelLogger$.MODULE$.info(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{String.valueOf(JSONHelper$.MODULE$.apply(p))}), new Line(256), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaShellMain.scala"), new Name("main"));
                return BoxedUnit.UNIT;
            });
            stub2.foreach((Function1 & Serializable)stub -> {
                ScaledaShellMain$.$anonfun$main$35(stub);
                return BoxedUnit.UNIT;
            });
        } else {
            Enumeration.Value value4 = ShellRunMode$.MODULE$.ListTasks();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                KernelLogger$.MODULE$.info(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"task list:"}), new Line(270), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaShellMain.scala"), new Name("main"));
                ProjectConfig$.MODULE$.getConfig(project$1).map((Function1 & Serializable)config -> {
                    ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])config.targets()), (Function1 & Serializable)x$16 -> x$16.tasks(), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(TaskConfig.class))), (Function1 & Serializable)p -> {
                        KernelLogger$.MODULE$.info(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{String.valueOf(JSONHelper$.MODULE$.apply(p))}), new Line(274), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaShellMain.scala"), new Name("main"));
                        return BoxedUnit.UNIT;
                    });
                    return BoxedUnit.UNIT;
                }).getOrElse((Function0)(JFunction0.mcV.sp & Serializable)() -> KernelLogger$.MODULE$.info(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"no task loaded"}), new Line(277), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaShellMain.scala"), new Name("main")));
            } else {
                Enumeration.Value value6 = ShellRunMode$.MODULE$.ListConfigurations();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    KernelLogger$.MODULE$.info(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"configurations:"}), new Line(279), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaShellMain.scala"), new Name("main"));
                    KernelLogger$.MODULE$.info(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Map[]{ScaledaKernelConfiguration$.MODULE$.configurations(project$1)}), new Line(280), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaShellMain.scala"), new Name("main"));
                } else {
                    Enumeration.Value value8 = ShellRunMode$.MODULE$.Run();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        ProjectConfig$.MODULE$.getConfig(project$1).foreach((Function1 & Serializable)c -> {
                            ScaledaShellMain$.$anonfun$main$42(shellConfig, project$1, c);
                            return BoxedUnit.UNIT;
                        });
                    } else {
                        Enumeration.Value value10 = ShellRunMode$.MODULE$.None();
                        Enumeration.Value value11 = value;
                        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                            KernelLogger$.MODULE$.warn(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"no action specified, do nothing"}), new Line(341), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaShellMain.scala"), new Name("main"));
                        } else {
                            Enumeration.Value value12 = ShellRunMode$.MODULE$.Install();
                            Enumeration.Value value13 = value;
                            if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                                BoxesRunTime.boxToBoolean((boolean)ExtractAssets$.MODULE$.run());
                            } else {
                                Enumeration.Value value14 = ShellRunMode$.MODULE$.Serve();
                                Enumeration.Value value15 = value;
                                if (!(value14 != null ? !value14.equals(value15) : value15 != null)) {
                                    ScaledaServerMain$.MODULE$.run(shellConfig);
                                } else {
                                    Enumeration.Value value16 = ShellRunMode$.MODULE$.Login();
                                    Enumeration.Value value17 = value;
                                    if (!(value16 != null ? !value16.equals(value17) : value17 != null)) {
                                        ScaledaShellMain$.requireHostUserPassword$1(shellConfig);
                                        ScaledaRegisterLogin qual$1 = new ScaledaRegisterLogin(shellConfig.serverHost(), ScaledaRegisterLogin$.MODULE$.$lessinit$greater$default$2());
                                        String x$336 = shellConfig.user().getUsername();
                                        String x$337 = shellConfig.user().getPassword();
                                        boolean x$338 = qual$1.login$default$3();
                                        RemoteLoginReply reply = qual$1.login(x$336, x$337, x$338);
                                        if (!reply.ok()) {
                                            KernelLogger$.MODULE$.error(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Login failed:", reply.reason()}), new Line(351), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaShellMain.scala"), new Name("main"));
                                        }
                                    } else {
                                        Enumeration.Value value18 = ShellRunMode$.MODULE$.Register();
                                        Enumeration.Value value19 = value;
                                        if (!(value18 != null ? !value18.equals(value19) : value19 != null)) {
                                            ScaledaShellMain$.requireHostUserPassword$1(shellConfig);
                                            ScaledaRegisterLogin request = new ScaledaRegisterLogin(shellConfig.serverHost(), ScaledaRegisterLogin$.MODULE$.$lessinit$greater$default$2());
                                            RemoteRegisterReply reply = request.register(shellConfig.user());
                                            if (!reply.ok()) {
                                                KernelLogger$.MODULE$.error(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Register failed:", reply.reason()}), new Line(358), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaShellMain.scala"), new Name("main"));
                                            } else {
                                                KernelLogger$.MODULE$.info(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Register done for user", shellConfig.user().getUsername()}), new Line(360), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaShellMain.scala"), new Name("main"));
                                                RemoteLoginReply loginReply = request.login(shellConfig.user().getUsername(), shellConfig.user().getPassword(), request.login$default$3());
                                                if (loginReply.ok()) {
                                                    KernelLogger$.MODULE$.info(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Login done for user", shellConfig.user().getUsername()}), new Line(363), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaShellMain.scala"), new Name("main"));
                                                } else {
                                                    KernelLogger$.MODULE$.warn(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot login for new user", shellConfig.user().getUsername(), loginReply.reason()}), new Line(365), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaShellMain.scala"), new Name("main"));
                                                }
                                            }
                                        } else {
                                            Enumeration.Value value20 = ShellRunMode$.MODULE$.Clean();
                                            Enumeration.Value value21 = value;
                                            if (!(value20 != null ? !value20.equals(value21) : value21 != null)) {
                                                ScaledaClean$.MODULE$.run();
                                            } else {
                                                Enumeration.Value value22 = ShellRunMode$.MODULE$.RefreshToken();
                                                Enumeration.Value value23 = value;
                                                if (!(value22 != null ? !value22.equals(value23) : value23 != null)) {
                                                    ScaledaShellMain$.requireHost$1(shellConfig);
                                                    if (new ScaledaRegisterLogin(shellConfig.serverHost(), ScaledaRegisterLogin$.MODULE$.$lessinit$greater$default$2()).refreshAndStore()) {
                                                        KernelLogger$.MODULE$.info(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Refresh token done"}), new Line(373), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaShellMain.scala"), new Name("main"));
                                                    } else {
                                                        KernelLogger$.MODULE$.error(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Refresh token failed"}), new Line(374), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaShellMain.scala"), new Name("main"));
                                                    }
                                                } else {
                                                    Enumeration.Value value24 = ShellRunMode$.MODULE$.Create();
                                                    Enumeration.Value value25 = value;
                                                    if (!(value24 != null ? !value24.equals(value25) : value25 != null)) {
                                                        Predef$.MODULE$.require(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(shellConfig.createProjectName())));
                                                        scala.collection.immutable.Seq validToolchains = shellConfig.detectProjectWhenCreate() ? (scala.collection.immutable.Seq)((IterableOps)Toolchain$.MODULE$.projectDetectors().filter((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)ScaledaShellMain$.$anonfun$main$51(workingDir, t)))).map((Function1 & Serializable)t -> (String)t._1()) : (scala.collection.immutable.Seq)Nil$.MODULE$;
                                                        scala.collection.immutable.Seq projects = (scala.collection.immutable.Seq)validToolchains.map((Function1 & Serializable)id -> {
                                                            KernelLogger$.MODULE$.info(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(20).append("Detected toolchain: ").append((String)id).toString()}), new Line(390), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaShellMain.scala"), new Name("projects"));
                                                            BasicTargetParser parser = (BasicTargetParser)Toolchain$.MODULE$.targetParser().apply(id);
                                                            return parser.parseAsProject(workingDir);
                                                        });
                                                        ProjectConfig qual$2 = (ProjectConfig)projects.head();
                                                        String x$339 = shellConfig.createProjectName();
                                                        String x$340 = qual$2.copy$default$2();
                                                        String x$341 = qual$2.copy$default$3();
                                                        String x$342 = qual$2.copy$default$4();
                                                        String x$343 = qual$2.copy$default$5();
                                                        String x$344 = qual$2.copy$default$6();
                                                        scala.collection.immutable.Seq<String> x$345 = qual$2.copy$default$7();
                                                        String x$346 = qual$2.copy$default$8();
                                                        scala.collection.immutable.Seq<String> x$347 = qual$2.copy$default$9();
                                                        Option<String> x$348 = qual$2.copy$default$10();
                                                        scala.collection.immutable.Seq<String> x$349 = qual$2.copy$default$11();
                                                        TargetConfig[] x$350 = qual$2.copy$default$12();
                                                        scala.collection.immutable.Seq<String> x$351 = qual$2.copy$default$13();
                                                        scala.collection.immutable.Seq<String> x$352 = qual$2.copy$default$14();
                                                        Option<ExportConfig> x$353 = qual$2.copy$default$15();
                                                        scala.collection.immutable.Seq<IPInstance> x$354 = qual$2.copy$default$16();
                                                        Option<String> x$355 = qual$2.copy$default$17();
                                                        ProjectConfig project = qual$2.copy(x$339, x$340, x$341, x$342, x$343, x$344, x$345, x$346, x$347, x$348, x$349, x$350, x$351, x$352, x$353, x$354, x$355);
                                                        ProjectConfig$.MODULE$.saveConfig(project, new File(workingDir, "scaleda.yml"));
                                                    } else {
                                                        Enumeration.Value value26 = ShellRunMode$.MODULE$.ParseAST();
                                                        Enumeration.Value value27 = value;
                                                        if (!(value26 != null ? !value26.equals(value27) : value27 != null)) {
                                                            if (shellConfig.parseFilepath().isEmpty()) {
                                                                KernelLogger$.MODULE$.error(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"No file specified"}), new Line(398), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaShellMain.scala"), new Name("main"));
                                                            } else {
                                                                File file = new File(shellConfig.parseFilepath());
                                                                if (!file.exists()) {
                                                                    KernelLogger$.MODULE$.error(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"File not exists"}), new Line(402), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaShellMain.scala"), new Name("main"));
                                                                } else {
                                                                    String ext = shellConfig.parseFileType().isEmpty() ? (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(file.getName()), '.'))) : shellConfig.parseFileType();
                                                                    Option lang = SupportedLanguages$.MODULE$.all().find((Function1 & Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)ScaledaShellMain$.$anonfun$main$54(ext, x$20)));
                                                                    Option option = lang;
                                                                    if (option instanceof Some) {
                                                                        Some some = (Some)option;
                                                                        AbstractLanguage lang2 = (AbstractLanguage)some.value();
                                                                        KernelLogger$.MODULE$.info(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(20).append("Parse file: ").append(file).append(", type: ").append(lang2.getName()).toString()}), new Line(412), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaShellMain.scala"), new Name("main"));
                                                                        FileInputStream inputStream = new FileInputStream(file);
                                                                        CharStream input = CharStreams.fromStream((InputStream)inputStream);
                                                                        Lexer lexer = lang2.lexer(input);
                                                                        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
                                                                        Parser parser = lang2.parser((TokenStream)tokens);
                                                                        ParserRuleContext tree = lang2.ast(parser);
                                                                        Predef$.MODULE$.println((Object)tree.toStringTree(parser));
                                                                    } else {
                                                                        KernelLogger$.MODULE$.error(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"File type not supported"}), new Line(420), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaShellMain.scala"), new Name("main"));
                                                                    }
                                                                }
                                                            }
                                                        } else {
                                                            KernelLogger$.MODULE$.error(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"not implemented."}), new Line(425), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaShellMain.scala"), new Name("main"));
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        stub2.foreach((Function1 & Serializable)x$21 -> (ManagedChannel)((Function0)x$21._2()).apply());
    }

    private ScaledaShellMain$() {
    }
}

