/*
 * Decompiled with CFR 0.152.
 */
package top.scaleda.kernel.shell;

import io.grpc.ManagedChannel;
import io.grpc.StatusRuntimeException;
import java.io.File;
import java.io.Serializable;
import java.util.Date;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import sourcecode.Line;
import sourcecode.Name;
import top.scaleda.kernel.net.RemoteClient$;
import top.scaleda.kernel.net.remote.Empty;
import top.scaleda.kernel.net.remote.Empty$;
import top.scaleda.kernel.net.remote.RemoteGrpc;
import top.scaleda.kernel.net.remote.RemoteInfo;
import top.scaleda.kernel.net.remote.RemoteProfile;
import top.scaleda.kernel.project.ScaledaProject;
import top.scaleda.kernel.project.config.ProjectConfig;
import top.scaleda.kernel.project.config.ProjectConfig$;
import top.scaleda.kernel.project.config.TargetConfig;
import top.scaleda.kernel.project.config.TaskConfig;
import top.scaleda.kernel.project.config.TaskType$;
import top.scaleda.kernel.shell.ScaledaRunHandler;
import top.scaleda.kernel.shell.command.CommandDeps;
import top.scaleda.kernel.shell.command.CommandRunner$;
import top.scaleda.kernel.shell.command.RemoteCommandDeps;
import top.scaleda.kernel.shell.command.RemoteCommandDeps$;
import top.scaleda.kernel.toolchain.Toolchain;
import top.scaleda.kernel.toolchain.Toolchain$;
import top.scaleda.kernel.toolchain.ToolchainPresetProvider;
import top.scaleda.kernel.toolchain.ToolchainProfile;
import top.scaleda.kernel.toolchain.ToolchainProfile$;
import top.scaleda.kernel.toolchain.executor.Executor;
import top.scaleda.kernel.toolchain.executor.ImplementExecutor;
import top.scaleda.kernel.toolchain.executor.ProgrammingExecutor;
import top.scaleda.kernel.toolchain.executor.SimulationExecutor;
import top.scaleda.kernel.toolchain.executor.SynthesisExecutor;
import top.scaleda.kernel.toolchain.runner.ScaledaRunStage$;
import top.scaleda.kernel.toolchain.runner.ScaledaRuntime;
import top.scaleda.kernel.toolchain.runner.ScaledaRuntime$;
import top.scaleda.kernel.utils.EnvironmentUtils$Backup$;
import top.scaleda.kernel.utils.KernelLogger$;

public final class ScaledaRun$ {
    public static final ScaledaRun$ MODULE$ = new ScaledaRun$();

    public ScaledaRuntime preprocess(ScaledaRuntime rt, boolean writeable) {
        ScaledaProject manifest = rt.project();
        if (!rt.executor().workingDir().exists() && !rt.executor().workingDir().mkdirs()) {
            KernelLogger$.MODULE$.warn(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot create working directory!"}), new Line(30), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaRun.scala"), new Name("preprocess"));
        }
        if (!BoxesRunTime.unboxToBoolean((Object)rt.task().custom().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false))) {
            Enumeration.Value value = rt.stage();
            Enumeration.Value value2 = ScaledaRunStage$.MODULE$.Prepare();
            if (!(value != null ? !value.equals(value2) : value2 != null)) {
                None$ none$;
                if (rt.profile().isRemoteProfile()) {
                    Tuple2<RemoteGrpc.RemoteBlockingStub, Function0<ManagedChannel>> tuple2 = RemoteClient$.MODULE$.apply(rt.profile().host(), RemoteClient$.MODULE$.apply$default$2());
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    RemoteGrpc.RemoteBlockingStub client = (RemoteGrpc.RemoteBlockingStub)tuple2._1();
                    Function0 shutdown = (Function0)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)client, (Object)shutdown);
                    RemoteGrpc.RemoteBlockingStub client2 = (RemoteGrpc.RemoteBlockingStub)tuple22._1();
                    Function0 shutdown2 = (Function0)tuple22._2();
                    RemoteInfo remoteInfoReply = client2.getRemoteInfo(Empty$.MODULE$.of());
                    shutdown2.apply();
                    none$ = new Some((Object)remoteInfoReply);
                } else {
                    none$ = None$.MODULE$;
                }
                None$ remoteInfo = none$;
                ScaledaRuntime qual$1 = (ScaledaRuntime)Toolchain$.MODULE$.toolchainPresetHandler().get((Object)rt.target().toolchain()).flatMap(arg_0 -> ScaledaRun$.$anonfun$preprocess$2(rt, (Option)remoteInfo, writeable, arg_0)).getOrElse((Function0 & Serializable)() -> rt);
                Enumeration.Value x$1 = ScaledaRunStage$.MODULE$.PresetDone();
                String x$2 = qual$1.copy$default$1();
                TargetConfig x$3 = qual$1.copy$default$2();
                TaskConfig x$4 = qual$1.copy$default$3();
                ToolchainProfile x$5 = qual$1.copy$default$4();
                Executor x$6 = qual$1.copy$default$5();
                File x$7 = qual$1.copy$default$6();
                Map<String, String> x$8 = qual$1.copy$default$7();
                Map<String, Object> x$9 = qual$1.copy$default$8();
                ScaledaProject x$10 = qual$1.copy$default$10();
                return qual$1.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$1, x$10);
            }
        }
        return rt;
    }

    public void runTask(ScaledaRunHandler handler, ScaledaRuntime rt) {
        None$ none$;
        Predef$.MODULE$.require(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(rt.profile().profileName())), (Function0 & Serializable)() -> "must provide profile before runTask");
        if (rt.profile().isRemoteProfile() && rt.project().projectBase().nonEmpty()) {
            File x$1 = new File((String)rt.project().projectBase().get());
            String x$2 = rt.profile().host();
            String x$3 = rt.id();
            int x$4 = RemoteCommandDeps$.MODULE$.apply$default$3();
            Some some = new Some((Object)new RemoteCommandDeps(x$1, x$2, x$4, x$3));
            none$ = some;
        } else {
            none$ = None$.MODULE$;
        }
        None$ remoteDeps = none$;
        KernelLogger$.MODULE$.info(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(19).append("runTask workingDir=").append(rt.projectBase().getAbsoluteFile()).toString()}), new Line(61), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaRun.scala"), new Name("runTask"));
        Tuple3 info = (Tuple3)Toolchain$.MODULE$.toolchains().apply((Object)rt.target().toolchain());
        Toolchain toolchain = (Toolchain)((Function1)info._2()).apply((Object)rt.executor());
        if (!EnvironmentUtils$Backup$.MODULE$.env().contains((Object)"SKIP_EXECUTION")) {
            Seq commands = (Seq)toolchain.commands(rt.task(), rt.project()).map((Function1 & Serializable)c -> {
                Seq x$5 = rt.extraEnvs().toSeq();
                Seq<String> x$6 = c.copy$default$1();
                String x$7 = c.copy$default$2();
                String x$8 = c.copy$default$4();
                return c.copy(x$6, x$7, (Seq<Tuple2<String, String>>)x$5, x$8);
            });
            try {
                CommandRunner$.MODULE$.executeLocalOrRemote((Option<RemoteCommandDeps>)remoteDeps, (Seq<CommandDeps>)commands, handler, CommandRunner$.MODULE$.executeLocalOrRemote$default$4());
            }
            catch (Throwable e) {
                KernelLogger$.MODULE$.info(ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"Exception", e, "when executing", commands, "on", remoteDeps}), new Line(72), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaRun.scala"), new Name("runTask"));
                throw e;
            }
            return;
        }
        KernelLogger$.MODULE$.warn(ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"Skipped run:", rt}), new Line(76), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaRun.scala"), new Name("runTask"));
    }

    public Thread runTaskBackground(ScaledaRunHandler handler, ScaledaRuntime runtime, boolean daemon) {
        Thread t = new Thread(() -> MODULE$.runTask(handler, runtime), new StringBuilder(9).append("run-task-").append(runtime.id()).toString());
        t.setDaemon(daemon);
        return t;
    }

    public boolean runTaskBackground$default$3() {
        return true;
    }

    private Executor generateExecutor(TargetConfig target, TaskConfig task, ToolchainProfile profile, ScaledaProject project) {
        boolean bl;
        String projectBase = (String)project.projectBase().get();
        String workingDirName = new StringBuilder(1).append(target.name()).append("-").append(task.name()).toString();
        Enumeration.Value value = task.taskType();
        Enumeration.Value value2 = TaskType$.MODULE$.Simulation();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            String testbench = (String)task.findTopModule().get();
            File workingPlace = new File(new File(projectBase, ".sim"), workingDirName);
            return new SimulationExecutor(workingPlace, testbench, new File(workingPlace, new StringBuilder(13).append(testbench).append("_waveform.vcd").toString()), profile);
        }
        Enumeration.Value value4 = TaskType$.MODULE$.Synthesis();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            bl = true;
        } else {
            Enumeration.Value value6 = TaskType$.MODULE$.Implement();
            Enumeration.Value value7 = value;
            if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                bl = true;
            } else {
                Enumeration.Value value8 = TaskType$.MODULE$.Programming();
                Enumeration.Value value9 = value;
                bl = !(value8 != null ? !value8.equals(value9) : value9 != null);
            }
        }
        if (bl) {
            Seq<String> selectedConstraints = task.getConstraints();
            Seq singleFiles = task.getConstraintFiles(project).toSeq();
            KernelLogger$.MODULE$.debug(ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"selectedConstraints", selectedConstraints, "task", task.constraintPaths(), "singleFiles", singleFiles}), new Line(118), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaRun.scala"), new Name("generateExecutor"));
            Seq singleDirs = (Seq)selectedConstraints.flatMap((Function1 & Serializable)path -> {
                File file = new File(projectBase, (String)path);
                if (file.exists() && file.isDirectory()) {
                    return new Some((Object)file);
                }
                return None$.MODULE$;
            });
            Enumeration.Value value10 = task.taskType();
            Enumeration.Value value11 = TaskType$.MODULE$.Synthesis();
            Enumeration.Value value12 = value10;
            if (!(value11 != null ? !value11.equals(value12) : value12 != null)) {
                File x$1 = new File(new File(projectBase, ".synth"), workingDirName);
                String x$2 = (String)task.findTopModule().get();
                ToolchainProfile x$3 = profile;
                Seq x$4 = singleFiles;
                Seq x$5 = singleDirs;
                return new SynthesisExecutor(x$1, x$3, x$2, (Seq<File>)x$4, (Seq<File>)x$5);
            }
            Enumeration.Value value13 = TaskType$.MODULE$.Implement();
            Enumeration.Value value14 = value10;
            if (!(value13 != null ? !value13.equals(value14) : value14 != null)) {
                File x$6 = new File(new File(projectBase, ".impl"), workingDirName);
                String x$7 = (String)task.findTopModule().get();
                ToolchainProfile x$8 = profile;
                Seq x$9 = singleFiles;
                Seq x$10 = singleDirs;
                return new ImplementExecutor(x$6, x$8, x$7, (Seq<File>)x$9, (Seq<File>)x$10);
            }
            Enumeration.Value value15 = TaskType$.MODULE$.Programming();
            Enumeration.Value value16 = value10;
            if (!(value15 != null ? !value15.equals(value16) : value16 != null)) {
                return new ProgrammingExecutor(new File(new File(projectBase, ".impl"), workingDirName), profile, (String)task.findTopModule().get(), (Seq<File>)singleFiles, (Seq<File>)singleDirs);
            }
            throw new MatchError((Object)value10);
        }
        throw new MatchError((Object)value);
    }

    public Option<ScaledaRuntime> generateRuntimeFromName(String targetName, String taskName, String profileName, String profileHost, ScaledaProject project) {
        Option option;
        Object object = new Object();
        try {
            Option<ProjectConfig> configOptional = ProjectConfig$.MODULE$.getConfig(project);
            if (configOptional.isEmpty()) {
                KernelLogger$.MODULE$.warn(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"no configure found"}), new Line(185), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaRun.scala"), new Name("generateRuntimeFromName"));
                return None$.MODULE$;
            }
            ProjectConfig c = (ProjectConfig)configOptional.get();
            option = c.taskByTaskTargetName(taskName, targetName).flatMap((Function1 & Serializable)f -> {
                Option profile;
                Option option;
                Tuple2 tuple2 = f;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TargetConfig target = (TargetConfig)tuple2._1();
                TaskConfig task = (TaskConfig)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)target, (Object)task);
                TargetConfig target2 = (TargetConfig)tuple22._1();
                TaskConfig task2 = (TaskConfig)tuple22._2();
                None$ remoteProfiles = None$.MODULE$;
                String profileHostUse = (String)task2.host().getOrElse((Function0 & Serializable)() -> profileHost);
                KernelLogger$.MODULE$.debug(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(16).append("profileHostUse: ").append(profileHostUse).toString()}), new Line(194), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaRun.scala"), new Name("generateRuntimeFromName"));
                if (profileHostUse == null || profileHostUse.isEmpty()) {
                    option = Toolchain$.MODULE$.profiles(Toolchain$.MODULE$.profiles$default$1(), Toolchain$.MODULE$.profiles$default$2()).find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ScaledaRun$.$anonfun$generateRuntimeFromName$3(target2, profileName, p)));
                } else {
                    try {
                        Tuple2<RemoteGrpc.RemoteBlockingStub, Function0<ManagedChannel>> tuple23 = RemoteClient$.MODULE$.apply(profileHostUse, RemoteClient$.MODULE$.apply$default$2());
                        if (tuple23 == null) {
                            throw new MatchError(tuple23);
                        }
                        RemoteGrpc.RemoteBlockingStub client = (RemoteGrpc.RemoteBlockingStub)tuple23._1();
                        Function0 shutdown = (Function0)tuple23._2();
                        Tuple2 tuple24 = new Tuple2((Object)client, (Object)shutdown);
                        RemoteGrpc.RemoteBlockingStub client2 = (RemoteGrpc.RemoteBlockingStub)tuple24._1();
                        Function0 shutdown2 = (Function0)tuple24._2();
                        try {
                            remoteProfiles = new Some(client2.getProfiles(new Empty(Empty$.MODULE$.apply$default$1())).profiles().map((Function1 & Serializable)p -> ToolchainProfile$.MODULE$.asRemoteToolchainProfile((RemoteProfile)p, profileHostUse)));
                        }
                        finally {
                            shutdown2.apply();
                        }
                    }
                    catch (StatusRuntimeException e) {
                        KernelLogger$.MODULE$.warn(ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"Cannot load profiles from host", profileHostUse, e}), new Line(217), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaRun.scala"), new Name("profile"));
                        throw new NonLocalReturnControl(object, (Object)None$.MODULE$);
                    }
                    option = profile = ((IterableOnceOps)remoteProfiles.get()).find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ScaledaRun$.$anonfun$generateRuntimeFromName$5(target2, profileName, p)));
                }
                if (profile.isEmpty()) {
                    KernelLogger$.MODULE$.warn(ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"Cannot specify profile! profiles:", Toolchain$.MODULE$.profiles(Toolchain$.MODULE$.profiles$default$1(), Toolchain$.MODULE$.profiles$default$2())}), new Line(224), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/shell/ScaledaRun.scala"), new Name("generateRuntimeFromName"));
                    return None$.MODULE$;
                }
                String runtimeId = new StringBuilder(3).append(target2.toolchain()).append("-").append(target2.name()).append("-").append(task2.name()).append("-").append(new Date()).toString();
                Executor executor = MODULE$.generateExecutor(target2, task2, (ToolchainProfile)profile.get(), project);
                File projectBase = new File((String)project.projectBase().get());
                String x$1 = runtimeId;
                TargetConfig x$2 = target2;
                TaskConfig x$3 = task2;
                ToolchainProfile x$4 = (ToolchainProfile)profile.get();
                Executor x$5 = executor;
                File x$6 = projectBase;
                ScaledaProject x$7 = project;
                Map<String, String> x$8 = ScaledaRuntime$.MODULE$.apply$default$7();
                Map<String, Object> x$9 = ScaledaRuntime$.MODULE$.apply$default$8();
                Enumeration.Value x$10 = ScaledaRuntime$.MODULE$.apply$default$9();
                ScaledaRuntime runtime = new ScaledaRuntime(x$1, x$2, x$3, x$4, x$5, x$6, x$8, x$9, x$10, x$7);
                return new Some((Object)runtime);
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    public static final /* synthetic */ Option $anonfun$preprocess$2(ScaledaRuntime rt$1, Option remoteInfo$1, boolean writeable$1, ToolchainPresetProvider x$2) {
        return x$2.handlePreset(rt$1, (Option<RemoteInfo>)remoteInfo$1, writeable$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$generateRuntimeFromName$3(TargetConfig target$1, String profileName$1, ToolchainProfile p) {
        String string = p.toolchainType();
        String string2 = target$1.toolchain();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = p.profileName();
        String string4 = profileName$1;
        if (string3 == null) {
            if (string4 == null) return true;
        } else if (string3.equals(string4)) return true;
        if (!profileName$1.isEmpty()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$generateRuntimeFromName$5(TargetConfig target$1, String profileName$1, ToolchainProfile p) {
        String string = p.toolchainType();
        String string2 = target$1.toolchain();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = p.profileName();
        String string4 = profileName$1;
        if (string3 == null) {
            if (string4 == null) return true;
        } else if (string3.equals(string4)) return true;
        if (!profileName$1.isEmpty()) return false;
        return true;
    }

    private ScaledaRun$() {
    }
}

