/*
 * Decompiled with CFR 0.152.
 */
package top.scaleda.kernel.net.user;

import java.io.File;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import sourcecode.Line;
import sourcecode.Name;
import top.scaleda.kernel.net.user.UserTokenBean;
import top.scaleda.kernel.net.user.UserTokenBean$;
import top.scaleda.kernel.utils.EnvironmentUtils$Backup$;
import top.scaleda.kernel.utils.KernelLogger$;
import top.scaleda.kernel.utils.Paths$;
import top.scaleda.kernel.utils.serialise.YAMLHelper$;

public final class ScaledaAuthorizationProvider$ {
    public static final ScaledaAuthorizationProvider$ MODULE$ = new ScaledaAuthorizationProvider$();

    public Seq<UserTokenBean> loadTokenPair() {
        Seq loaded;
        Seq seq;
        None$ extras = EnvironmentUtils$Backup$.MODULE$.env().contains((Object)"AUTH_DEV_MODE") ? new Some((Object)UserTokenBean$.MODULE$.TEST_MODE_PAIR()) : None$.MODULE$;
        File file = Paths$.MODULE$.getUserAuthorization();
        boolean hasError = false;
        try {
            Seq loaded2 = YAMLHelper$.MODULE$.apply(file, Seq.class);
            Predef$.MODULE$.require(loaded2 instanceof Seq);
            seq = (Seq)loaded2.map((Function1 & Serializable)m -> UserTokenBean$.MODULE$.fromMap((Map<String, String>)m));
        }
        catch (Throwable e) {
            KernelLogger$.MODULE$.warn(ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"Error when loading authorizations", e, "save default file"}), new Line(22), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/net/user/ScaledaAuthorizationProvider.scala"), new Name("loaded"));
            hasError = true;
            seq = loaded = (Seq)Nil$.MODULE$;
        }
        if (hasError) {
            this.saveTokenPairs((Seq<UserTokenBean>)loaded);
        }
        Seq result = extras.nonEmpty() ? (Seq)loaded.$colon$plus(extras.get()) : loaded;
        Predef$.MODULE$.require(result instanceof Seq);
        result.headOption().foreach((Function1 & Serializable)t -> {
            Predef$.MODULE$.require(t instanceof UserTokenBean);
            return BoxedUnit.UNIT;
        });
        return result;
    }

    public Option<UserTokenBean> loadByHost(String host) {
        return this.loadTokenPair().find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ScaledaAuthorizationProvider$.$anonfun$loadByHost$1(host, x$1)));
    }

    public void saveTokenPair(UserTokenBean tokenPair) {
        Seq loaded = (Seq)this.loadTokenPair().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ScaledaAuthorizationProvider$.$anonfun$saveTokenPair$1(tokenPair, x$2)));
        Seq appended = (Seq)((SeqOps)loaded.filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ScaledaAuthorizationProvider$.$anonfun$saveTokenPair$2(p)))).$colon$plus((Object)tokenPair);
        YAMLHelper$.MODULE$.apply(appended, Paths$.MODULE$.getUserAuthorization());
    }

    public void saveTokenPairs(Seq<UserTokenBean> tokenPairs) {
        File file = Paths$.MODULE$.getUserAuthorization();
        Set hostNames = ((IterableOnceOps)tokenPairs.map((Function1 & Serializable)x$3 -> x$3.host())).toSet();
        Seq data = ((IterableOnceOps)hostNames.map((Function1 & Serializable)host -> ((UserTokenBean)tokenPairs.find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ScaledaAuthorizationProvider$.$anonfun$saveTokenPairs$3(host, x$4))).get()).toMap())).toSeq();
        YAMLHelper$.MODULE$.apply(data, file);
    }

    private UserTokenBean getPairByHost(String host) {
        return (UserTokenBean)this.loadByHost(host).getOrElse((Function0 & Serializable)() -> new UserTokenBean(host, UserTokenBean$.MODULE$.apply$default$2(), UserTokenBean$.MODULE$.apply$default$3(), UserTokenBean$.MODULE$.apply$default$4()));
    }

    public void updateToken(String host, String token) {
        UserTokenBean tokenPair = this.getPairByHost(host);
        String x$1 = token;
        String x$2 = tokenPair.copy$default$1();
        String x$3 = tokenPair.copy$default$2();
        String x$4 = tokenPair.copy$default$4();
        UserTokenBean newTokenPair = tokenPair.copy(x$2, x$3, x$1, x$4);
        this.saveTokenPair(newTokenPair);
    }

    public void updateRefreshToken(String host, String refreshToken) {
        UserTokenBean qual$1 = this.getPairByHost(host);
        String x$1 = refreshToken;
        String x$2 = qual$1.copy$default$1();
        String x$3 = qual$1.copy$default$2();
        String x$4 = qual$1.copy$default$4();
        UserTokenBean tokenPair = qual$1.copy(x$2, x$3, x$1, x$4);
        String x$5 = refreshToken;
        String x$6 = tokenPair.copy$default$1();
        String x$7 = tokenPair.copy$default$2();
        String x$8 = tokenPair.copy$default$3();
        UserTokenBean newTokenPair = tokenPair.copy(x$6, x$7, x$8, x$5);
        this.saveTokenPair(newTokenPair);
    }

    public void updateUsername(String host, String username) {
        UserTokenBean tokenPair = this.getPairByHost(host);
        String x$1 = username;
        String x$2 = tokenPair.copy$default$1();
        String x$3 = tokenPair.copy$default$3();
        String x$4 = tokenPair.copy$default$4();
        UserTokenBean newTokenPair = tokenPair.copy(x$2, x$1, x$3, x$4);
        this.saveTokenPair(newTokenPair);
    }

    public static final /* synthetic */ boolean $anonfun$loadByHost$1(String host$1, UserTokenBean x$1) {
        String string = x$1.host();
        String string2 = host$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$saveTokenPair$1(UserTokenBean tokenPair$1, UserTokenBean x$2) {
        return !x$2.host().equals(tokenPair$1.host());
    }

    public static final /* synthetic */ boolean $anonfun$saveTokenPair$2(UserTokenBean p) {
        return !p.equals(UserTokenBean$.MODULE$.TEST_MODE_PAIR());
    }

    public static final /* synthetic */ boolean $anonfun$saveTokenPairs$3(String host$2, UserTokenBean x$4) {
        String string = x$4.host();
        String string2 = host$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private ScaledaAuthorizationProvider$() {
    }
}

