/*
 * Decompiled with CFR 0.152.
 */
package top.scaleda.kernel.net.user;

import com.auth0.jwt.exceptions.JWTVerificationException;
import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.HashSet;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import sourcecode.File;
import sourcecode.Line;
import sourcecode.Name;
import top.scaleda.kernel.database.ScaledaDatabase;
import top.scaleda.kernel.database.ScaledaDatabase$;
import top.scaleda.kernel.database.dao.User;
import top.scaleda.kernel.net.user.JwtAuthorizationInterceptor$;
import top.scaleda.kernel.utils.KernelLogger$;

@ScalaSignature(bytes="\u0006\u0005\u0005eb\u0001\u0002\u0007\u000e\u0001aA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\u0006\u007f\u0001!\t\u0001\u0011\u0005\u0006\t\u0002!\t%R\u0004\u0006Y6A\t!\u001c\u0004\u0006\u00195A\tA\u001c\u0005\u0006\u007f\u0015!\tA\u001d\u0005\bg\u0016\u0011\r\u0011\"\u0002u\u0011\u0019qX\u0001)A\u0007k\"Aq0\u0002b\u0001\n\u000b\t\t\u0001\u0003\u0005\u0002 \u0015\u0001\u000bQBA\u0002\u0011%\t\t#BI\u0001\n\u0003\t\u0019CA\u000eKoR\fU\u000f\u001e5pe&T\u0018\r^5p]&sG/\u001a:dKB$xN\u001d\u0006\u0003\u001d=\tA!^:fe*\u0011\u0001#E\u0001\u0004]\u0016$(B\u0001\n\u0014\u0003\u0019YWM\u001d8fY*\u0011A#F\u0001\bg\u000e\fG.\u001a3b\u0015\u00051\u0012a\u0001;pa\u000e\u00011c\u0001\u0001\u001aCA\u0011!dH\u0007\u00027)\u0011A$H\u0001\u0005Y\u0006twMC\u0001\u001f\u0003\u0011Q\u0017M^1\n\u0005\u0001Z\"AB(cU\u0016\u001cG\u000f\u0005\u0002#O5\t1E\u0003\u0002%K\u0005!qM\u001d9d\u0015\u00051\u0013AA5p\u0013\tA3EA\tTKJ4XM]%oi\u0016\u00148-\u001a9u_J\fA\u0002]1tgN+'O^5dKN\u00042a\u000b\u001a5\u001b\u0005a#BA\u0017/\u0003%IW.\\;uC\ndWM\u0003\u00020a\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003E\nQa]2bY\u0006L!a\r\u0017\u0003\u000f!\u000b7\u000f[*fiB\u0011Q\u0007\u0010\b\u0003mi\u0002\"a\u000e\u0019\u000e\u0003aR!!O\f\u0002\rq\u0012xn\u001c;?\u0013\tY\u0004'\u0001\u0004Qe\u0016$WMZ\u0005\u0003{y\u0012aa\u0015;sS:<'BA\u001e1\u0003\u0019a\u0014N\\5u}Q\u0011\u0011i\u0011\t\u0003\u0005\u0002i\u0011!\u0004\u0005\bS\t\u0001\n\u00111\u0001+\u00035Ig\u000e^3sG\u0016\u0004HoQ1mYV\u0019a\t\u00151\u0015\t\u001dS&m\u001a\t\u0004\u0011.seB\u0001\u0012J\u0013\tQ5%\u0001\u0006TKJ4XM]\"bY2L!\u0001T'\u0003\u00111K7\u000f^3oKJT!AS\u0012\u0011\u0005=\u0003F\u0002\u0001\u0003\u0006#\u000e\u0011\rA\u0015\u0002\u0005%\u0016\fH+\u0005\u0002T/B\u0011A+V\u0007\u0002a%\u0011a\u000b\r\u0002\b\u001d>$\b.\u001b8h!\t!\u0006,\u0003\u0002Za\t\u0019\u0011I\\=\t\u000bm\u001b\u0001\u0019\u0001/\u0002\u0015M,'O^3s\u0007\u0006dG\u000e\u0005\u0003#;:{\u0016B\u00010$\u0005)\u0019VM\u001d<fe\u000e\u000bG\u000e\u001c\t\u0003\u001f\u0002$Q!Y\u0002C\u0002I\u0013QAU3taRCQaY\u0002A\u0002\u0011\f\u0001\"\\3uC\u0012\fG/\u0019\t\u0003E\u0015L!AZ\u0012\u0003\u00115+G/\u00193bi\u0006DQ\u0001[\u0002A\u0002%\fAA\\3yiB!!E\u001b(`\u0013\tY7EA\tTKJ4XM]\"bY2D\u0015M\u001c3mKJ\f1DS<u\u0003V$\bn\u001c:ju\u0006$\u0018n\u001c8J]R,'oY3qi>\u0014\bC\u0001\"\u0006'\t)q\u000e\u0005\u0002Ua&\u0011\u0011\u000f\r\u0002\u0007\u0003:L(+\u001a4\u0015\u00035\fa#Q+U\u0011>\u0013\u0016JW!U\u0013>su,T#U\u0003~[U)W\u000b\u0002kB\u0019a/\u001f?\u000f\u0005\t:\u0018B\u0001=$\u0003!iU\r^1eCR\f\u0017B\u0001>|\u0005\rYU-\u001f\u0006\u0003q\u000e\u0002\"AG?\n\u0005uZ\u0012aF!V)\"{%+\u0013.B)&{ejX'F)\u0006{6*R-!\u0003Q)6+\u0012*O\u00036+ulQ(O)\u0016CFkX&F3V\u0011\u00111\u0001\t\u0007\u0003\u000b\tY!a\u0004\u000f\u0007\t\n9!C\u0002\u0002\n\r\nqaQ8oi\u0016DH/C\u0002{\u0003\u001bQ1!!\u0003$!\u0011\t\t\"a\u0007\u000e\u0005\u0005M!\u0002BA\u000b\u0003/\t1\u0001Z1p\u0015\r\tI\"E\u0001\tI\u0006$\u0018MY1tK&!\u0011QDA\n\u0005\u0011)6/\u001a:\u0002+U\u001bVI\u0015(B\u001b\u0016{6i\u0014(U\u000bb#vlS#ZA\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE*\"!!\n+\u0007)\n9c\u000b\u0002\u0002*A!\u00111FA\u001b\u001b\t\tiC\u0003\u0003\u00020\u0005E\u0012!C;oG\",7m[3e\u0015\r\t\u0019\u0004M\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u001c\u0003[\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class JwtAuthorizationInterceptor
implements ServerInterceptor {
    private final HashSet<String> passServices;

    public static HashSet<String> $lessinit$greater$default$1() {
        return JwtAuthorizationInterceptor$.MODULE$.$lessinit$greater$default$1();
    }

    public static Context.Key<User> USERNAME_CONTEXT_KEY() {
        return JwtAuthorizationInterceptor$.MODULE$.USERNAME_CONTEXT_KEY();
    }

    public static Metadata.Key<String> AUTHORIZATION_META_KEY() {
        return JwtAuthorizationInterceptor$.MODULE$.AUTHORIZATION_META_KEY();
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> next) {
        KernelLogger$.MODULE$.debug(ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"metadata keys", metadata.keys()}), new Line(22), new File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/net/user/JwtAuthorizationInterceptor.scala"), new Name("interceptCall"));
        MethodDescriptor m = serverCall.getMethodDescriptor();
        String serviceName = (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(m.getServiceName()), '.')));
        KernelLogger$.MODULE$.debug(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"serviceName", serviceName}), new Line(25), new File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/net/user/JwtAuthorizationInterceptor.scala"), new Name("interceptCall"));
        ServerCall.Listener defaultResp = Contexts.interceptCall((Context)Context.current(), serverCall, (Metadata)metadata, next);
        if (this.passServices.contains((Object)serviceName)) {
            return defaultResp;
        }
        String token = (String)metadata.get(JwtAuthorizationInterceptor$.MODULE$.AUTHORIZATION_META_KEY());
        if (ScaledaDatabase$.MODULE$.passTokenSet().contains((Object)token)) {
            Context ctx = Context.current().withValue(JwtAuthorizationInterceptor$.MODULE$.USERNAME_CONTEXT_KEY(), ScaledaDatabase$.MODULE$.passTokenSet().apply((Object)token));
            return Contexts.interceptCall((Context)ctx, serverCall, (Metadata)metadata, next);
        }
        Status status = Status.OK;
        if (token == null) {
            status = Status.UNAUTHENTICATED.withDescription("Authorization token is missing");
        } else {
            Option<User> claims = None$.MODULE$;
            try {
                ScaledaDatabase db = new ScaledaDatabase();
                Option<User> found = db.tokenToUser(token);
                if (found.isEmpty()) {
                    throw new JWTVerificationException("Invalid token");
                }
                claims = found;
            }
            catch (JWTVerificationException e) {
                status = Status.UNAUTHENTICATED.withDescription(e.getMessage()).withCause((Throwable)e);
            }
            if (claims.isDefined()) {
                Context ctx = Context.current().withValue(JwtAuthorizationInterceptor$.MODULE$.USERNAME_CONTEXT_KEY(), claims.get());
                return Contexts.interceptCall((Context)ctx, serverCall, (Metadata)metadata, next);
            }
        }
        serverCall.close(status, new Metadata());
        return new ServerCall.Listener<ReqT>(null){};
    }

    public JwtAuthorizationInterceptor(HashSet<String> passServices) {
        this.passServices = passServices;
    }
}

