/*
 * Decompiled with CFR 0.152.
 */
package top.scaleda.kernel.net.fuse;

import java.io.File;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributes;
import java.util.concurrent.TimeUnit;
import jnr.ffi.Pointer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.serce.jnrfuse.ErrorCodes;
import ru.serce.jnrfuse.FuseFillDir;
import ru.serce.jnrfuse.FuseStubFS;
import ru.serce.jnrfuse.struct.FileStat;
import ru.serce.jnrfuse.struct.FuseFileInfo;
import ru.serce.jnrfuse.struct.Statvfs;
import ru.serce.jnrfuse.struct.Timespec;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;
import scala.sys.process.ProcessLogger$;
import top.scaleda.kernel.net.fuse.FuseUtils$;
import top.scaleda.kernel.net.fuse.LocalFuse$;
import top.scaleda.kernel.utils.OS$;

@ScalaSignature(bytes="\u0006\u0005\t\u0005f\u0001\u0002\u0017.\u0001aB\u0001b\u0011\u0001\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\u0006#\u0002!\tA\u0015\u0005\b-\u0002\u0011\r\u0011\"\u0003X\u0011\u0019\u0001\u0007\u0001)A\u00051\")\u0011\r\u0001C\tE\")Q\u000e\u0001C!]\")A\u0010\u0001C!{\"9\u0011Q\u0004\u0001\u0005B\u0005}\u0001bBA\u0016\u0001\u0011\u0005\u0013Q\u0006\u0005\b\u0003g\u0001A\u0011IA\u001b\u0011\u001d\tI\u0004\u0001C!\u0003wAq!a\u0010\u0001\t\u0003\n\t\u0005C\u0004\u0002L\u0001!\t%!\u0014\t\u000f\u0005M\u0003\u0001\"\u0011\u0002V!9\u00111\f\u0001\u0005B\u0005u\u0003bBA2\u0001\u0011\u0005\u0013Q\r\u0005\b\u0003c\u0002A\u0011IA:\u0011\u001d\tI\b\u0001C!\u0003wBq!!#\u0001\t\u0003\nY\tC\u0004\u0002\u001a\u0002!\t%a'\t\u000f\u0005\u001d\u0006\u0001\"\u0011\u0002*\"9\u0011q\u0017\u0001\u0005B\u0005e\u0006bBA`\u0001\u0011\u0005\u0013\u0011\u0019\u0005\b\u0003\u000f\u0004A\u0011IAe\u0011\u001d\t\u0019\u000e\u0001C!\u0003+Dq!a:\u0001\t\u0003\nI\u000fC\u0004\u0002t\u0002!\t%!>\t\u000f\u0005}\b\u0001\"\u0011\u0003\u0002!9!q\u0001\u0001\u0005B\t%\u0001b\u0002B\b\u0001\u0011\u0005#\u0011\u0003\u0005\b\u0005K\u0001A\u0011\tB\u0014\u0011\u001d\u0011i\u0003\u0001C!\u0005_AqA!\u000e\u0001\t\u0003\u00129\u0004C\u0004\u0003>\u0001!\tEa\u0010\t\u000f\t-\u0003\u0001\"\u0011\u0003N!9!Q\u000b\u0001\u0005B\t]\u0003b\u0002B0\u0001\u0011\u0005#\u0011\r\u0005\b\u0005S\u0002A\u0011\tB6\u0011\u001d\u0011\u0019\b\u0001C!\u0005k:qA!#.\u0011\u0003\u0011YI\u0002\u0004-[!\u0005!Q\u0012\u0005\u0007#&\"\tA!&\t\u000f\t]\u0015\u0006\"\u0001\u0003\u001a\nIAj\\2bY\u001a+8/\u001a\u0006\u0003]=\nAAZ;tK*\u0011\u0001'M\u0001\u0004]\u0016$(B\u0001\u001a4\u0003\u0019YWM\u001d8fY*\u0011A'N\u0001\bg\u000e\fG.\u001a3b\u0015\u00051\u0014a\u0001;pa\u000e\u00011C\u0001\u0001:!\tQ\u0014)D\u0001<\u0015\taT(A\u0004k]J4Wo]3\u000b\u0005yz\u0014!B:fe\u000e,'\"\u0001!\u0002\u0005I,\u0018B\u0001\"<\u0005)1Uo]3TiV\u0014giU\u0001\u000bg>,(oY3QCRD\u0007CA#O\u001d\t1E\n\u0005\u0002H\u00156\t\u0001J\u0003\u0002Jo\u00051AH]8pizR\u0011aS\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b*\u000ba\u0001\u0015:fI\u00164\u0017BA(Q\u0005\u0019\u0019FO]5oO*\u0011QJS\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005M+\u0006C\u0001+\u0001\u001b\u0005i\u0003\"B\"\u0003\u0001\u0004!\u0015A\u00027pO\u001e,'/F\u0001Y!\tIf,D\u0001[\u0015\tYF,A\u0003tY\u001a$$NC\u0001^\u0003\ry'oZ\u0005\u0003?j\u0013a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\bO\u0016$h)\u001b7f)\t\u00197\u000e\u0005\u0002eS6\tQM\u0003\u0002gO\u0006\u0011\u0011n\u001c\u0006\u0002Q\u0006!!.\u0019<b\u0013\tQWM\u0001\u0003GS2,\u0007\"\u00027\u0006\u0001\u0004!\u0015\u0001\u00029bi\"\fqaZ3uCR$(\u000fF\u0002pgR\u0004\"\u0001]9\u000e\u0003)K!A\u001d&\u0003\u0007%sG\u000fC\u0003m\r\u0001\u0007A\tC\u0003v\r\u0001\u0007a/\u0001\u0003ti\u0006$\bCA<{\u001b\u0005A(BA=<\u0003\u0019\u0019HO];di&\u00111\u0010\u001f\u0002\t\r&dWm\u0015;bi\u0006A!/Z1eY&t7\u000eF\u0003p}~\f\u0019\u0002C\u0003m\u000f\u0001\u0007A\tC\u0004\u0002\u0002\u001d\u0001\r!a\u0001\u0002\u0007\t,h\r\u0005\u0003\u0002\u0006\u0005=QBAA\u0004\u0015\u0011\tI!a\u0003\u0002\u0007\u00194\u0017N\u0003\u0002\u0002\u000e\u0005\u0019!N\u001c:\n\t\u0005E\u0011q\u0001\u0002\b!>Lg\u000e^3s\u0011\u001d\t)b\u0002a\u0001\u0003/\tAa]5{KB\u0019\u0001/!\u0007\n\u0007\u0005m!J\u0001\u0003M_:<\u0017!B7l]>$GcB8\u0002\"\u0005\r\u0012q\u0005\u0005\u0006Y\"\u0001\r\u0001\u0012\u0005\b\u0003KA\u0001\u0019AA\f\u0003\u0011iw\u000eZ3\t\u000f\u0005%\u0002\u00021\u0001\u0002\u0018\u0005!!\u000fZ3w\u0003\u0015i7\u000eZ5s)\u0015y\u0017qFA\u0019\u0011\u0015a\u0017\u00021\u0001E\u0011\u001d\t)#\u0003a\u0001\u0003/\ta!\u001e8mS:\\GcA8\u00028!)AN\u0003a\u0001\t\u0006)!/\u001c3jeR\u0019q.!\u0010\t\u000b1\\\u0001\u0019\u0001#\u0002\u000fMLX\u000e\\5oWR)q.a\u0011\u0002H!1\u0011Q\t\u0007A\u0002\u0011\u000bqa\u001c7ea\u0006$\b\u000e\u0003\u0004\u0002J1\u0001\r\u0001R\u0001\b]\u0016<\b/\u0019;i\u0003\u0019\u0011XM\\1nKR)q.a\u0014\u0002R!1\u0011QI\u0007A\u0002\u0011Ca!!\u0013\u000e\u0001\u0004!\u0015\u0001\u00027j].$Ra\\A,\u00033Ba!!\u0012\u000f\u0001\u0004!\u0005BBA%\u001d\u0001\u0007A)A\u0003dQ6|G\rF\u0003p\u0003?\n\t\u0007C\u0003m\u001f\u0001\u0007A\tC\u0004\u0002&=\u0001\r!a\u0006\u0002\u000b\rDwn\u001e8\u0015\u000f=\f9'!\u001b\u0002n!)A\u000e\u0005a\u0001\t\"9\u00111\u000e\tA\u0002\u0005]\u0011aA;jI\"9\u0011q\u000e\tA\u0002\u0005]\u0011aA4jI\u0006AAO];oG\u0006$X\rF\u0003p\u0003k\n9\bC\u0003m#\u0001\u0007A\tC\u0004\u0002\u0016E\u0001\r!a\u0006\u0002\t=\u0004XM\u001c\u000b\u0006_\u0006u\u0014q\u0010\u0005\u0006YJ\u0001\r\u0001\u0012\u0005\b\u0003\u0003\u0013\u0002\u0019AAB\u0003\t1\u0017\u000eE\u0002x\u0003\u000bK1!a\"y\u000511Uo]3GS2,\u0017J\u001c4p\u0003\u0011\u0011X-\u00193\u0015\u0017=\fi)a$\u0002\u0012\u0006M\u0015q\u0013\u0005\u0006YN\u0001\r\u0001\u0012\u0005\b\u0003\u0003\u0019\u0002\u0019AA\u0002\u0011\u001d\t)b\u0005a\u0001\u0003/Aq!!&\u0014\u0001\u0004\t9\"\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\b\u0003\u0003\u001b\u0002\u0019AAB\u0003\u00159(/\u001b;f)-y\u0017QTAP\u0003C\u000b\u0019+!*\t\u000b1$\u0002\u0019\u0001#\t\u000f\u0005\u0005A\u00031\u0001\u0002\u0004!9\u0011Q\u0003\u000bA\u0002\u0005]\u0001bBAK)\u0001\u0007\u0011q\u0003\u0005\b\u0003\u0003#\u0002\u0019AAB\u0003\u0019\u0019H/\u0019;ggR)q.a+\u0002.\")A.\u0006a\u0001\t\"9\u0011qV\u000bA\u0002\u0005E\u0016!B:uEV4\u0007cA<\u00024&\u0019\u0011Q\u0017=\u0003\u000fM#\u0018\r\u001e<gg\u0006)a\r\\;tQR)q.a/\u0002>\")AN\u0006a\u0001\t\"9\u0011\u0011\u0011\fA\u0002\u0005\r\u0015a\u0002:fY\u0016\f7/\u001a\u000b\u0006_\u0006\r\u0017Q\u0019\u0005\u0006Y^\u0001\r\u0001\u0012\u0005\b\u0003\u0003;\u0002\u0019AAB\u0003\u001517/\u001f8d)\u001dy\u00171ZAg\u0003#DQ\u0001\u001c\rA\u0002\u0011Ca!a4\u0019\u0001\u0004y\u0017AC5tI\u0006$\u0018m]=oG\"9\u0011\u0011\u0011\rA\u0002\u0005\r\u0015\u0001C:fib\fG\u000f\u001e:\u0015\u0017=\f9.!7\u0002^\u0006\u0005\u00181\u001d\u0005\u0006Yf\u0001\r\u0001\u0012\u0005\u0007\u00037L\u0002\u0019\u0001#\u0002\t9\fW.\u001a\u0005\b\u0003?L\u0002\u0019AA\u0002\u0003\u00151\u0018\r\\;f\u0011\u001d\t)\"\u0007a\u0001\u0003/Aa!!:\u001a\u0001\u0004y\u0017!\u00024mC\u001e\u001c\u0018\u0001C4fib\fG\u000f\u001e:\u0015\u0013=\fY/!<\u0002p\u0006E\b\"\u00027\u001b\u0001\u0004!\u0005BBAn5\u0001\u0007A\tC\u0004\u0002`j\u0001\r!a\u0001\t\u000f\u0005U!\u00041\u0001\u0002\u0018\u0005IA.[:uq\u0006$HO\u001d\u000b\b_\u0006]\u0018\u0011`A\u007f\u0011\u0015a7\u00041\u0001E\u0011\u001d\tYp\u0007a\u0001\u0003\u0007\tA\u0001\\5ti\"9\u0011QC\u000eA\u0002\u0005]\u0011a\u0003:f[>4X\r_1uiJ$Ra\u001cB\u0002\u0005\u000bAQ\u0001\u001c\u000fA\u0002\u0011Ca!a7\u001d\u0001\u0004!\u0015aB8qK:$\u0017N\u001d\u000b\u0006_\n-!Q\u0002\u0005\u0006Yv\u0001\r\u0001\u0012\u0005\b\u0003\u0003k\u0002\u0019AAB\u0003\u001d\u0011X-\u00193eSJ$2b\u001cB\n\u0005+\u00119B!\t\u0003$!)AN\ba\u0001\t\"9\u0011\u0011\u0001\u0010A\u0002\u0005\r\u0001b\u0002B\r=\u0001\u0007!1D\u0001\u0007M&dG/\u001a:\u0011\u0007i\u0012i\"C\u0002\u0003 m\u00121BR;tK\u001aKG\u000e\u001c#je\"9\u0011Q\u0013\u0010A\u0002\u0005]\u0001bBAA=\u0001\u0007\u00111Q\u0001\u000be\u0016dW-Y:fI&\u0014H#B8\u0003*\t-\u0002\"\u00027 \u0001\u0004!\u0005bBAA?\u0001\u0007\u00111Q\u0001\tMNLhn\u00193jeR)qN!\r\u00034!)A\u000e\ta\u0001\t\"9\u0011\u0011\u0011\u0011A\u0002\u0005\r\u0015\u0001B5oSR$B!a\u0001\u0003:!9!1H\u0011A\u0002\u0005\r\u0011\u0001B2p]:\fq\u0001Z3tiJ|\u0017\u0010\u0006\u0003\u0003B\t\u001d\u0003c\u00019\u0003D%\u0019!Q\t&\u0003\tUs\u0017\u000e\u001e\u0005\b\u0005\u0013\u0012\u0003\u0019AA\u0002\u0003)Ig.\u001b;SKN,H\u000e^\u0001\u0007C\u000e\u001cWm]:\u0015\u000b=\u0014yE!\u0015\t\u000b1\u001c\u0003\u0019\u0001#\t\r\tM3\u00051\u0001p\u0003\u0011i\u0017m]6\u0002\r\r\u0014X-\u0019;f)\u001dy'\u0011\fB.\u0005;BQ\u0001\u001c\u0013A\u0002\u0011Cq!!\n%\u0001\u0004\t9\u0002C\u0004\u0002\u0002\u0012\u0002\r!a!\u0002\u0013\u0019$(/\u001e8dCR,GcB8\u0003d\t\u0015$q\r\u0005\u0006Y\u0016\u0002\r\u0001\u0012\u0005\b\u0003+)\u0003\u0019AA\f\u0011\u001d\t\t)\na\u0001\u0003\u0007\u000b\u0001BZ4fi\u0006$HO\u001d\u000b\b_\n5$q\u000eB9\u0011\u0015ag\u00051\u0001E\u0011\u0019\tyK\na\u0001m\"9\u0011\u0011\u0011\u0014A\u0002\u0005\r\u0015aB;uS6,gn\u001d\u000b\u0006_\n]$\u0011\u0010\u0005\u0006Y\u001e\u0002\r\u0001\u0012\u0005\b\u0005w:\u0003\u0019\u0001B?\u0003!!\u0018.\\3ta\u0016\u001c\u0007#\u00029\u0003\u0000\t\r\u0015b\u0001BA\u0015\n)\u0011I\u001d:bsB\u0019qO!\"\n\u0007\t\u001d\u0005P\u0001\u0005US6,7\u000f]3d\u0003%aunY1m\rV\u001cX\r\u0005\u0002USM\u0019\u0011Fa$\u0011\u0007A\u0014\t*C\u0002\u0003\u0014*\u0013a!\u00118z%\u00164GC\u0001BF\u0003\u0015yV.Y5o)\u0011\u0011\tEa'\t\u000f\tu5\u00061\u0001\u0003 \u0006!\u0011M]4t!\u0011\u0001(q\u0010#")
public class LocalFuse
extends FuseStubFS {
    private final String sourcePath;
    private final Logger logger;

    public static void _main(String[] args) {
        LocalFuse$.MODULE$._main(args);
    }

    private Logger logger() {
        return this.logger;
    }

    public File getFile(String path) {
        return new File(this.sourcePath, path);
    }

    public int getattr(String path, FileStat stat) {
        File file = this.getFile(path);
        if (!file.exists()) {
            return -ErrorCodes.ENOENT();
        }
        int mode = FuseUtils$.MODULE$.fileAttrsUnixToInt(file);
        if (Files.isSymbolicLink(file.toPath())) {
            mode = mode & 0xFFF | 0xA000;
        }
        Path p = file.toPath();
        PosixFileAttributes attrs = Files.readAttributes(p, PosixFileAttributes.class, new LinkOption[0]);
        long size = attrs.size();
        stat.st_size.set((Number)Predef$.MODULE$.long2Long(size));
        stat.st_mode.set((Number)Predef$.MODULE$.int2Integer(mode));
        stat.st_atim.tv_sec.set(attrs.lastAccessTime().to(TimeUnit.SECONDS));
        stat.st_mtim.tv_sec.set(attrs.lastModifiedTime().to(TimeUnit.SECONDS));
        this.logger().debug(new StringBuilder(33).append("getattr(").append(path).append("), file: ").append(file.getAbsolutePath()).append(", mode: ").append(Integer.toOctalString(mode)).append(", size: ").append(size).toString());
        return 0;
    }

    public int readlink(String path, Pointer buf, long size) {
        this.logger().debug(new StringBuilder(15).append("readlink(path=").append(path).append(")").toString());
        File file = this.getFile(path);
        if (!Files.isSymbolicLink(file.toPath())) {
            return -ErrorCodes.ENOENT();
        }
        String run = new StringBuilder(9).append("readlink ").append(file.getAbsolutePath()).toString();
        ArrayBuffer array = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        int r = scala.sys.process.package$.MODULE$.stringToProcess(run).$bang(ProcessLogger$.MODULE$.apply((Function1 & Serializable)stdout -> {
            array.addOne((Object)stdout);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)x$1 -> {
            LocalFuse.$anonfun$readlink$2(x$1);
            return BoxedUnit.UNIT;
        }));
        String res = array.mkString("");
        int len = package$.MODULE$.min(res.length(), (int)size);
        buf.put(0L, res.getBytes(), 0, len);
        buf.putByte((long)len, (byte)0);
        return 0;
    }

    public int mknod(String path, long mode, long rdev) {
        this.logger().debug("mknod");
        return super.mknod(path, mode, rdev);
    }

    public int mkdir(String path, long mode) {
        this.logger().debug(new StringBuilder(19).append("mkdir(path=").append(path).append(", mode=").append(Integer.toOctalString((int)mode)).append(")").toString());
        File file = this.getFile(path);
        if (file.exists() || file.exists() && file.isFile()) {
            return -ErrorCodes.ENOENT();
        }
        scala.sys.process.package$.MODULE$.stringToProcess(new StringBuilder(6).append("mkdir ").append(file.getAbsolutePath()).toString()).$bang();
        return this.chmod(path, mode);
    }

    public int unlink(String path) {
        this.logger().debug(new StringBuilder(13).append("unlink(path=").append(path).append(")").toString());
        File file = this.getFile(path);
        if (!file.exists()) {
            return -ErrorCodes.ENOENT();
        }
        if (file.exists() && file.isDirectory()) {
            return -ErrorCodes.EISDIR();
        }
        file.delete();
        return 0;
    }

    public int rmdir(String path) {
        File file = this.getFile(path);
        if (!file.exists() || file.exists() && file.isFile()) {
            return -ErrorCodes.ENOENT();
        }
        file.delete();
        return 0;
    }

    public int symlink(String oldpath, String newpath) {
        this.logger().debug(new StringBuilder(19).append("symlink(old=").append(oldpath).append(", new=").append(newpath).append(")").toString());
        File fileOld = new File(oldpath);
        File fileNew = this.getFile(newpath);
        Files.createSymbolicLink(fileNew.toPath(), fileOld.toPath(), new FileAttribute[0]);
        return 0;
    }

    public int rename(String oldpath, String newpath) {
        File fileOld = this.getFile(oldpath);
        File fileNew = this.getFile(newpath);
        scala.sys.process.package$.MODULE$.stringToProcess(new StringBuilder(4).append("mv ").append(fileOld.getAbsolutePath()).append(" ").append(fileNew.getAbsolutePath()).toString()).$bang();
        return 0;
    }

    public int link(String oldpath, String newpath) {
        this.logger().debug("link");
        return super.link(oldpath, newpath);
    }

    public int chmod(String path, long mode) {
        File file = this.getFile(path);
        String run = new StringBuilder(7).append("chmod ").append(Integer.toOctalString((int)mode & 0xFFF)).append(" ").append(file.getAbsolutePath()).toString();
        this.logger().debug(new StringBuilder(26).append("chmod(path=").append(path).append(", mode=").append(Integer.toOctalString((int)mode)).append("), run: ").append(run).toString());
        int r = scala.sys.process.package$.MODULE$.stringToProcess(run).$bang();
        if (r == 0) {
            return 0;
        }
        return -ErrorCodes.ENOENT();
    }

    public int chown(String path, long uid, long gid) {
        this.logger().debug("chown");
        return super.chown(path, uid, gid);
    }

    public int truncate(String path, long size) {
        this.logger().debug(new StringBuilder(22).append("truncate(path=").append(path).append(", size=").append(size).append(")").toString());
        return super.truncate(path, size);
    }

    public int open(String path, FuseFileInfo fi) {
        this.logger().debug(new StringBuilder(11).append("open(path=").append(path).append(")").toString());
        return super.open(path, fi);
    }

    public int read(String path, Pointer buf, long size, long offset, FuseFileInfo fi) {
        File file = this.getFile(path);
        if (!file.exists()) {
            return -ErrorCodes.ENOENT();
        }
        if (file.isDirectory()) {
            return -ErrorCodes.EISDIR();
        }
        this.logger().debug(new StringBuilder(27).append("read(path=").append(path).append(", size=").append(size).append(", offset=").append(offset).append(")").toString());
        RandomAccessFile rf = new RandomAccessFile(file, "r");
        rf.seek(offset);
        byte[] data = new byte[(int)size];
        rf.read(data, 0, (int)size);
        buf.put(0L, data, 0, data.length);
        return data.length;
    }

    public int write(String path, Pointer buf, long size, long offset, FuseFileInfo fi) {
        int n;
        this.logger().debug(new StringBuilder(28).append("write(path=").append(path).append(", size=").append(size).append(", offset=").append(offset).append(")").toString());
        File file = this.getFile(path);
        if (!file.exists()) {
            return -ErrorCodes.ENOENT();
        }
        if (file.isDirectory()) {
            return -ErrorCodes.EISDIR();
        }
        try {
            RandomAccessFile rf = new RandomAccessFile(file, "rw");
            rf.seek(offset);
            byte[] data = new byte[(int)size];
            buf.get(0L, data, 0, (int)size);
            rf.write(data);
            rf.close();
            n = (int)size;
        }
        catch (Throwable e) {
            this.logger().error(new StringBuilder(18).append("ERROR when write: ").append(e).toString());
            throw e;
        }
        return n;
    }

    public int statfs(String path, Statvfs stbuf) {
        this.logger().debug("statfs");
        return super.statfs(path, stbuf);
    }

    public int flush(String path, FuseFileInfo fi) {
        this.logger().debug("flush");
        return super.flush(path, fi);
    }

    public int release(String path, FuseFileInfo fi) {
        this.logger().debug("release");
        return super.release(path, fi);
    }

    public int fsync(String path, int isdatasync, FuseFileInfo fi) {
        this.logger().debug("fsync");
        return super.fsync(path, isdatasync, fi);
    }

    public int setxattr(String path, String name, Pointer value, long size, int flags) {
        this.logger().debug(new StringBuilder(29).append("setxattr(path=").append(path).append(", name=").append(name).append(", size=").append(size).append(")").toString());
        return super.setxattr(path, name, value, size, flags);
    }

    public int getxattr(String path, String name, Pointer value, long size) {
        File file = this.getFile(path);
        this.logger().debug(new StringBuilder(36).append("getxattr(path=").append(path).append(", name=").append(name).append(", size=").append(size).append(") file: ").append(file.getAbsoluteFile()).toString());
        if (!file.exists()) {
            return -ErrorCodes.ENOENT();
        }
        return super.getxattr(path, name, value, size);
    }

    public int listxattr(String path, Pointer list, long size) {
        this.logger().debug("listxattr");
        return super.listxattr(path, list, size);
    }

    public int removexattr(String path, String name) {
        this.logger().debug("removexattr");
        return super.removexattr(path, name);
    }

    public int opendir(String path, FuseFileInfo fi) {
        this.logger().debug("opendir");
        return super.opendir(path, fi);
    }

    public int readdir(String path, Pointer buf, FuseFillDir filter, long offset, FuseFileInfo fi) {
        File file = this.getFile(path);
        if (!file.exists() || !file.isDirectory()) {
            return -ErrorCodes.ENOENT();
        }
        LongRef offsetNow = LongRef.create((long)offset);
        this.logger().debug(new StringBuilder(30).append("readdir(path=").append(path).append(", offset=").append(offset).append("), file=").append(file.getAbsolutePath()).toString());
        File[] list = file.listFiles();
        this.logger().debug(new StringBuilder(14).append("listed files: ").append(Predef$.MODULE$.wrapRefArray((Object[])list).mkString(", ")).toString());
        Object object = offsetNow.elem == 0L ? BoxesRunTime.boxToInteger((int)LocalFuse.applyFilter$1(".", offsetNow, filter, buf)) : BoxedUnit.UNIT;
        Object object2 = offsetNow.elem == 1L ? BoxesRunTime.boxToInteger((int)LocalFuse.applyFilter$1("..", offsetNow, filter, buf)) : BoxedUnit.UNIT;
        if ((long)(list.length + 2) == offsetNow.elem) {
            return 0;
        }
        if ((long)(list.length + 2) < offsetNow.elem) {
            return -ErrorCodes.ENOENT();
        }
        return BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.refArrayOps((Object[])list), (int)offsetNow.elem - 2, list.length))).map((Function1 & Serializable)f -> BoxesRunTime.boxToInteger((int)LocalFuse.$anonfun$readdir$1(this, offsetNow, filter, buf, f))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -ErrorCodes.ENOENT()));
    }

    public int releasedir(String path, FuseFileInfo fi) {
        this.logger().debug("releasedir");
        return super.releasedir(path, fi);
    }

    public int fsyncdir(String path, FuseFileInfo fi) {
        this.logger().debug("fsyncdir");
        return super.fsyncdir(path, fi);
    }

    public Pointer init(Pointer conn) {
        this.logger().debug("init");
        return null;
    }

    public void destroy(Pointer initResult) {
        this.logger().debug("destroy");
    }

    public int access(String path, int mask) {
        this.logger().debug("access");
        return super.access(path, mask);
    }

    public int create(String path, long mode, FuseFileInfo fi) {
        this.logger().debug(new StringBuilder(20).append("create(path=").append(path).append(", mode=").append(Integer.toOctalString((int)mode)).append(")").toString());
        File file = this.getFile(path);
        if (file.exists() && file.isDirectory()) {
            return -ErrorCodes.EISDIR();
        }
        if (!file.createNewFile()) {
            return -ErrorCodes.EIO();
        }
        return this.chmod(path, mode);
    }

    public int ftruncate(String path, long size, FuseFileInfo fi) {
        this.logger().debug("ftruncate");
        return super.ftruncate(path, size, fi);
    }

    public int fgetattr(String path, FileStat stbuf, FuseFileInfo fi) {
        this.logger().debug("fgetattr");
        return super.fgetattr(path, stbuf, fi);
    }

    public int utimens(String path, Timespec[] timespec) {
        this.logger().debug(new StringBuilder(26).append("utimens(path=").append(path).append(", timespec: ").append(Predef$.MODULE$.wrapRefArray((Object[])timespec).mkString(", ")).append(")").toString());
        File file = this.getFile(path);
        if (!file.exists()) {
            return -ErrorCodes.ENOENT();
        }
        scala.sys.process.package$.MODULE$.stringToProcess(new StringBuilder(6).append("touch ").append(file.getAbsolutePath()).toString()).$bang();
        return 0;
    }

    public static final /* synthetic */ void $anonfun$readlink$2(String x$1) {
    }

    private static final int applyFilter$1(String filename, LongRef offsetNow$1, FuseFillDir filter$1, Pointer buf$1) {
        ByteBuffer nameBuffer = ByteBuffer.allocate(filename.length() + 1);
        nameBuffer.put(filename.getBytes(), 0, filename.length());
        ++offsetNow$1.elem;
        filter$1.apply(buf$1, nameBuffer, null, offsetNow$1.elem);
        return 0;
    }

    public static final /* synthetic */ int $anonfun$readdir$1(LocalFuse $this, LongRef offsetNow$1, FuseFillDir filter$1, Pointer buf$1, File f) {
        $this.logger().debug(new StringBuilder(30).append("readdir: putting file ").append(f.getAbsolutePath()).append(", name: ").append(f.getName()).toString());
        return LocalFuse.applyFilter$1(f.getName(), offsetNow$1, filter$1, buf$1);
    }

    public LocalFuse(String sourcePath) {
        this.sourcePath = sourcePath;
        this.logger = LoggerFactory.getLogger((Class)this.getClass());
        Predef$.MODULE$.require(!OS$.MODULE$.isWindows());
    }
}

