/*
 * Decompiled with CFR 0.152.
 */
package top.scaleda.kernel.net.fuse;

import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import ru.serce.jnrfuse.FuseException;
import ru.serce.jnrfuse.FuseStubFS;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.sys.process.package$;
import sourcecode.Line;
import sourcecode.Name;
import top.scaleda.kernel.utils.KernelFileUtils$;
import top.scaleda.kernel.utils.KernelLogger$;
import top.scaleda.kernel.utils.OS$;

public final class FuseUtils$ {
    public static final FuseUtils$ MODULE$ = new FuseUtils$();
    private static final boolean debug = true;

    public boolean debug() {
        return debug;
    }

    public void mountFs(FuseStubFS fs, String mountPoint, boolean blocking) {
        try {
            Object object;
            KernelLogger$.MODULE$.warn(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(12).append("mounting to ").append(mountPoint).toString()}), new Line(29), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/net/fuse/FuseUtils.scala"), new Name("mountFs"));
            Path path = Paths.get(mountPoint, new String[0]);
            File file = new File(mountPoint);
            if (!file.exists()) {
                KernelLogger$.MODULE$.info(ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"creating dirs with returns:", BoxesRunTime.boxToBoolean((boolean)file.mkdirs())}), new Line(33), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/net/fuse/FuseUtils.scala"), new Name("mountFs"));
            }
            if (OS$.MODULE$.isWindows()) {
                if (file.exists()) {
                    if (file.isFile()) {
                        object = BoxesRunTime.boxToBoolean((boolean)file.delete());
                    } else {
                        KernelFileUtils$.MODULE$.deleteDirectory(file.toPath());
                        object = BoxedUnit.UNIT;
                    }
                } else {
                    file.mkdirs();
                    KernelFileUtils$.MODULE$.deleteDirectory(file.toPath());
                    object = BoxedUnit.UNIT;
                }
            } else {
                object = BoxedUnit.UNIT;
            }
            try {
                this.doMount$1(path, blocking, fs);
            }
            catch (FuseException e) {
                Object object2;
                KernelLogger$.MODULE$.warn(ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"retrying mount:", e}), new Line(54), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/net/fuse/FuseUtils.scala"), new Name("mountFs"));
                if (!OS$.MODULE$.isWindows()) {
                    try {
                        object2 = BoxesRunTime.boxToInteger((int)package$.MODULE$.stringToProcess(new StringBuilder(9).append("umount \"").append(mountPoint).append("\"").toString()).$bang());
                    }
                    catch (Throwable e2) {
                        KernelLogger$.MODULE$.warn(ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"cannot umount:", e2}), new Line(59), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/net/fuse/FuseUtils.scala"), new Name("mountFs"));
                        object2 = BoxedUnit.UNIT;
                    }
                } else {
                    fs.umount();
                    object2 = BoxedUnit.UNIT;
                }
                this.doMount$1(path, blocking, fs);
            }
        }
        catch (InterruptedException e) {
            KernelLogger$.MODULE$.warn(ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"mount interrupted cause:", e}), new Line(66), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/net/fuse/FuseUtils.scala"), new Name("mountFs"));
        }
    }

    public boolean mountFs$default$3() {
        return true;
    }

    public String fileAttrsUnixString(File file) {
        Path path = file.toPath();
        PosixFileAttributes attrs = Files.readAttributes(path, PosixFileAttributes.class, new LinkOption[0]);
        Set<PosixFilePermission> perms = attrs.permissions();
        return PosixFilePermissions.toString(perms);
    }

    public int fileAttrsToInt(File file, String str) {
        return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 3).map((Function1)(JFunction1.mcII.sp & Serializable)x$1 -> x$1 * 3).map((Function1)(JFunction1.mcII.sp & Serializable)i -> FuseUtils$.groupToInt$1(StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(str), i, i + 3)) << 6 - i)).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) | (file.isDirectory() ? 4 : 8) << 12;
    }

    public int fileAttrsUnixToInt(File file) {
        String str = this.fileAttrsUnixString(file);
        return this.fileAttrsToInt(file, str);
    }

    public void printTextToFile(String content, File file) {
        Object object;
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            object = BoxesRunTime.boxToInteger((int)package$.MODULE$.stringToProcess(new StringBuilder(6).append("touch ").append(file.getAbsoluteFile()).toString()).$bang());
        } else {
            object = BoxedUnit.UNIT;
        }
        PrintWriter printer = new PrintWriter(file);
        printer.print(content);
        printer.close();
    }

    public void loadLibraries() {
        if (OS$.MODULE$.isWindows()) {
            return;
        }
    }

    private final void doMount$1(Path path$1, boolean blocking$1, FuseStubFS fs$1) {
        String[] options = (String[])((Object[])new String[]{"-o", "allow_other", "-o", "fsname=scaleda-fs"});
        KernelLogger$.MODULE$.info(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(55).append("doMount(path=").append(path$1).append(", blocking=").append(blocking$1).append(", debug=").append(this.debug()).append("), target path exists: ").append(path$1.toFile().exists()).toString()}), new Line(45), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/net/fuse/FuseUtils.scala"), new Name("doMount"));
        fs$1.mount(path$1, blocking$1, this.debug(), options);
    }

    private static final int bitToInt$1(char c) {
        if (c == '-') {
            return 0;
        }
        return 1;
    }

    private static final int groupToInt$1(String group) {
        return BoxesRunTime.unboxToInt((Object)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 3).map((Function1)(JFunction1.mcII.sp & Serializable)i -> FuseUtils$.bitToInt$1(group.charAt(i)) << 2 - i).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    private FuseUtils$() {
    }
}

