/*
 * Decompiled with CFR 0.152.
 */
package top.scaleda.kernel.database;

import com.auth0.jwt.interfaces.Payload;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import sourcecode.Line;
import sourcecode.Name;
import top.scaleda.kernel.auth.JwtManager$;
import top.scaleda.kernel.database.ScaledaDatabase$;
import top.scaleda.kernel.database.UserException;
import top.scaleda.kernel.database.dao.Token;
import top.scaleda.kernel.database.dao.User;
import top.scaleda.kernel.utils.EnvironmentUtils$Backup$;
import top.scaleda.kernel.utils.KernelLogger$;
import top.scaleda.kernel.utils.Paths$;

@ScalaSignature(bytes="\u0006\u0005\u0005}d\u0001B\u0010!\u0001%BQ\u0001\r\u0001\u0005\u0002EBq\u0001\u000e\u0001C\u0002\u0013%Q\u0007\u0003\u0004B\u0001\u0001\u0006IA\u000e\u0005\n\u0005\u0002\u0001\r\u00111A\u0005\n\rC\u0011\u0002\u0014\u0001A\u0002\u0003\u0007I\u0011B'\t\u0013M\u0003\u0001\u0019!A!B\u0013!\u0005\"\u0002+\u0001\t\u0013)\u0006\"\u0002,\u0001\t\u0003\u0019\u0005\"B,\u0001\t\u0013A\u0006\"B.\u0001\t\u0013)\u0006\"\u0002/\u0001\t\u0013)\u0006\"B/\u0001\t\u0003)\u0006\"\u00020\u0001\t\u0003y\u0006b\u00028\u0001#\u0003%\ta\u001c\u0005\u0006u\u0002!\ta\u001f\u0005\t\u0003\u001f\u0001\u0011\u0013!C\u0001_\"9\u0011\u0011\u0003\u0001\u0005\u0002\u0005M\u0001bBA\r\u0001\u0011\u0005\u00111\u0004\u0005\b\u0003?\u0001A\u0011AA\u0011\u0011\u001d\ti\u0003\u0001C\u0001\u0003_Aq!a\u000f\u0001\t\u0003\ti\u0004C\u0005\u0002Z\u0001\t\n\u0011\"\u0001\u0002\\!9\u0011q\f\u0001\u0005\u0002\u0005\u0005\u0004bBA4\u0001\u0011\u0005\u0011\u0011\u000e\u0005\u0007\u0003[\u0002A\u0011A+\b\u000f\u0005=\u0004\u0005#\u0001\u0002r\u00191q\u0004\tE\u0001\u0003gBa\u0001M\u000e\u0005\u0002\u0005U\u0004\"CA<7\t\u0007I\u0011AA=\u0011!\tih\u0007Q\u0001\n\u0005m$aD*dC2,G-\u0019#bi\u0006\u0014\u0017m]3\u000b\u0005\u0005\u0012\u0013\u0001\u00033bi\u0006\u0014\u0017m]3\u000b\u0005\r\"\u0013AB6fe:,GN\u0003\u0002&M\u000591oY1mK\u0012\f'\"A\u0014\u0002\u0007Q|\u0007o\u0001\u0001\u0014\u0005\u0001Q\u0003CA\u0016/\u001b\u0005a#\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=b#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002eA\u00111\u0007A\u0007\u0002A\u00059!\u000e\u001a2d+JdW#\u0001\u001c\u0011\u0005]rdB\u0001\u001d=!\tID&D\u0001;\u0015\tY\u0004&\u0001\u0004=e>|GOP\u0005\u0003{1\na\u0001\u0015:fI\u00164\u0017BA A\u0005\u0019\u0019FO]5oO*\u0011Q\bL\u0001\tU\u0012\u00147-\u0016:mA\u0005\u0001\u0012N\u001c8fe~\u001bwN\u001c8fGRLwN\\\u000b\u0002\tB\u0011QIS\u0007\u0002\r*\u0011q\tS\u0001\u0004gFd'\"A%\u0002\t)\fg/Y\u0005\u0003\u0017\u001a\u0013!bQ8o]\u0016\u001cG/[8o\u0003QIgN\\3s?\u000e|gN\\3di&|gn\u0018\u0013fcR\u0011a*\u0015\t\u0003W=K!\u0001\u0015\u0017\u0003\tUs\u0017\u000e\u001e\u0005\b%\u0016\t\t\u00111\u0001E\u0003\rAH%M\u0001\u0012S:tWM]0d_:tWm\u0019;j_:\u0004\u0013!\u00033p\u0007>tg.Z2u)\u0005q\u0015!D4fi\u000e{gN\\3di&|g.A\nm_\u0006$7+\u001d7Ge>l'+Z:pkJ\u001cW\r\u0006\u000273\")!,\u0003a\u0001m\u0005!\u0001/\u0019;i\u00039)\b\u000fZ1uK\u0012\u000bG/\u00192bg\u0016\fA\u0002\u001a:pa\u0012\u000bG/\u00192bg\u0016\f!CZ8sG\u0016\u001cE.Z1o\t\u0006$\u0018MY1tK\u0006Aa-\u001b8e+N,'\u000fF\u0002aS.\u00042aK1d\u0013\t\u0011GF\u0001\u0004PaRLwN\u001c\t\u0003I\u001el\u0011!\u001a\u0006\u0003M\u0002\n1\u0001Z1p\u0013\tAWM\u0001\u0003Vg\u0016\u0014\b\"\u00026\u000e\u0001\u00041\u0014\u0001C;tKJt\u0017-\\3\t\u000f1l\u0001\u0013!a\u0001[\u0006A\u0001/Y:to>\u0014H\rE\u0002,CZ\n!CZ5oIV\u001bXM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\t\u0001O\u000b\u0002nc.\n!\u000f\u0005\u0002tq6\tAO\u0003\u0002vm\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003o2\n!\"\u00198o_R\fG/[8o\u0013\tIHOA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f!b]3mK\u000e$Xk]3s)\u0015a\u00181BA\u0007!\u0011i\u0018QA2\u000f\u0007y\f\tA\u0004\u0002:\u007f&\tQ&C\u0002\u0002\u00041\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\b\u0005%!aA*fc*\u0019\u00111\u0001\u0017\t\u000b)|\u0001\u0019\u0001\u001c\t\u000f1|\u0001\u0013!a\u0001[\u0006!2/\u001a7fGR,6/\u001a:%I\u00164\u0017-\u001e7uII\n!\"\u001b8tKJ$Xk]3s)\rq\u0015Q\u0003\u0005\u0007\u0003/\t\u0002\u0019A2\u0002\tU\u001cXM]\u0001\u000bI\u0016dW\r^3Vg\u0016\u0014Hc\u0001(\u0002\u001e!)!N\u0005a\u0001m\u000512\r[3dW\u0006sG-\u00169eCR,\u0007+Y:to>\u0014H\rF\u0004O\u0003G\t)#!\u000b\t\u000b)\u001c\u0002\u0019\u0001\u001c\t\r\u0005\u001d2\u00031\u00017\u0003-yG\u000e\u001a)bgN<xN\u001d3\t\r\u0005-2\u00031\u00017\u0003-qWm\u001e)bgN<xN\u001d3\u0002\u001bU\u001cXM]!vi\"|'/\u001b;z)\u0019\t\t$a\u000e\u0002:A\u00191&a\r\n\u0007\u0005UBFA\u0004C_>dW-\u00198\t\u000b)$\u0002\u0019\u0001\u001c\t\u000b1$\u0002\u0019\u0001\u001c\u0002\u0017\r\u0014X-\u0019;f)>\\WM\u001c\u000b\u0007\u0003\u007f\t9%!\u0013\u0011\t-\n\u0017\u0011\t\t\u0004I\u0006\r\u0013bAA#K\n)Ak\\6f]\")!.\u0006a\u0001m!I\u00111J\u000b\u0011\u0002\u0003\u0007\u0011QJ\u0001\taJ|g/\u001b3feB11&a\u0014\u0002T5L1!!\u0015-\u0005%1UO\\2uS>t\u0017\u0007E\u00038\u0003+2d'C\u0002\u0002X\u0001\u00131!T1q\u0003U\u0019'/Z1uKR{7.\u001a8%I\u00164\u0017-\u001e7uII*\"!!\u0018+\u0007\u00055\u0013/A\u0005gS:$Gk\\6f]R!\u0011qHA2\u0011\u0019\t)g\u0006a\u0001m\u0005)Ao\\6f]\u0006YAo\\6f]R{Wk]3s)\r\u0001\u00171\u000e\u0005\u0007\u0003KB\u0002\u0019\u0001\u001c\u0002%5\fg.^1mYf\u001cE.Z1o)>\\WM\\\u0001\u0010'\u000e\fG.\u001a3b\t\u0006$\u0018MY1tKB\u00111gG\n\u00037)\"\"!!\u001d\u0002\u0019A\f7o\u001d+pW\u0016t7+\u001a;\u0016\u0005\u0005m\u0004#B\u001c\u0002VY\u001a\u0017!\u00049bgN$vn[3o'\u0016$\b\u0005")
public class ScaledaDatabase {
    private final String jdbcUrl = (String)EnvironmentUtils$Backup$.MODULE$.env().getOrElse((Object)"JDBC_URL", (Function0 & Serializable)() -> new StringBuilder(12).append("jdbc:sqlite:").append(new File(Paths$.MODULE$.getDatabaseDir(), "scaleda.sqlite").getAbsolutePath()).toString());
    private Connection inner_connection;

    public static Map<String, User> passTokenSet() {
        return ScaledaDatabase$.MODULE$.passTokenSet();
    }

    private String jdbcUrl() {
        return this.jdbcUrl;
    }

    private Connection inner_connection() {
        return this.inner_connection;
    }

    private void inner_connection_$eq(Connection x$1) {
        this.inner_connection = x$1;
    }

    private void doConnect() {
        if (this.inner_connection() != null && !this.inner_connection().isClosed()) {
            this.inner_connection().close();
        }
        try {
            this.inner_connection_$eq(DriverManager.getConnection(this.jdbcUrl()));
        }
        catch (SQLException e) {
            KernelLogger$.MODULE$.error(ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"cannot load database:", e}), new Line(28), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/database/ScaledaDatabase.scala"), new Name("doConnect"));
            try {
                if (this.inner_connection() != null) {
                    this.inner_connection().close();
                }
            }
            catch (SQLException e2) {
                KernelLogger$.MODULE$.error(ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"cannot close inner_connection when exit", e2}), new Line(33), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/database/ScaledaDatabase.scala"), new Name("doConnect"));
            }
        }
        if (this.inner_connection() != null) {
            this.inner_connection().setAutoCommit(true);
            return;
        }
    }

    public Connection getConnection() {
        block0: {
            if (this.inner_connection() != null && (this.inner_connection() == null || !this.inner_connection().isClosed())) break block0;
            this.doConnect();
        }
        return this.inner_connection();
    }

    private String loadSqlFromResource(String path) {
        return IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream(path), (String)"UTF-8");
    }

    private void updateDatabase() {
        String sqlUpdate = this.loadSqlFromResource("database/scaleda.sql");
        Statement statementUpdate = this.getConnection().createStatement();
        statementUpdate.setQueryTimeout(30);
        statementUpdate.executeUpdate(sqlUpdate);
        statementUpdate.close();
    }

    private void dropDatabase() {
        String sqlDrop = this.loadSqlFromResource("database/drop.sql");
        Statement statementDrop = this.getConnection().createStatement();
        statementDrop.setQueryTimeout(30);
        statementDrop.executeUpdate(sqlDrop);
        statementDrop.close();
    }

    public void forceCleanDatabase() {
        this.dropDatabase();
        this.updateDatabase();
    }

    public Option<User> findUser(String username, Option<String> password) {
        return this.selectUser(username, password).headOption();
    }

    public Option<String> findUser$default$2() {
        return None$.MODULE$;
    }

    public Seq<User> selectUser(String username, Option<String> password2) {
        PreparedStatement preparing = password2.isDefined() ? this.getConnection().prepareStatement("SELECT username,password,nickname FROM t_user WHERE username=? AND password=?") : this.getConnection().prepareStatement("SELECT username,password,nickname FROM t_user WHERE username=?");
        preparing.setString(1, username);
        password2.foreach((Function1 & Serializable)password -> {
            preparing.setString(2, password);
            return BoxedUnit.UNIT;
        });
        ResultSet resultSet = preparing.executeQuery();
        ArrayBuffer result = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (resultSet.next()) {
            User user = new User();
            user.setUsername(resultSet.getString("username"));
            user.setPassword(resultSet.getString("password"));
            user.setNickname(resultSet.getString("nickname"));
            result.addOne((Object)user);
        }
        resultSet.close();
        preparing.close();
        return result.toSeq();
    }

    public Option<String> selectUser$default$2() {
        return None$.MODULE$;
    }

    public void insertUser(User user) {
        Option<User> userNow = this.findUser(user.getUsername(), this.findUser$default$2());
        if (userNow.isDefined()) {
            throw new UserException("Username exists");
        }
        PreparedStatement preparing = this.getConnection().prepareStatement("INSERT INTO t_user (username, password, nickname) VALUES (?, ?, ?)");
        ((IterableOnceOps)new .colon.colon((Object)user.getUsername(), (List)new .colon.colon((Object)user.getPassword(), (List)new .colon.colon((Object)user.getNickname(), (List)Nil$.MODULE$))).zipWithIndex()).foreach((Function1 & Serializable)t -> {
            preparing.setString(t._2$mcI$sp() + 1, (String)t._1());
            return BoxedUnit.UNIT;
        });
        preparing.executeUpdate();
        preparing.close();
    }

    public void deleteUser(String username) {
        PreparedStatement preparing = this.getConnection().prepareStatement("DELETE FROM t_user WHERE username=?");
        preparing.setString(1, username);
        preparing.executeUpdate();
        preparing.close();
    }

    public void checkAndUpdatePassword(String username, String oldPassword, String newPassword) {
        Option<User> userNow = this.findUser(username, (Option<String>)new Some((Object)oldPassword));
        if (userNow.isEmpty()) {
            throw new UserException("Username or password error");
        }
        PreparedStatement preparing = this.getConnection().prepareStatement("UPDATE t_user SET password=? WHERE username=?");
        preparing.setString(1, newPassword);
        preparing.setString(2, username);
        preparing.executeUpdate();
        preparing.close();
    }

    public boolean userAuthority(String username, String password) {
        PreparedStatement preparing = this.getConnection().prepareStatement("SELECT * FROM t_user WHERE username=? AND password=?");
        preparing.setString(1, username);
        preparing.setString(2, password);
        ResultSet resultSet = preparing.executeQuery();
        boolean ok = resultSet.next();
        resultSet.close();
        preparing.close();
        return ok;
    }

    public Option<Token> createToken(String username, Function1<Map<String, String>, Option<String>> provider) {
        Option tokenOptional = (Option)provider.apply(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"username"), (Object)username)})));
        if (tokenOptional.isEmpty()) {
            return None$.MODULE$;
        }
        String token = (String)tokenOptional.get();
        Option<Token> existToken = this.findToken(token);
        if (existToken.isDefined()) {
            return this.createToken(username, provider);
        }
        Date exp = ((Payload)JwtManager$.MODULE$.decode(token).get()).getExpiresAt();
        PreparedStatement preparing = this.getConnection().prepareStatement("INSERT INTO t_token (token, username, exp) VALUES (?, ?, ?)");
        preparing.setString(1, token);
        preparing.setString(2, username);
        preparing.setTimestamp(3, Timestamp.from(exp.toInstant()));
        preparing.executeUpdate();
        preparing.close();
        this.manuallyCleanToken();
        return new Some((Object)new Token(token, username, exp));
    }

    public Function1<Map<String, String>, Option<String>> createToken$default$2() {
        return (Function1 & Serializable)claims -> {
            Map x$1 = claims;
            Duration x$2 = JwtManager$.MODULE$.createToken$default$1();
            return JwtManager$.MODULE$.createToken(x$2, (Map<String, String>)x$1);
        };
    }

    public Option<Token> findToken(String token) {
        PreparedStatement preparing = this.getConnection().prepareStatement("SELECT token, username, exp FROM t_token WHERE token=? AND exp >= ?");
        preparing.setString(1, token);
        preparing.setTimestamp(2, Timestamp.from(Instant.now()));
        ResultSet resultSet = preparing.executeQuery();
        ArrayBuffer result = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (resultSet.next()) {
            Token t = new Token();
            t.setToken(resultSet.getString("token"));
            t.setUsername(resultSet.getString("username"));
            t.setExp(resultSet.getTimestamp("exp"));
            result.addOne((Object)t);
        }
        resultSet.close();
        preparing.close();
        this.manuallyCleanToken();
        return result.headOption();
    }

    public Option<User> tokenToUser(String token) {
        return this.findToken(token).flatMap((Function1 & Serializable)t -> this.findUser(t.getUsername(), this.findUser$default$2()));
    }

    public void manuallyCleanToken() {
        PreparedStatement preparing = this.getConnection().prepareStatement("DELETE FROM t_token WHERE exp < ?");
        preparing.setTimestamp(1, Timestamp.from(Instant.now()));
        preparing.executeUpdate();
        preparing.close();
    }

    public ScaledaDatabase() {
        this.doConnect();
        this.updateDatabase();
    }
}

