/*
 * Decompiled with CFR 0.152.
 */
package top.scaleda.kernel.bin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Path;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import sourcecode.Line;
import sourcecode.Name;
import top.scaleda.kernel.bin.SvlsAssetsHelper$;
import top.scaleda.kernel.bin.VeribleAssetsHelper$;
import top.scaleda.kernel.utils.KernelLogger$;
import top.scaleda.kernel.utils.Paths$;

public final class ExtractAssets$ {
    public static final ExtractAssets$ MODULE$ = new ExtractAssets$();
    private static final int ASSET_VERSION = 5;
    private static final int SMALL_FILE_SIZE = 10240;
    private static final File targetBinaryDirectory = Paths$.MODULE$.getBinaryDir();
    private static final Seq<String> binaryList = (Seq)((IterableOps)((IterableOps)new .colon.colon((Object)"rvcd", (List)new .colon.colon((Object)"rvcd.exe", (List)Nil$.MODULE$)).$plus$plus((IterableOnce)new .colon.colon((Object)"surfer", (List)new .colon.colon((Object)"surfer.exe", (List)Nil$.MODULE$)))).$plus$plus(VeribleAssetsHelper$.MODULE$.allVeribleAssets())).$plus$plus(SvlsAssetsHelper$.MODULE$.allAssets());
    private static final Seq<String> textList = new .colon.colon((Object)"scripts/vivado_call.tcl", (List)new .colon.colon((Object)"ip/scaleda_bram/bram2.v.j2", (List)new .colon.colon((Object)"ip/scaleda_bram/scaleda.yml", (List)new .colon.colon((Object)"ip/clocking-wizard/scaleda.yml", (List)new .colon.colon((Object)"licences/LICENSE-svls.txt", (List)new .colon.colon((Object)"licences/LICENSE-verible.txt", (List)Nil$.MODULE$))))));

    private int ASSET_VERSION() {
        return ASSET_VERSION;
    }

    private int SMALL_FILE_SIZE() {
        return SMALL_FILE_SIZE;
    }

    private File targetBinaryDirectory() {
        return targetBinaryDirectory;
    }

    private Seq<String> binaryList() {
        return binaryList;
    }

    private Seq<String> textList() {
        return textList;
    }

    public boolean isInstalled() {
        File versionFile = new File(this.targetBinaryDirectory(), "version");
        if (!versionFile.exists()) {
            return false;
        }
        BufferedSource oldVersion = Source$.MODULE$.fromFile(versionFile, Codec$.MODULE$.fallbackSystemCodec());
        int version = BoxesRunTime.unboxToInt((Object)StringOps$.MODULE$.toIntOption$extension(Predef$.MODULE$.augmentString(oldVersion.mkString().trim())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
        oldVersion.close();
        if (version < this.ASSET_VERSION()) {
            KernelLogger$.MODULE$.info(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(41).append("Assets version ").append(version).append(" found, packed version is ").append(this.ASSET_VERSION()).toString()}), new Line(40), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/bin/ExtractAssets.scala"), new Name("isInstalled"));
            return false;
        }
        this.installTexts();
        return this.binaryList().forall((Function1 & Serializable)binary -> BoxesRunTime.boxToBoolean((boolean)ExtractAssets$.$anonfun$isInstalled$2(binary)));
    }

    private void installFilesFromResource(String prefix, File parent, Seq<String> files) {
        files.foreach((Function1 & Serializable)f -> {
            ExtractAssets$.$anonfun$installFilesFromResource$1(parent, prefix, f);
            return BoxedUnit.UNIT;
        });
    }

    private void installTexts() {
        File parent = Paths$.MODULE$.getGlobalConfigDir();
        Object object = !parent.exists() ? BoxesRunTime.boxToBoolean((boolean)parent.mkdirs()) : BoxedUnit.UNIT;
        this.installFilesFromResource("install", parent, this.textList());
    }

    private void setBinariesExecutable() {
        this.binaryList().foreach((Function1 & Serializable)binary -> {
            File file = Path.of(MODULE$.targetBinaryDirectory().getAbsolutePath(), StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(binary), '/')).toFile();
            if (file.exists() && !file.canExecute()) {
                return BoxesRunTime.boxToBoolean((boolean)file.setExecutable(true));
            }
            return BoxedUnit.UNIT;
        });
    }

    private void installBinaries() {
        Object object = !this.targetBinaryDirectory().exists() ? BoxesRunTime.boxToBoolean((boolean)this.targetBinaryDirectory().mkdirs()) : BoxedUnit.UNIT;
        this.installFilesFromResource("bin", this.targetBinaryDirectory(), (Seq<String>)((Seq)this.binaryList().toSeq().$colon$plus((Object)"version")));
    }

    public boolean run() {
        boolean bl;
        KernelLogger$.MODULE$.info(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(36).append("Extracting assets, which version is ").append(this.ASSET_VERSION()).toString()}), new Line(93), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/bin/ExtractAssets.scala"), new Name("run"));
        try {
            this.installTexts();
            this.installBinaries();
            this.setBinariesExecutable();
            bl = true;
        }
        catch (Exception e) {
            KernelLogger$.MODULE$.error(ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"Failed to extract assets", e}), new Line(101), new sourcecode.File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/bin/ExtractAssets.scala"), new Name("run"));
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$isInstalled$2(String binary) {
        File file = Path.of(MODULE$.targetBinaryDirectory().getAbsolutePath(), StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(binary), '/')).toFile();
        return file.exists() && file.isFile() && file.canExecute();
    }

    public static final /* synthetic */ void $anonfun$installFilesFromResource$1(File parent$1, String prefix$1, String f) {
        File file = new File(parent$1, f);
        file.getParentFile().mkdirs();
        InputStream resourceStream = MODULE$.getClass().getClassLoader().getResourceAsStream(new StringBuilder(1).append(prefix$1).append("/").append(f).toString());
        byte[] data = resourceStream.readAllBytes();
        if (data.length < MODULE$.SMALL_FILE_SIZE() || !file.exists() || file.length() != (long)data.length || file.exists() && file.length() < (long)MODULE$.SMALL_FILE_SIZE()) {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(data);
            fileOutputStream.close();
            resourceStream.close();
            return;
        }
    }

    private ExtractAssets$() {
    }
}

