/*
 * Decompiled with CFR 0.152.
 */
package top.scaleda.kernel.auth;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTCreationException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.io.Serializable;
import java.security.KeyFactory;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.time.Duration;
import java.util.Base64;
import java.util.Date;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import sourcecode.File;
import sourcecode.Line;
import sourcecode.Name;
import top.scaleda.kernel.utils.EnvironmentUtils$Backup$;
import top.scaleda.kernel.utils.KernelLogger$;

public final class JwtManager$ {
    public static final JwtManager$ MODULE$ = new JwtManager$();
    private static final Option<String> publicKey = EnvironmentUtils$Backup$.MODULE$.env().get((Object)"JWT_RSA_PUBLIC_KEY");
    private static final Option<String> privateKey = EnvironmentUtils$Backup$.MODULE$.env().get((Object)"JWT_RSA_PRIVATE_KEY");
    private static final Option<RSAPublicKey> rsaPublicKey;
    private static final Option<RSAPrivateKey> rsaPrivateKey;

    static {
        if (MODULE$.publicKey().isEmpty() || MODULE$.privateKey().isEmpty()) {
            KernelLogger$.MODULE$.warn(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"JWT_RSA_* is empty! RSA Key Pair required for JWT"}), new Line(20), new File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/auth/JwtManager.scala"), new Name("JwtManager"));
        }
        rsaPublicKey = MODULE$.publicKey().map((Function1 & Serializable)key -> (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(Base64.getDecoder().decode((String)key))));
        rsaPrivateKey = MODULE$.privateKey().map((Function1 & Serializable)key -> (RSAPrivateKey)KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(Base64.getDecoder().decode((String)key))));
    }

    public Option<String> publicKey() {
        return publicKey;
    }

    public Option<String> privateKey() {
        return privateKey;
    }

    public Option<RSAPublicKey> rsaPublicKey() {
        return rsaPublicKey;
    }

    public Option<RSAPrivateKey> rsaPrivateKey() {
        return rsaPrivateKey;
    }

    public Option<String> create(Duration validTime, Map<String, String> claims) {
        None$ none$;
        if (this.rsaPrivateKey().isEmpty() || this.rsaPublicKey().isEmpty()) {
            return None$.MODULE$;
        }
        Date now = new Date();
        try {
            Algorithm algorithm = Algorithm.RSA256((RSAPublicKey)((RSAPublicKey)this.rsaPublicKey().get()), (RSAPrivateKey)((RSAPrivateKey)this.rsaPrivateKey().get()));
            ObjectRef builder = ObjectRef.create((Object)JWT.create().withIssuer("auth0").withExpiresAt(new Date(now.getTime() + validTime.toMillis()).toInstant()));
            claims.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)JwtManager$.$anonfun$create$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$1 -> {
                JwtManager$.$anonfun$create$2(builder, x$1);
                return BoxedUnit.UNIT;
            });
            builder.elem = ((JWTCreator.Builder)builder.elem).withClaim("random", Integer.valueOf(new SecureRandom().nextInt()));
            String token = ((JWTCreator.Builder)builder.elem).sign(algorithm);
            KernelLogger$.MODULE$.debug(ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"create token (hash):", BoxesRunTime.boxToInteger((int)token.hashCode())}), new Line(46), new File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/auth/JwtManager.scala"), new Name("create"));
            none$ = new Some((Object)token);
        }
        catch (JWTCreationException e) {
            KernelLogger$.MODULE$.error(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JWTCreationException[]{e}), new Line(51), new File("/home/chiro/programs/scaleda/scaleda-kernel/src/main/scala/top/scaleda/kernel/auth/JwtManager.scala"), new Name("create"));
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Map<String, String> create$default$2() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public Option<String> createToken(Duration validTime, Map<String, String> claims) {
        return this.create(validTime, claims);
    }

    public Duration createToken$default$1() {
        return Duration.ofDays(3L);
    }

    public Map<String, String> createToken$default$2() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public Option<String> createRefreshToken(Duration validTime, Map<String, String> claims) {
        return this.create(validTime, claims);
    }

    public Duration createRefreshToken$default$1() {
        return Duration.ofDays(30L);
    }

    public Map<String, String> createRefreshToken$default$2() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public Option<DecodedJWT> decode(String token) {
        None$ none$;
        if (this.rsaPrivateKey().isEmpty() || this.rsaPublicKey().isEmpty()) {
            return None$.MODULE$;
        }
        try {
            Algorithm algorithm = Algorithm.RSA256((RSAPublicKey)((RSAPublicKey)this.rsaPublicKey().get()), (RSAPrivateKey)((RSAPrivateKey)this.rsaPrivateKey().get()));
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).withIssuer("auth0").build();
            none$ = new Some((Object)verifier.verify(token));
        }
        catch (JWTVerificationException e) {
            Predef$.MODULE$.println((Object)e);
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public static final /* synthetic */ boolean $anonfun$create$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$create$2(ObjectRef builder$1, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            builder$1.elem = ((JWTCreator.Builder)builder$1.elem).withClaim(k, v);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private JwtManager$() {
    }
}

