/*
 * Decompiled with CFR 0.152.
 */
package top.scaleda.idea.windows.bottomPanel;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import top.scaleda.idea.ScaledaBundle;
import top.scaleda.idea.utils.ScaledaIdeaLogger;
import top.scaleda.idea.windows.bottomPanel.ConsoleService;
import top.scaleda.idea.windows.bottomPanel.console.ConsoleTabManager;
import top.scaleda.idea.windows.bottomPanel.message.MessageListPanel;
import top.scaleda.idea.windows.bottomPanel.rvcd.RvcdPanel;

public class ScaledaToolWindowFactory
implements ToolWindowFactory {
    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        ConsoleService consoleService = (ConsoleService)project.getService(ConsoleService.class);
        ConsoleTabManager consoleTabManager = new ConsoleTabManager(project, toolWindow.getContentManager());
        Disposer.register((Disposable)consoleService, (Disposable)consoleTabManager);
        consoleService.setConsoleTabManager(consoleTabManager);
        MessageListPanel messageListPanel = new MessageListPanel(project);
        RvcdPanel rvcdPanel = new RvcdPanel(project);
        Disposer.register((Disposable)consoleTabManager, (Disposable)messageListPanel);
        Disposer.register((Disposable)consoleTabManager, (Disposable)rvcdPanel);
        consoleTabManager.addPanel((JPanel)((Object)rvcdPanel), ScaledaBundle.message("windows.tool.log.waveform.title", new Object[0]), false, false);
        consoleTabManager.addPanel((JPanel)((Object)messageListPanel), ScaledaBundle.message("windows.tool.log.message.title", new Object[0]), false, false);
        consoleTabManager.addConsoleTab(ScaledaIdeaLogger.getId(), ScaledaBundle.message("windows.tool.log.console.title", new Object[0]), false, false);
    }
}

