/*
 * Decompiled with CFR 0.152.
 */
package top.scaleda.idea.rvcd;

import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import rvcd.rvcd.RvcdInputEvent;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import top.scaleda.idea.rvcd.FrameBuffer;
import top.scaleda.idea.rvcd.RvcdFrameBufferChannel$;

@ScalaSignature(bytes="\u0006\u0005E4AAD\b\u00011!Aq\u0004\u0001B\u0001B\u0003%\u0001\u0005C\u0003+\u0001\u0011\u00051\u0006C\u00030\u0001\u0011\u0005\u0001\u0007C\u0004=\u0001E\u0005I\u0011A\u001f\t\u000b!\u0003A\u0011A%\b\u000bU{\u0001\u0012\u0001,\u0007\u000b9y\u0001\u0012A,\t\u000b):A\u0011\u0001-\t\u000be;A\u0011\u0002.\t\u000b\u0015<A\u0011\u00024\t\u000b\u001d<A\u0011\u00024\t\u000b!<A\u0011A5\t\u000bA<A\u0011A5\u0003-I38\r\u001a$sC6,')\u001e4gKJ\u001c\u0005.\u00198oK2T!\u0001E\t\u0002\tI48\r\u001a\u0006\u0003%M\tA!\u001b3fC*\u0011A#F\u0001\bg\u000e\fG.\u001a3b\u0015\u00051\u0012a\u0001;pa\u000e\u00011C\u0001\u0001\u001a!\tQR$D\u0001\u001c\u0015\u0005a\u0012!B:dC2\f\u0017B\u0001\u0010\u001c\u0005\u0019\te.\u001f*fM\u000611o\\2lKR\u0004\"!\t\u0015\u000e\u0003\tR!a\t\u0013\u0002\u0011\rD\u0017M\u001c8fYNT!!\n\u0014\u0002\u00079LwNC\u0001(\u0003\u0011Q\u0017M^1\n\u0005%\u0012#!D*pG.,Go\u00115b]:,G.\u0001\u0004=S:LGO\u0010\u000b\u0003Y9\u0002\"!\f\u0001\u000e\u0003=AQa\b\u0002A\u0002\u0001\nAB]3rk\u0016\u001cHO\u0012:b[\u0016$\"!M\u001c\u0011\u0007i\u0011D'\u0003\u000247\t1q\n\u001d;j_:\u0004\"!L\u001b\n\u0005Yz!a\u0003$sC6,')\u001e4gKJDq\u0001O\u0002\u0011\u0002\u0003\u0007\u0011(A\u0007csR,7\u000fU3s!&DX\r\u001c\t\u00035iJ!aO\u000e\u0003\u0007%sG/\u0001\fsKF,Xm\u001d;Ge\u0006lW\r\n3fM\u0006,H\u000e\u001e\u00132+\u0005q$FA\u001d@W\u0005\u0001\u0005CA!G\u001b\u0005\u0011%BA\"E\u0003%)hn\u00195fG.,GM\u0003\u0002F7\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005\u001d\u0013%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006Q\u0011N\u001c9vi\u00163XM\u001c;\u0015\u0005)k\u0005C\u0001\u000eL\u0013\ta5D\u0001\u0003V]&$\b\"\u0002(\u0006\u0001\u0004y\u0015!B3wK:$\bC\u0001)T\u001b\u0005\t&B\u0001\tS\u0015\u0005\u0001\u0012B\u0001+R\u00059\u0011fo\u00193J]B,H/\u0012<f]R\faC\u0015<dI\u001a\u0013\u0018-\\3Ck\u001a4WM]\"iC:tW\r\u001c\t\u0003[\u001d\u0019\"aB\r\u0015\u0003Y\u000babY8o]\u0016\u001cGo\u00115b]:,G\u000eF\u0002K7vCQ\u0001X\u0005A\u0002\u0001\nQb]8dW\u0016$8\t[1o]\u0016d\u0007\"\u00020\n\u0001\u0004y\u0016!D:pG.,G/\u00113ee\u0016\u001c8\u000f\u0005\u0002aG6\t\u0011M\u0003\u0002cM\u0005\u0019a.\u001a;\n\u0005\u0011\f'!D*pG.,G/\u00113ee\u0016\u001c8/\u0001\fde\u0016\fG/\u001a+daN{7m[3u\u0007\"\fgN\\3m)\u0005\u0001\u0013aF2sK\u0006$X-\u00168jqN{7m[3u\u0007\"\fgN\\3m\u0003\u0011)h.\u001b=\u0015\u0003)\u0004BAG6-[&\u0011An\u0007\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007iq'*\u0003\u0002p7\tIa)\u001e8di&|g\u000eM\u0001\u0004i\u000e\u0004\b")
public class RvcdFrameBufferChannel {
    private final SocketChannel socket;

    public static Tuple2<RvcdFrameBufferChannel, Function0<BoxedUnit>> tcp() {
        return RvcdFrameBufferChannel$.MODULE$.tcp();
    }

    public static Tuple2<RvcdFrameBufferChannel, Function0<BoxedUnit>> unix() {
        return RvcdFrameBufferChannel$.MODULE$.unix();
    }

    public Option<FrameBuffer> requestFrame(int bytesPerPixel) {
        byte[] buffer = new byte[4];
        ByteBuffer buf = ByteBuffer.wrap(buffer);
        int cnt = 0;
        int r = -1;
        do {
            if ((r = this.socket.read(buf)) < 0) continue;
            cnt += r;
        } while (r >= 0 && cnt < 4);
        if (cnt != 4) {
            String msg = new StringBuilder(40).append("Failed to read frame header, read ").append(cnt).append(" bytes").toString();
            throw new RuntimeException(msg);
        }
        int width = (buffer[0] & 0xFF) << 8 | buffer[1] & 0xFF;
        int height = (buffer[2] & 0xFF) << 8 | buffer[3] & 0xFF;
        if (width <= 0 || height <= 0 || width > 8192 || height > 8192) {
            throw new RuntimeException(new StringBuilder(23).append("Invalid frame size: ").append(width).append(" x ").append(height).toString());
        }
        int len = width * height * bytesPerPixel;
        byte[] data = new byte[len];
        ByteBuffer buf2 = ByteBuffer.wrap(data);
        cnt = 0;
        r = -1;
        do {
            if ((r = this.socket.read(buf2)) < 0) continue;
            cnt += r;
        } while (r >= 0 && cnt < len);
        if (cnt != len) {
            String msg = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Failed to read frame data, read 0x%x bytes, expected 0x%x bytes"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)cnt), BoxesRunTime.boxToInteger((int)len)}));
            throw new RuntimeException(msg);
        }
        return new Some((Object)new FrameBuffer(width, height, data));
    }

    public int requestFrame$default$1() {
        return 2;
    }

    public void inputEvent(RvcdInputEvent event) {
        byte[] data = event.toByteArray();
        int len = data.length;
        ByteBuffer lenData = ByteBuffer.allocate(4);
        lenData.putInt(len);
        lenData.flip();
        ByteBuffer buffer = ByteBuffer.wrap(data);
        int n = 0;
        int r = -1;
        do {
            if ((r = this.socket.write(lenData)) < 0) continue;
            n += r;
        } while (r >= 0 && n < 4);
        if (n != 4) {
            String msg = new StringBuilder(48).append("Failed to write input event length, wrote ").append(n).append(" bytes").toString();
            throw new RuntimeException(msg);
        }
        n = 0;
        r = -1;
        do {
            if ((r = this.socket.write(buffer)) < 0) continue;
            n += r;
        } while (r >= 0 && n < len);
        if (n != len) {
            String msg = new StringBuilder(41).append("Failed to write input event, wrote ").append(n).append(" bytes").toString();
            throw new RuntimeException(msg);
        }
    }

    public RvcdFrameBufferChannel(SocketChannel socket) {
        this.socket = socket;
    }
}

