/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.intellij.adaptor.xpath;

import com.intellij.lang.Language;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.intellij.adaptor.lexer.PSIElementTypeFactory;
import org.antlr.intellij.adaptor.lexer.RuleIElementType;
import org.antlr.intellij.adaptor.lexer.TokenIElementType;
import org.antlr.intellij.adaptor.psi.Trees;
import org.antlr.intellij.adaptor.xpath.XPathElement;
import org.antlr.intellij.adaptor.xpath.XPathLexerErrorListener;
import org.antlr.intellij.adaptor.xpath.XPathRuleAnywhereElement;
import org.antlr.intellij.adaptor.xpath.XPathRuleElement;
import org.antlr.intellij.adaptor.xpath.XPathTokenAnywhereElement;
import org.antlr.intellij.adaptor.xpath.XPathTokenElement;
import org.antlr.intellij.adaptor.xpath.XPathWildcardAnywhereElement;
import org.antlr.intellij.adaptor.xpath.XPathWildcardElement;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.LexerNoViableAltException;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.tree.xpath.XPathLexer;
import org.jetbrains.annotations.NotNull;

public class XPath {
    public static final String WILDCARD = "*";
    public static final String NOT = "!";
    private final List<TokenIElementType> tokenElementTypes;
    private final List<RuleIElementType> ruleElementTypes;
    private final Map<String, Integer> ruleIndexes;
    private final Map<String, Integer> tokenTypes;
    protected String path;

    public XPath(Language language, String string) {
        this.path = string;
        this.tokenElementTypes = PSIElementTypeFactory.getTokenIElementTypes(language);
        this.ruleElementTypes = PSIElementTypeFactory.getRuleIElementTypes(language);
        this.ruleIndexes = PSIElementTypeFactory.getRuleNameToIndexMap(language);
        this.tokenTypes = PSIElementTypeFactory.getTokenNameToTypeMap(language);
    }

    public XPathElement[] split(String string) {
        CodePointCharStream codePointCharStream = CharStreams.fromString((String)string);
        XPathLexer xPathLexer = new XPathLexer((CharStream)codePointCharStream){

            public void recover(LexerNoViableAltException lexerNoViableAltException) {
                throw lexerNoViableAltException;
            }
        };
        xPathLexer.removeErrorListeners();
        xPathLexer.addErrorListener((ANTLRErrorListener)new XPathLexerErrorListener());
        CommonTokenStream commonTokenStream = new CommonTokenStream((TokenSource)xPathLexer);
        try {
            commonTokenStream.fill();
        }
        catch (LexerNoViableAltException lexerNoViableAltException) {
            int n = xPathLexer.getCharPositionInLine();
            String string2 = "Invalid tokens or characters at index " + n + " in path '" + string + "'";
            throw new IllegalArgumentException(string2, lexerNoViableAltException);
        }
        List list = commonTokenStream.getTokens();
        ArrayList<XPathElement> arrayList = new ArrayList<XPathElement>();
        int n = list.size();
        int n2 = 0;
        block7: while (n2 < n) {
            Token token = (Token)list.get(n2);
            Token token2 = null;
            switch (token.getType()) {
                case 3: 
                case 4: {
                    boolean bl;
                    boolean bl2 = token.getType() == 3;
                    token2 = (Token)list.get(++n2);
                    boolean bl3 = bl = token2.getType() == 6;
                    if (bl) {
                        token2 = (Token)list.get(++n2);
                    }
                    XPathElement xPathElement = this.getXPathElement(token2, bl2);
                    xPathElement.invert = bl;
                    arrayList.add(xPathElement);
                    ++n2;
                    break;
                }
                case 1: 
                case 2: 
                case 5: {
                    arrayList.add(this.getXPathElement(token, false));
                    ++n2;
                    break;
                }
                case -1: {
                    break block7;
                }
                default: {
                    throw new IllegalArgumentException("Unknowth path element " + token);
                }
            }
        }
        return arrayList.toArray(new XPathElement[0]);
    }

    protected XPathElement getXPathElement(Token token, boolean bl) {
        if (token.getType() == -1) {
            throw new IllegalArgumentException("Missing path element at end of path");
        }
        String string = token.getText();
        Integer n = this.tokenTypes.get(string);
        Integer n2 = this.ruleIndexes.get(string);
        switch (token.getType()) {
            case 5: {
                return bl ? new XPathWildcardAnywhereElement() : new XPathWildcardElement();
            }
            case 1: 
            case 8: {
                if (n == null || n == 0) {
                    throw new IllegalArgumentException(string + " at index " + token.getStartIndex() + " isn't a valid token name");
                }
                return bl ? new XPathTokenAnywhereElement(string, n) : new XPathTokenElement(string, n);
            }
        }
        if (n2 == null || n2 == -1) {
            throw new IllegalArgumentException(string + " at index " + token.getStartIndex() + " isn't a valid rule name");
        }
        return bl ? new XPathRuleAnywhereElement(string, n2) : new XPathRuleElement(string, n2);
    }

    public static Collection<? extends PsiElement> findAll(Language language, PsiElement psiElement, String string) {
        XPath xPath = new XPath(language, string);
        XPathElement[] xPathElementArray = xPath.split(string);
        return xPath.evaluate(psiElement, xPathElementArray);
    }

    public Collection<? extends PsiElement> evaluate(PsiElement psiElement, XPathElement[] xPathElementArray) {
        if (psiElement == null) {
            return Collections.emptyList();
        }
        if (psiElement instanceof PsiFile) {
            psiElement = Trees.getChildren(psiElement)[0];
        }
        DummyRoot dummyRoot = new DummyRoot(psiElement);
        Set<DummyRoot> set = Collections.singleton(dummyRoot);
        for (int i = 0; i < xPathElementArray.length; ++i) {
            LinkedHashSet<DummyRoot> linkedHashSet = new LinkedHashSet<DummyRoot>();
            for (PsiElement psiElement2 : set) {
                if (psiElement2.getChildren().length <= 0) continue;
                Collection<PsiElement> collection = xPathElementArray[i].evaluate(psiElement2);
                linkedHashSet.addAll(collection);
            }
            set = linkedHashSet;
        }
        return set;
    }

    public static class DummyRoot
    extends CompositePsiElement {
        public final PsiElement child;

        public DummyRoot(PsiElement psiElement) {
            super(GeneratedParserUtilBase.DUMMY_BLOCK);
            this.child = psiElement;
        }

        @NotNull
        public PsiElement[] getChildren() {
            return new PsiElement[]{this.child};
        }

        @NotNull
        public PsiReference[] getReferences() {
            return PsiReference.EMPTY_ARRAY;
        }

        @NotNull
        public Language getLanguage() {
            return this.getParent().getLanguage();
        }
    }
}

