/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.intellij.adaptor.psi;

import com.intellij.lang.Language;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.intellij.adaptor.lexer.RuleIElementType;
import org.antlr.intellij.adaptor.lexer.TokenIElementType;
import org.antlr.intellij.adaptor.psi.ANTLRPsiNode;
import org.jetbrains.annotations.NotNull;

public class Trees {
    private Trees() {
    }

    public static List<? extends PsiElement> getAncestors(PsiElement psiElement) {
        if (psiElement.getParent() == null) {
            return Collections.emptyList();
        }
        ArrayList<PsiElement> arrayList = new ArrayList<PsiElement>();
        for (psiElement = psiElement.getParent(); psiElement != null; psiElement = psiElement.getParent()) {
            arrayList.add(0, psiElement);
        }
        return arrayList;
    }

    public static boolean isAncestorOf(PsiElement psiElement, PsiElement psiElement2) {
        if (psiElement == null || psiElement2 == null || psiElement.getParent() == null) {
            return false;
        }
        for (PsiElement psiElement3 = psiElement2.getParent(); psiElement3 != null; psiElement3 = psiElement3.getParent()) {
            if (psiElement != psiElement3) continue;
            return true;
        }
        return false;
    }

    public static ANTLRPsiNode getRoot(PsiElement psiElement) {
        PsiFile psiFile = (PsiFile)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiFile.class);
        return (ANTLRPsiNode)Trees.getChildren((PsiElement)psiFile)[0];
    }

    public static Map<String, PsiElement> toMap(Collection<? extends PsiElement> collection) {
        HashMap<String, PsiElement> hashMap = new HashMap<String, PsiElement>();
        for (PsiElement psiElement : collection) {
            hashMap.put(psiElement.getText(), psiElement);
        }
        return hashMap;
    }

    public static Collection<PsiElement> findAllTokenNodes(PsiElement psiElement, int n) {
        return Trees.findAllNodes(psiElement, n, true);
    }

    public static Collection<PsiElement> findAllRuleNodes(PsiElement psiElement, int n) {
        return Trees.findAllNodes(psiElement, n, false);
    }

    public static List<PsiElement> findAllNodes(PsiElement psiElement, int n, boolean bl) {
        ArrayList<PsiElement> arrayList = new ArrayList<PsiElement>();
        Trees._findAllNodes(psiElement, n, bl, arrayList);
        return arrayList;
    }

    public static void _findAllNodes(PsiElement psiElement, int n, boolean bl, List<? super PsiElement> list) {
        ANTLRPsiNode aNTLRPsiNode;
        IElementType iElementType;
        if (bl && psiElement instanceof LeafPsiElement) {
            LeafPsiElement object = (LeafPsiElement)psiElement;
            iElementType = object.getNode().getElementType();
            if (iElementType instanceof TokenIElementType && ((TokenIElementType)iElementType).getANTLRTokenType() == n) {
                list.add((PsiElement)psiElement);
            }
        } else if (!bl && psiElement instanceof ANTLRPsiNode && (iElementType = (aNTLRPsiNode = (ANTLRPsiNode)psiElement).getNode().getElementType()) instanceof RuleIElementType && ((RuleIElementType)iElementType).getRuleIndex() == n) {
            list.add((PsiElement)psiElement);
        }
        for (PsiElement psiElement2 : psiElement.getChildren()) {
            Trees._findAllNodes(psiElement2, n, bl, list);
        }
    }

    public static List<PsiElement> getDescendants(PsiElement psiElement) {
        ArrayList<PsiElement> arrayList = new ArrayList<PsiElement>();
        arrayList.add(psiElement);
        for (PsiElement psiElement2 : psiElement.getChildren()) {
            arrayList.addAll(Trees.getDescendants(psiElement2));
        }
        return arrayList;
    }

    @NotNull
    public static PsiElement[] getChildren(PsiElement psiElement) {
        if (psiElement == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement psiElement2 = psiElement.getFirstChild();
        if (psiElement2 == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        ArrayList<PsiElement> arrayList = new ArrayList<PsiElement>();
        while (psiElement2 != null) {
            if (!(psiElement2 instanceof PsiComment) && !(psiElement2 instanceof PsiWhiteSpace)) {
                arrayList.add(psiElement2);
            }
            psiElement2 = psiElement2.getNextSibling();
        }
        return PsiUtilCore.toPsiElementArray(arrayList);
    }

    public static PsiElement getRootOfSubtreeEnclosingRegion(PsiElement psiElement, int n, int n2) {
        TextRange textRange;
        for (PsiElement psiElement2 : psiElement.getChildren()) {
            PsiElement psiElement3 = Trees.getRootOfSubtreeEnclosingRegion(psiElement2, n, n2);
            if (psiElement3 == null) continue;
            return psiElement3;
        }
        IElementType iElementType = psiElement.getNode().getElementType();
        if (iElementType instanceof RuleIElementType && n >= (textRange = psiElement.getNode().getTextRange()).getStartOffset() && n2 < textRange.getEndOffset()) {
            return psiElement;
        }
        return null;
    }

    public static PsiElement findNodeSuchThat(PsiElement psiElement, Predicate<PsiElement> predicate) {
        if (predicate.test(psiElement)) {
            return psiElement;
        }
        for (PsiElement psiElement2 : psiElement.getChildren()) {
            PsiElement psiElement3 = Trees.findNodeSuchThat(psiElement2, predicate);
            if (psiElement3 == null) continue;
            return psiElement3;
        }
        return null;
    }

    public static PsiElement createLeafFromText(Project project, Language language, PsiElement psiElement, String string, IElementType iElementType) {
        PsiFileFactoryImpl psiFileFactoryImpl = (PsiFileFactoryImpl)PsiFileFactory.getInstance((Project)project);
        PsiElement psiElement2 = psiFileFactoryImpl.createElementFromText(string, language, iElementType, psiElement);
        if (psiElement2 == null) {
            return null;
        }
        return PsiTreeUtil.getDeepestFirst((PsiElement)psiElement2);
    }

    public static void replacePsiFileFromText(Project project, Language language, PsiFile psiFile, String string) {
        PsiFile psiFile2 = Trees.createFile(project, language, string);
        if (psiFile2 == null) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)project, () -> {
            psiFile.deleteChildRange(psiFile.getFirstChild(), psiFile.getLastChild());
            psiFile.addRange(psiFile2.getFirstChild(), psiFile2.getLastChild());
        });
    }

    public static PsiFile createFile(Project project, Language language, String string) {
        LanguageFileType languageFileType = language.getAssociatedFileType();
        if (languageFileType == null) {
            return null;
        }
        String string2 = languageFileType.getDefaultExtension();
        String string3 = "___fubar___." + string2;
        PsiFileFactoryImpl psiFileFactoryImpl = (PsiFileFactoryImpl)PsiFileFactory.getInstance((Project)project);
        return psiFileFactoryImpl.createFileFromText(string3, language, (CharSequence)string, false, false);
    }

    public static interface Predicate<T> {
        public boolean test(T var1);
    }
}

