/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.intellij.adaptor.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.antlr.intellij.adaptor.psi.ANTLRPsiNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IdentifierDefSubtree
extends ANTLRPsiNode
implements PsiNameIdentifierOwner {
    private final IElementType idElementType;

    public IdentifierDefSubtree(@NotNull ASTNode aSTNode, @NotNull IElementType iElementType) {
        super(aSTNode);
        this.idElementType = iElementType;
    }

    public String getName() {
        PsiElement psiElement = this.getNameIdentifier();
        return psiElement != null ? psiElement.getText() : null;
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        ASTNode aSTNode = this.getNode().findChildByType(this.idElementType);
        if (aSTNode != null) {
            return aSTNode.getPsi();
        }
        return null;
    }

    public int getTextOffset() {
        PsiElement psiElement = this.getNameIdentifier();
        return psiElement != null ? psiElement.getTextOffset() : super.getTextOffset();
    }

    public PsiElement setName(@NotNull String string) throws IncorrectOperationException {
        PsiNamedElement psiNamedElement = (PsiNamedElement)this.getNameIdentifier();
        if (psiNamedElement != null) {
            return psiNamedElement.setName(string);
        }
        return this;
    }
}

