/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.intellij.adaptor.parser;

import com.intellij.lang.Language;
import com.intellij.lang.PsiBuilder;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.intellij.adaptor.lexer.PSIElementTypeFactory;
import org.antlr.intellij.adaptor.lexer.RuleIElementType;
import org.antlr.intellij.adaptor.lexer.TokenIElementType;
import org.antlr.intellij.adaptor.parser.SyntaxError;
import org.antlr.intellij.adaptor.parser.SyntaxErrorListener;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.TerminalNode;

public class ANTLRParseTreeToPSIConverter
implements ParseTreeListener {
    protected final Language language;
    protected final PsiBuilder builder;
    protected Map<RecognitionException, SyntaxError> syntaxErrors;
    protected final Deque<PsiBuilder.Marker> markers = new ArrayDeque<PsiBuilder.Marker>();
    protected final List<TokenIElementType> tokenElementTypes;
    protected final List<RuleIElementType> ruleElementTypes;
    protected Map<Integer, SyntaxError> tokenToErrorMap = new HashMap<Integer, SyntaxError>();

    public ANTLRParseTreeToPSIConverter(Language language, Parser parser, PsiBuilder psiBuilder) {
        this.language = language;
        this.builder = psiBuilder;
        this.tokenElementTypes = PSIElementTypeFactory.getTokenIElementTypes(language);
        this.ruleElementTypes = PSIElementTypeFactory.getRuleIElementTypes(language);
        for (ANTLRErrorListener aNTLRErrorListener : parser.getErrorListeners()) {
            if (!(aNTLRErrorListener instanceof SyntaxErrorListener)) continue;
            this.syntaxErrors = ((SyntaxErrorListener)aNTLRErrorListener).getErrorMap();
            for (SyntaxError syntaxError : this.syntaxErrors.values()) {
                int n = syntaxError.getOffendingSymbol().getStartIndex();
                if (this.tokenToErrorMap.containsKey(n)) continue;
                this.tokenToErrorMap.put(n, syntaxError);
            }
        }
    }

    protected final Language getLanguage() {
        return this.language;
    }

    protected final PsiBuilder getBuilder() {
        return this.builder;
    }

    protected final Deque<PsiBuilder.Marker> getMarkers() {
        return this.markers;
    }

    protected final List<TokenIElementType> getTokenElementTypes() {
        return this.tokenElementTypes;
    }

    protected final List<RuleIElementType> getRuleElementTypes() {
        return this.ruleElementTypes;
    }

    public void visitTerminal(TerminalNode terminalNode) {
        int n = terminalNode.getSymbol().getStartIndex();
        SyntaxError syntaxError = this.tokenToErrorMap.get(n);
        if (syntaxError != null) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            marker.error(syntaxError.getMessage());
        } else {
            this.builder.advanceLexer();
        }
    }

    public void visitErrorNode(ErrorNode errorNode) {
        ProgressIndicatorProvider.checkCanceled();
        Token token = errorNode.getSymbol();
        boolean bl = token.getTokenIndex() < 0;
        int n = token.getStartIndex();
        SyntaxError syntaxError = this.tokenToErrorMap.get(n);
        if (syntaxError != null) {
            PsiBuilder.Marker marker = this.builder.mark();
            if (token.getStartIndex() >= 0 && token.getType() != -1 && !bl) {
                this.builder.advanceLexer();
            }
            String string = String.format("%s%n", syntaxError.getMessage());
            marker.error(string);
        } else if (bl) {
            PsiBuilder.Marker marker = this.builder.mark();
            marker.error(token.getText());
        } else {
            this.builder.advanceLexer();
        }
    }

    public void enterEveryRule(ParserRuleContext parserRuleContext) {
        ProgressIndicatorProvider.checkCanceled();
        this.markers.push(this.getBuilder().mark());
    }

    public void exitEveryRule(ParserRuleContext parserRuleContext) {
        ProgressIndicatorProvider.checkCanceled();
        PsiBuilder.Marker marker = this.markers.pop();
        marker.done((IElementType)this.getRuleElementTypes().get(parserRuleContext.getRuleIndex()));
    }
}

