/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.intellij.adaptor.lexer;

import com.intellij.lang.Language;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.antlr.intellij.adaptor.lexer.RuleIElementType;
import org.antlr.intellij.adaptor.lexer.TokenIElementType;
import org.antlr.v4.runtime.Vocabulary;
import org.antlr.v4.runtime.misc.Utils;
import org.jetbrains.annotations.NotNull;

public class PSIElementTypeFactory {
    private static final Map<Language, List<TokenIElementType>> tokenIElementTypesCache = new HashMap<Language, List<TokenIElementType>>();
    private static final Map<Language, List<RuleIElementType>> ruleIElementTypesCache = new HashMap<Language, List<RuleIElementType>>();
    private static final Map<Language, Map<String, Integer>> tokenNamesCache = new HashMap<Language, Map<String, Integer>>();
    private static final Map<Language, Map<String, Integer>> ruleNamesCache = new HashMap<Language, Map<String, Integer>>();
    private static final Map<Language, TokenIElementType> eofIElementTypesCache = new HashMap<Language, TokenIElementType>();

    private PSIElementTypeFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void defineLanguageIElementTypes(Language language2, Vocabulary vocabulary, String[] stringArray) {
        Class<PSIElementTypeFactory> clazz = PSIElementTypeFactory.class;
        synchronized (PSIElementTypeFactory.class) {
            tokenIElementTypesCache.computeIfAbsent(language2, language -> PSIElementTypeFactory.createTokenIElementTypes(language, vocabulary));
            ruleIElementTypesCache.computeIfAbsent(language2, language -> PSIElementTypeFactory.createRuleIElementTypes(language, stringArray));
            tokenNamesCache.computeIfAbsent(language2, language -> PSIElementTypeFactory.createTokenTypeMap(vocabulary));
            ruleNamesCache.computeIfAbsent(language2, language -> PSIElementTypeFactory.createRuleIndexMap(stringArray));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public static TokenIElementType getEofElementType(Language language2) {
        return eofIElementTypesCache.computeIfAbsent(language2, language -> new TokenIElementType(-1, "EOF", (Language)language));
    }

    public static List<TokenIElementType> getTokenIElementTypes(Language language) {
        return tokenIElementTypesCache.get(language);
    }

    public static List<RuleIElementType> getRuleIElementTypes(Language language) {
        return ruleIElementTypesCache.get(language);
    }

    public static Map<String, Integer> getRuleNameToIndexMap(Language language) {
        return ruleNamesCache.get(language);
    }

    public static Map<String, Integer> getTokenNameToTypeMap(Language language) {
        return tokenNamesCache.get(language);
    }

    public static Map<String, Integer> createTokenTypeMap(Vocabulary vocabulary) {
        return IntStream.rangeClosed(0, vocabulary.getMaxTokenType()).boxed().collect(Collectors.toMap(arg_0 -> ((Vocabulary)vocabulary).getDisplayName(arg_0), Function.identity()));
    }

    public static Map<String, Integer> createRuleIndexMap(String[] stringArray) {
        return Utils.toMap((String[])stringArray);
    }

    @NotNull
    public static List<TokenIElementType> createTokenIElementTypes(Language language, Vocabulary vocabulary) {
        return IntStream.rangeClosed(0, vocabulary.getMaxTokenType()).boxed().map(n -> new TokenIElementType((int)n, vocabulary.getDisplayName(n.intValue()), language)).collect(Collectors.toList());
    }

    @NotNull
    public static List<RuleIElementType> createRuleIElementTypes(Language language, String[] stringArray) {
        RuleIElementType[] ruleIElementTypeArray = new RuleIElementType[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            ruleIElementTypeArray[i] = new RuleIElementType(i, stringArray[i], language);
        }
        List<RuleIElementType> list = Collections.unmodifiableList(Arrays.asList(ruleIElementTypeArray));
        return list;
    }

    public static TokenSet createTokenSet(Language language, int ... nArray) {
        List<TokenIElementType> list = PSIElementTypeFactory.getTokenIElementTypes(language);
        IElementType[] iElementTypeArray = new IElementType[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            iElementTypeArray[i] = nArray[i] == -1 ? PSIElementTypeFactory.getEofElementType(language) : (IElementType)list.get(nArray[i]);
        }
        return TokenSet.create((IElementType[])iElementTypeArray);
    }
}

