/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.util;

import com.google.common.base.Strings;
import com.hubspot.jinjava.interpret.InterpretException;
import javax.annotation.Nullable;

public final class WhitespaceUtils {
    private static final char[] QUOTE_CHARS = new char[]{'\'', '\"'};

    public static boolean startsWith(String s, String prefix) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return s.regionMatches(i, prefix, 0, prefix.length());
        }
        return false;
    }

    public static boolean endsWith(String s, String suffix) {
        if (s == null) {
            return false;
        }
        for (int i = s.length() - 1; i >= 0; --i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return s.regionMatches(i - suffix.length() + 1, suffix, 0, suffix.length());
        }
        return false;
    }

    public static boolean isWrappedWith(String s, String prefix, String suffix) {
        return WhitespaceUtils.startsWith(s, prefix) && WhitespaceUtils.endsWith(s, suffix);
    }

    public static boolean isQuoted(String s) {
        if (WhitespaceUtils.startsWith(s, "'")) {
            if (!WhitespaceUtils.endsWith(s, "'")) {
                throw new InterpretException("Unbalanced quotes: " + s);
            }
            return true;
        }
        if (WhitespaceUtils.startsWith(s, "\"")) {
            if (!WhitespaceUtils.endsWith(s, "\"")) {
                throw new InterpretException("Unbalanced quotes: " + s);
            }
            return true;
        }
        return false;
    }

    public static boolean isExpressionQuoted(String s) {
        if (Strings.isNullOrEmpty((String)s)) {
            return false;
        }
        char[] charArray = s.trim().toCharArray();
        if (charArray.length == 1) {
            return false;
        }
        char quoteChar = '\u0000';
        for (char c : QUOTE_CHARS) {
            if (charArray[0] != c) continue;
            quoteChar = c;
            break;
        }
        if (charArray[charArray.length - 1] != quoteChar) {
            return false;
        }
        int prevChar = 0;
        for (int i = 1; i < charArray.length - 1; ++i) {
            if (charArray[i] == quoteChar && prevChar != 92) {
                return false;
            }
            prevChar = prevChar == 92 ? 0 : charArray[i];
        }
        return prevChar != 92;
    }

    public static String unquote(String s) {
        if (s == null) {
            return "";
        }
        if (WhitespaceUtils.startsWith(s, "'")) {
            return WhitespaceUtils.unwrap(s, "'", "'");
        }
        if (WhitespaceUtils.startsWith(s, "\"")) {
            return WhitespaceUtils.unwrap(s, "\"", "\"");
        }
        return s.trim();
    }

    public static String unquoteAndUnescape(String s) {
        if (Strings.isNullOrEmpty((String)s)) {
            return "";
        }
        if (!WhitespaceUtils.isExpressionQuoted(s)) {
            return s.trim();
        }
        if (WhitespaceUtils.startsWith(s, "'")) {
            s = WhitespaceUtils.unwrap(s, "'", "'");
        } else if (WhitespaceUtils.startsWith(s, "\"")) {
            s = WhitespaceUtils.unwrap(s, "\"", "\"");
        } else {
            return s.trim();
        }
        return s.replace("\\\"", "\"").replace("\\'", "'").replace("\\\\", "\\");
    }

    public static String unwrap(String s, String prefix, String suffix) {
        int start;
        int end = s.length() - 1;
        for (start = 0; start < s.length() && Character.isWhitespace(s.charAt(start)); ++start) {
        }
        while (end >= 0 && Character.isWhitespace(s.charAt(end))) {
            --end;
        }
        return s.substring(start + prefix.length(), end - suffix.length() + 1);
    }

    @Nullable
    public static StringBuilder quoteIfNotNull(CharSequence charSequence) {
        if (charSequence != null) {
            return new StringBuilder(charSequence.length() + 2).append('\'').append(charSequence).append('\'');
        }
        return null;
    }

    private WhitespaceUtils() {
    }
}

