/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.util;

import com.hubspot.jinjava.util.Logging;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class ScopeMap<K, V>
implements Map<K, V> {
    private final Map<K, V> scope = new HashMap();
    private final ScopeMap<K, V> parent;

    public ScopeMap() {
        this(null);
    }

    public ScopeMap(ScopeMap<K, V> parent) {
        this.parent = parent;
        HashSet<ScopeMap<K, V>> parents = new HashSet<ScopeMap<K, V>>();
        if (parent != null) {
            for (ScopeMap<K, V> p = parent.getParent(); p != null; p = p.getParent()) {
                parents.add(p);
                if (!parents.contains(parent)) continue;
                Logging.ENGINE_LOG.error("Parent loop detected:\n{}", (Object)Arrays.stream(Thread.currentThread().getStackTrace()).map(StackTraceElement::toString).collect(Collectors.joining("\n")));
                break;
            }
        }
    }

    public ScopeMap(ScopeMap<K, V> parent, Map<K, V> scope) {
        this(parent);
        this.scope.putAll(scope);
    }

    public ScopeMap<K, V> getParent() {
        return this.parent;
    }

    public Map<K, V> getScope() {
        return this.scope;
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.scope.containsValue(value)) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.containsValue(value);
        }
        return false;
    }

    public V get(Object key, V defVal) {
        V val = this.get(key);
        if (val != null) {
            return val;
        }
        return defVal;
    }

    @Override
    public V get(Object key) {
        V val = this.scope.get(key);
        if (val != null) {
            return val;
        }
        if (this.parent != null) {
            return this.parent.get(key);
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        if (value == this) {
            throw new IllegalArgumentException(String.format("attempt to put on map with key '%s' and value of itself", key));
        }
        return this.scope.put(key, value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        boolean replaced = this.scope.replace(key, oldValue, newValue);
        if (replaced) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.replace(key, oldValue, newValue);
        }
        return false;
    }

    @Override
    public V replace(K key, V value) {
        V val = this.scope.replace(key, value);
        if (val != null) {
            return val;
        }
        if (this.parent != null) {
            return this.parent.replace(key, value);
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        return this.scope.remove(key);
    }

    @Override
    public void putAll(@Nonnull Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            if (entry.getValue() != this) continue;
            throw new IllegalArgumentException(String.format("attempt to putAll on map with key '%s' and value of itself", entry.getKey()));
        }
        this.scope.putAll(m);
    }

    @Override
    public void clear() {
        this.scope.clear();
    }

    @Override
    @Nonnull
    public Set<K> keySet() {
        HashSet<K> keys = new HashSet<K>();
        if (this.parent != null) {
            keys.addAll(this.parent.keySet());
        }
        keys.addAll(this.scope.keySet());
        return keys;
    }

    @Override
    @Nonnull
    public Collection<V> values() {
        Set<Map.Entry<K, V>> entrySet = this.entrySet();
        ArrayList<V> values = new ArrayList<V>(entrySet.size());
        for (Map.Entry<K, V> entry : entrySet) {
            values.add(entry.getValue());
        }
        return values;
    }

    @Override
    @Nonnull
    @SuppressFBWarnings(justification="using overridden get() to do scoped retrieve with parent fallback", value={"WMI_WRONG_MAP_ITERATOR"})
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> entries = new HashSet<Map.Entry<K, V>>();
        for (K key : this.keySet()) {
            entries.add(new ScopeMapEntry<K, V>(key, this.get(key), this));
        }
        return entries;
    }

    public static class ScopeMapEntry<K, V>
    implements Map.Entry<K, V> {
        private final Map<K, V> map;
        private final K key;
        private V value;

        public ScopeMapEntry(K key, V value, Map<K, V> map) {
            this.key = key;
            this.value = value;
            this.map = map;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            this.value = value;
            this.map.put(this.key, value);
            return value;
        }
    }
}

