/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.util;

import com.hubspot.jinjava.objects.SafeString;
import com.hubspot.jinjava.util.HasObjectTruthValue;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;

public final class ObjectTruthValue {
    private ObjectTruthValue() {
    }

    public static boolean evaluate(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof HasObjectTruthValue) {
            return ((HasObjectTruthValue)object).getObjectTruthValue();
        }
        if (object instanceof Boolean) {
            Boolean b = (Boolean)object;
            return b;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue() != 0.0;
        }
        if (object instanceof String) {
            return !"".equals(object) && !"false".equalsIgnoreCase((String)object);
        }
        if (object instanceof SafeString) {
            return !"".equals(object.toString()) && !"false".equalsIgnoreCase(object.toString());
        }
        if (object.getClass().isArray()) {
            return Array.getLength(object) != 0;
        }
        if (object instanceof Collection) {
            return ((Collection)object).size() != 0;
        }
        if (object instanceof Map) {
            return ((Map)object).size() != 0;
        }
        return true;
    }
}

