/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.util;

import com.hubspot.jinjava.interpret.OutputTooBigException;
import java.util.StringJoiner;

public class LengthLimitingStringJoiner {
    private final StringJoiner joiner;
    private final int delimiterLength;
    private final long maxLength;

    public LengthLimitingStringJoiner(long maxLength, CharSequence delimiter) {
        this.joiner = new StringJoiner(delimiter);
        this.delimiterLength = delimiter.length();
        this.maxLength = maxLength;
    }

    public int length() {
        return this.joiner.length();
    }

    public LengthLimitingStringJoiner add(Object obj) {
        return this.add(String.valueOf(obj));
    }

    public LengthLimitingStringJoiner add(CharSequence newElement) {
        long newLength = this.joiner.length() + newElement.length() + (this.joiner.length() > 0 ? this.delimiterLength : 0);
        if (this.maxLength > 0L && newLength > this.maxLength) {
            throw new OutputTooBigException(this.maxLength, newLength);
        }
        this.joiner.add(newElement);
        return this;
    }

    public String toString() {
        return this.joiner.toString();
    }
}

