/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.objects.serialization;

import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.google.common.annotations.Beta;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.OutputTooBigException;
import com.hubspot.jinjava.objects.serialization.LengthLimitingJsonProcessingException;
import com.hubspot.jinjava.objects.serialization.LengthLimitingWriter;
import com.hubspot.jinjava.objects.serialization.PyishBeanSerializerModifier;
import com.hubspot.jinjava.objects.serialization.PyishCharacterEscapes;
import com.hubspot.jinjava.objects.serialization.PyishPrettyPrinter;
import com.hubspot.jinjava.objects.serialization.PyishSerializable;
import com.hubspot.jinjava.objects.serialization.PyishSerializer;
import com.hubspot.jinjava.util.WhitespaceUtils;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

@Beta
public class PyishObjectMapper {
    public static final ObjectWriter PYISH_OBJECT_WRITER = PyishObjectMapper.getPyishObjectMapper().writer((PrettyPrinter)PyishPrettyPrinter.INSTANCE).with((CharacterEscapes)PyishCharacterEscapes.INSTANCE);
    public static final ObjectWriter SNAKE_CASE_PYISH_OBJECT_WRITER = PyishObjectMapper.getPyishObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE).writer((PrettyPrinter)PyishPrettyPrinter.INSTANCE).with((CharacterEscapes)PyishCharacterEscapes.INSTANCE);
    public static final String ALLOW_SNAKE_CASE_ATTRIBUTE = "allowSnakeCase";

    private static ObjectMapper getPyishObjectMapper() {
        ObjectMapper mapper = new ObjectMapper(new JsonFactoryBuilder().quoteChar('\'').build()).registerModule((Module)new SimpleModule().setSerializerModifier((BeanSerializerModifier)PyishBeanSerializerModifier.INSTANCE).addSerializer(PyishSerializable.class, (JsonSerializer)PyishSerializer.INSTANCE));
        mapper.getSerializerProvider().setNullKeySerializer((JsonSerializer)new NullKeySerializer());
        return mapper;
    }

    public static String getAsUnquotedPyishString(Object val) {
        if (val != null) {
            return WhitespaceUtils.unquoteAndUnescape(PyishObjectMapper.getAsPyishString(val, true));
        }
        return "";
    }

    public static String getAsPyishString(Object val) {
        return PyishObjectMapper.getAsPyishString(val, false);
    }

    private static String getAsPyishString(Object val, boolean forOutput) {
        try {
            return PyishObjectMapper.getAsPyishStringOrThrow(val, forOutput);
        }
        catch (IOException e) {
            PyishObjectMapper.handleLengthLimitingException(e);
            return Objects.toString(val, "");
        }
    }

    public static void handleLengthLimitingException(IOException e) {
        Throwable unwrapped = e;
        if (e instanceof JsonMappingException) {
            unwrapped = unwrapped.getCause();
        }
        if (unwrapped instanceof LengthLimitingJsonProcessingException) {
            throw new OutputTooBigException(((LengthLimitingJsonProcessingException)((Object)unwrapped)).getMaxSize(), ((LengthLimitingJsonProcessingException)((Object)unwrapped)).getAttemptedSize());
        }
        if (unwrapped instanceof OutputTooBigException) {
            throw (OutputTooBigException)unwrapped;
        }
    }

    public static String getAsPyishStringOrThrow(Object val) throws IOException {
        return PyishObjectMapper.getAsPyishStringOrThrow(val, false);
    }

    public static String getAsPyishStringOrThrow(Object val, boolean forOutput) throws IOException {
        Writer writer;
        boolean useSnakeCaseMappingOverride = JinjavaInterpreter.getCurrentMaybe().map(interpreter -> interpreter.getConfig().getLegacyOverrides().isUseSnakeCasePropertyNaming()).orElse(false);
        ObjectWriter objectWriter = useSnakeCaseMappingOverride ? SNAKE_CASE_PYISH_OBJECT_WRITER : PYISH_OBJECT_WRITER;
        Optional<Long> maxOutputSize = JinjavaInterpreter.getCurrentMaybe().map(interpreter -> interpreter.getConfig().getMaxOutputSize()).filter(max -> max > 0L);
        if (maxOutputSize.isPresent()) {
            AtomicInteger remainingLength = new AtomicInteger((int)Math.min(Integer.MAX_VALUE, maxOutputSize.get()));
            objectWriter = objectWriter.withAttribute((Object)"remainingLength", (Object)remainingLength);
            writer = new LengthLimitingWriter(new CharArrayWriter(), remainingLength);
        } else {
            writer = new CharArrayWriter();
        }
        if (!useSnakeCaseMappingOverride) {
            objectWriter = objectWriter.withAttribute((Object)ALLOW_SNAKE_CASE_ATTRIBUTE, (Object)(!forOutput ? 1 : 0));
        }
        objectWriter.writeValue(writer, val);
        return ((Object)writer).toString();
    }

    public static class NullKeySerializer
    extends JsonSerializer<Object> {
        public void serialize(Object o, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeFieldName("");
        }
    }
}

