/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.objects.serialization;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.ser.BeanSerializer;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.google.common.annotations.Beta;
import com.hubspot.jinjava.objects.serialization.BothCasingBeanSerializer;
import com.hubspot.jinjava.objects.serialization.MapEntrySerializer;
import com.hubspot.jinjava.objects.serialization.PyishSerializable;
import com.hubspot.jinjava.objects.serialization.PyishSerializer;
import java.util.Map;

@Beta
public class PyishBeanSerializerModifier
extends BeanSerializerModifier {
    public static final PyishBeanSerializerModifier INSTANCE = new PyishBeanSerializerModifier();

    private PyishBeanSerializerModifier() {
    }

    public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
        if (!PyishSerializable.class.isAssignableFrom(beanDesc.getBeanClass())) {
            if (Map.Entry.class.isAssignableFrom(beanDesc.getBeanClass())) {
                return MapEntrySerializer.INSTANCE;
            }
            if (serializer instanceof BeanSerializer) {
                return BothCasingBeanSerializer.wrapping(serializer);
            }
            return serializer;
        }
        return PyishSerializer.INSTANCE;
    }
}

