/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.objects.date;

import com.hubspot.jinjava.JinjavaConfig;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.objects.PyWrapper;
import com.hubspot.jinjava.objects.date.DateTimeProvider;
import com.hubspot.jinjava.objects.date.StrftimeFormatter;
import com.hubspot.jinjava.objects.serialization.PyishObjectMapper;
import com.hubspot.jinjava.objects.serialization.PyishSerializable;
import java.io.IOException;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.math.NumberUtils;

public final class PyishDate
extends Date
implements Serializable,
PyWrapper,
PyishSerializable {
    private static final long serialVersionUID = 1L;
    public static final String PYISH_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String FULL_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final String PYISH_DATE_CUSTOM_DATE_FORMAT_CONTEXT_KEY = "Jinjava_PyishDate_Custom_Format_Key";
    private final ZonedDateTime date;
    private String dateFormat = "yyyy-MM-dd HH:mm:ss";

    public PyishDate(ZonedDateTime dt) {
        super(dt.toInstant().toEpochMilli());
        this.date = dt;
    }

    public PyishDate(Date d) {
        this(ZonedDateTime.ofInstant(d.toInstant(), ZoneOffset.UTC));
    }

    public PyishDate(String publishDateStr) {
        this((Long)NumberUtils.toLong((String)Objects.requireNonNull(publishDateStr), (long)0L));
    }

    public PyishDate(Long epochMillis) {
        this(ZonedDateTime.ofInstant(Instant.ofEpochMilli(Optional.ofNullable(epochMillis).orElseGet(() -> JinjavaInterpreter.getCurrentMaybe().map(JinjavaInterpreter::getConfig).map(JinjavaConfig::getDateTimeProvider).map(DateTimeProvider::getCurrentTimeMillis).orElseGet(System::currentTimeMillis))), ZoneOffset.UTC));
    }

    public PyishDate(Instant instant) {
        this(ZonedDateTime.ofInstant(instant, ZoneOffset.UTC));
    }

    public String isoformat() {
        return this.strftime("yyyy-MM-dd");
    }

    public String strftime(String fmt) {
        return StrftimeFormatter.format(this.date, fmt);
    }

    @Override
    public int getYear() {
        return this.date.getYear();
    }

    @Override
    public int getMonth() {
        return this.date.getMonthValue();
    }

    @Override
    public int getDay() {
        return this.date.getDayOfMonth();
    }

    public int getHour() {
        return this.date.getHour();
    }

    public int getMinute() {
        return this.date.getMinute();
    }

    public int getSecond() {
        return this.date.getSecond();
    }

    public int getMicrosecond() {
        return this.date.get(ChronoField.MILLI_OF_SECOND);
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public PyishDate withDateFormat(String dateFormat) {
        this.setDateFormat(dateFormat);
        return this;
    }

    public Date toDate() {
        return Date.from(this.date.toInstant());
    }

    public ZonedDateTime toDateTime() {
        return this.date;
    }

    @Override
    public String toString() {
        if (JinjavaInterpreter.getCurrent() != null && JinjavaInterpreter.getCurrent().getContext().containsKey(PYISH_DATE_CUSTOM_DATE_FORMAT_CONTEXT_KEY)) {
            return this.strftime(JinjavaInterpreter.getCurrent().getContext().get(PYISH_DATE_CUSTOM_DATE_FORMAT_CONTEXT_KEY).toString());
        }
        return this.strftime(this.dateFormat);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.date);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PyishDate that = (PyishDate)obj;
        return Objects.equals(this.toDateTime(), that.toDateTime());
    }

    @Override
    public <T extends Appendable & CharSequence> T appendPyishString(T appendable) throws IOException {
        return (T)appendable.append("('").append(this.strftime(FULL_DATE_FORMAT)).append("'|strtotime(").append(PyishObjectMapper.getAsPyishStringOrThrow(FULL_DATE_FORMAT)).append(")).withDateFormat(").append(PyishObjectMapper.getAsPyishStringOrThrow(this.dateFormat)).append(')');
    }
}

