/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.tag.eager;

import com.google.common.annotations.Beta;
import com.hubspot.jinjava.interpret.DeferredValueException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.tag.SetTag;
import com.hubspot.jinjava.lib.tag.eager.EagerExecutionResult;
import com.hubspot.jinjava.lib.tag.eager.importing.AliasedEagerImportingStrategy;
import com.hubspot.jinjava.tree.TagNode;
import com.hubspot.jinjava.util.EagerReconstructionUtils;
import com.hubspot.jinjava.util.PrefixToPreserveState;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Triple;

@Beta
public abstract class EagerSetTagStrategy {
    protected final SetTag setTag;

    protected EagerSetTagStrategy(SetTag setTag) {
        this.setTag = setTag;
    }

    public String run(TagNode tagNode, JinjavaInterpreter interpreter) {
        String expression;
        String[] variables;
        int eqPos = tagNode.getHelpers().indexOf(61);
        if (eqPos > 0) {
            variables = tagNode.getHelpers().substring(0, eqPos).trim().split(",");
            expression = tagNode.getHelpers().substring(eqPos + 1).trim();
        } else {
            int filterPos = tagNode.getHelpers().indexOf(124);
            String var = tagNode.getHelpers().trim();
            if (filterPos >= 0) {
                var = tagNode.getHelpers().substring(0, filterPos).trim();
            }
            variables = new String[]{var};
            expression = tagNode.getHelpers();
        }
        EagerReconstructionUtils.removeMetaContextVariables(Arrays.stream(variables).map(String::trim), interpreter.getContext());
        EagerExecutionResult eagerExecutionResult = this.getEagerExecutionResult(tagNode, variables, expression, interpreter);
        if (eagerExecutionResult.getResult().isFullyResolved() && !interpreter.getContext().isDeferredExecutionMode()) {
            EagerReconstructionUtils.commitSpeculativeBindings(interpreter, eagerExecutionResult);
            Optional<String> maybeResolved = this.resolveSet(tagNode, variables, eagerExecutionResult, interpreter);
            if (maybeResolved.isPresent()) {
                return maybeResolved.get();
            }
        }
        Triple<String, String, String> triple = this.getPrefixTokenAndSuffix(tagNode, variables, eagerExecutionResult, interpreter);
        if (eagerExecutionResult.getResult().isFullyResolved() && interpreter.getContext().isDeferredExecutionMode()) {
            this.attemptResolve(tagNode, variables, eagerExecutionResult, interpreter);
        }
        return this.buildImage(tagNode, variables, eagerExecutionResult, triple, interpreter);
    }

    protected abstract EagerExecutionResult getEagerExecutionResult(TagNode var1, String[] var2, String var3, JinjavaInterpreter var4);

    protected abstract Optional<String> resolveSet(TagNode var1, String[] var2, EagerExecutionResult var3, JinjavaInterpreter var4);

    protected abstract Triple<String, String, String> getPrefixTokenAndSuffix(TagNode var1, String[] var2, EagerExecutionResult var3, JinjavaInterpreter var4);

    protected abstract void attemptResolve(TagNode var1, String[] var2, EagerExecutionResult var3, JinjavaInterpreter var4);

    protected abstract String buildImage(TagNode var1, String[] var2, EagerExecutionResult var3, Triple<String, String, String> var4, JinjavaInterpreter var5);

    protected PrefixToPreserveState getPrefixToPreserveState(EagerExecutionResult eagerExecutionResult, String[] variables, JinjavaInterpreter interpreter) {
        PrefixToPreserveState prefixToPreserveState = new PrefixToPreserveState();
        if (!eagerExecutionResult.getResult().isFullyResolved() || interpreter.getContext().isDeferredExecutionMode()) {
            prefixToPreserveState.putAll((Map)((Object)eagerExecutionResult.getPrefixToPreserveState()));
        } else {
            EagerReconstructionUtils.commitSpeculativeBindings(interpreter, eagerExecutionResult);
        }
        EagerReconstructionUtils.hydrateReconstructionFromContextBeforeDeferring(prefixToPreserveState, Stream.concat(eagerExecutionResult.getResult().getDeferredWords().stream(), Arrays.stream(variables).filter(var -> var.contains("."))).collect(Collectors.toSet()), interpreter);
        return prefixToPreserveState;
    }

    public static String getSuffixToPreserveState(String variables, JinjavaInterpreter interpreter) {
        if (variables.isEmpty()) {
            return "";
        }
        StringBuilder suffixToPreserveState = new StringBuilder();
        Optional<String> maybeTemporaryImportAlias = AliasedEagerImportingStrategy.getTemporaryImportAlias(interpreter.getContext());
        if (maybeTemporaryImportAlias.isPresent() && !AliasedEagerImportingStrategy.isTemporaryImportAlias(variables) && !interpreter.getContext().getMetaContextVariables().contains(variables)) {
            if (!interpreter.getContext().containsKey(maybeTemporaryImportAlias.get())) {
                throw new DeferredValueException("Cannot modify temporary import alias outside of import tag");
            }
            String updateString = EagerSetTagStrategy.getUpdateString(variables);
            suffixToPreserveState.append(EagerReconstructionUtils.buildDoUpdateTag(maybeTemporaryImportAlias.get(), updateString, interpreter));
        }
        return suffixToPreserveState.toString();
    }

    private static String getUpdateString(String variables) {
        List<String> varList = Arrays.stream(variables.split(",")).map(String::trim).collect(Collectors.toList());
        StringJoiner updateString = new StringJoiner(",");
        varList.forEach(var -> updateString.add(String.format("'%s': %s", var, var)));
        return "{" + updateString + "}";
    }
}

