/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.tag.eager;

import com.google.common.annotations.Beta;
import com.hubspot.jinjava.interpret.DeferredValueException;
import com.hubspot.jinjava.interpret.InterpretException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.fn.MacroFunction;
import com.hubspot.jinjava.lib.tag.FromTag;
import com.hubspot.jinjava.lib.tag.eager.EagerStateChangingTag;
import com.hubspot.jinjava.tree.Node;
import com.hubspot.jinjava.tree.parse.TagToken;
import com.hubspot.jinjava.util.EagerReconstructionUtils;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@Beta
public class EagerFromTag
extends EagerStateChangingTag<FromTag> {
    public EagerFromTag() {
        super(new FromTag());
    }

    public EagerFromTag(FromTag fromTag) {
        super(fromTag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getEagerTagImage(TagToken tagToken, JinjavaInterpreter interpreter) {
        Optional<String> maybeTemplateFile;
        List<String> helper = FromTag.getHelpers(tagToken);
        Map<String, String> imports = FromTag.getImportMap(helper);
        try {
            maybeTemplateFile = FromTag.getTemplateFile(helper, tagToken, interpreter);
        }
        catch (DeferredValueException e) {
            imports.values().forEach(value -> {
                MacroFunction deferredMacro = new MacroFunction(null, (String)value, null, false, null, tagToken.getLineNumber(), tagToken.getStartPosition());
                deferredMacro.setDeferred(true);
                interpreter.getContext().addGlobalMacro(deferredMacro);
            });
            return EagerReconstructionUtils.buildBlockOrInlineSetTag("current_path", interpreter.getContext().get("current_path"), interpreter) + tagToken.getImage();
        }
        if (!maybeTemplateFile.isPresent()) {
            return "";
        }
        String templateFile = maybeTemplateFile.get();
        try {
            String output;
            String template = interpreter.getResource(templateFile);
            Node node = interpreter.parse(template);
            JinjavaInterpreter child = interpreter.getConfig().getInterpreterFactory().newInstance(interpreter);
            child.getContext().put("import_resource_path", templateFile);
            JinjavaInterpreter.pushCurrent(child);
            try {
                output = child.render(node);
            }
            finally {
                JinjavaInterpreter.popCurrent();
            }
            interpreter.addAllChildErrors(templateFile, child.getErrorsCopy());
            if (!child.getContext().getDeferredNodes().isEmpty()) {
                FromTag.handleDeferredNodesDuringImport(tagToken, templateFile, imports, child, interpreter);
            }
            FromTag.integrateChild(imports, child, interpreter);
            Map<String, String> newToOldImportNames = EagerFromTag.getNewToOldWithoutMacros(imports, interpreter);
            if (child.getContext().getDeferredTokens().isEmpty() || output == null) {
                String string = "";
                return string;
            }
            if (newToOldImportNames.size() > 0) {
                output = output + EagerReconstructionUtils.buildSetTag(newToOldImportNames, interpreter, true);
            }
            String string = EagerReconstructionUtils.wrapInTag(output, "do", interpreter, true);
            return string;
        }
        catch (IOException e) {
            throw new InterpretException(e.getMessage(), (Throwable)e, tagToken.getLineNumber(), tagToken.getStartPosition());
        }
        finally {
            interpreter.getContext().popFromStack();
        }
    }

    private static Map<String, String> getNewToOldWithoutMacros(Map<String, String> oldToNewImportNames, JinjavaInterpreter interpreter) {
        return oldToNewImportNames.entrySet().stream().filter(e -> !((String)e.getKey()).equals(e.getValue())).filter(e -> interpreter.getContext().containsKey(e.getValue()) || !interpreter.getContext().isGlobalMacro((String)e.getValue())).collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }
}

