/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.tag.eager;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableMap;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.TemplateSyntaxException;
import com.hubspot.jinjava.lib.tag.CycleTag;
import com.hubspot.jinjava.lib.tag.eager.DeferredToken;
import com.hubspot.jinjava.lib.tag.eager.EagerExecutionResult;
import com.hubspot.jinjava.lib.tag.eager.EagerStateChangingTag;
import com.hubspot.jinjava.tree.parse.TagToken;
import com.hubspot.jinjava.util.EagerContextWatcher;
import com.hubspot.jinjava.util.EagerExpressionResolver;
import com.hubspot.jinjava.util.EagerReconstructionUtils;
import com.hubspot.jinjava.util.HelperStringTokenizer;
import com.hubspot.jinjava.util.PrefixToPreserveState;
import com.hubspot.jinjava.util.WhitespaceUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Beta
public class EagerCycleTag
extends EagerStateChangingTag<CycleTag> {
    public EagerCycleTag() {
        super(new CycleTag());
    }

    public EagerCycleTag(CycleTag cycleTag) {
        super(cycleTag);
    }

    @Override
    public String getEagerTagImage(TagToken tagToken, JinjavaInterpreter interpreter) {
        List<String> resolvedValues;
        String resolvedExpression;
        HelperStringTokenizer tk = new HelperStringTokenizer(tagToken.getHelpers());
        ArrayList<String> helper = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (String token : tk.allTokens()) {
            sb.append(token);
            if (token.endsWith(",")) continue;
            helper.add(sb.toString());
            sb = new StringBuilder();
        }
        if (sb.length() > 0) {
            helper.add(sb.toString());
        }
        String expression = '[' + (String)helper.get(0) + ']';
        EagerExecutionResult eagerExecutionResult = EagerContextWatcher.executeInChildContext(eagerInterpreter -> EagerExpressionResolver.resolveExpression(expression, interpreter), interpreter, EagerContextWatcher.EagerChildContextConfig.newBuilder().withTakeNewValue(true).build());
        PrefixToPreserveState prefixToPreserveState = new PrefixToPreserveState();
        if (!eagerExecutionResult.getResult().isFullyResolved() || interpreter.getContext().isDeferredExecutionMode()) {
            prefixToPreserveState.putAll((Map)((Object)eagerExecutionResult.getPrefixToPreserveState()));
        } else {
            EagerReconstructionUtils.commitSpeculativeBindings(interpreter, eagerExecutionResult);
        }
        if (eagerExecutionResult.getResult().toString().equals("''")) {
            resolvedExpression = this.normalizeResolvedExpression(expression);
            resolvedValues = new HelperStringTokenizer(resolvedExpression).splitComma(true).allTokens();
        } else {
            resolvedExpression = this.normalizeResolvedExpression(eagerExecutionResult.getResult().toString());
            if (!eagerExecutionResult.getResult().isFullyResolved()) {
                resolvedValues = new HelperStringTokenizer(resolvedExpression).splitComma(true).allTokens();
                EagerReconstructionUtils.hydrateReconstructionFromContextBeforeDeferring(prefixToPreserveState, eagerExecutionResult.getResult().getDeferredWords(), interpreter);
            } else {
                List objects = eagerExecutionResult.getResult().toList();
                if (objects.size() == 1 && objects.get(0) instanceof List) {
                    objects = (List)objects.get(0);
                }
                resolvedValues = objects.stream().map(interpreter::getAsString).collect(Collectors.toList());
                for (int i = 0; i < resolvedValues.size(); ++i) {
                    resolvedValues.set(i, interpreter.resolveString(resolvedValues.get(i), tagToken.getLineNumber(), tagToken.getStartPosition()));
                }
            }
        }
        if (helper.size() == 1) {
            return prefixToPreserveState.toString() + this.interpretPrintingCycle(tagToken, interpreter, resolvedValues, resolvedExpression, eagerExecutionResult.getResult());
        }
        if (helper.size() == 3) {
            return prefixToPreserveState.toString() + this.interpretSettingCycle(interpreter, resolvedValues, helper, resolvedExpression, eagerExecutionResult.getResult().isFullyResolved());
        }
        throw new TemplateSyntaxException(tagToken.getImage(), "Tag 'cycle' expects 1 or 3 helper(s), was: " + helper.size(), tagToken.getLineNumber(), tagToken.getStartPosition());
    }

    private String normalizeResolvedExpression(String resolvedExpression) {
        resolvedExpression = resolvedExpression.replace(", ", ",");
        if (WhitespaceUtils.isWrappedWith(resolvedExpression = resolvedExpression.substring(1, resolvedExpression.length() - 1), "[", "]")) {
            resolvedExpression = resolvedExpression.substring(1, resolvedExpression.length() - 1);
        }
        return resolvedExpression;
    }

    private String interpretSettingCycle(JinjavaInterpreter interpreter, List<String> values, List<String> helper, String resolvedExpression, boolean fullyResolved) {
        String var = helper.get(2);
        if (!fullyResolved) {
            return EagerReconstructionUtils.buildSetTag((Map<String, String>)ImmutableMap.of((Object)var, (Object)String.format("[%s]", resolvedExpression.replace(",", ", "))), interpreter, true);
        }
        interpreter.getContext().put(var, values);
        return "";
    }

    private String interpretPrintingCycle(TagToken tagToken, JinjavaInterpreter interpreter, List<String> values, String resolvedExpression, EagerExpressionResolver.EagerExpressionResult eagerExpressionResult) {
        if (interpreter.getContext().isDeferredExecutionMode()) {
            String reconstructedTag = this.reconstructCycleTag(resolvedExpression, tagToken);
            return reconstructedTag + (Object)((Object)new PrefixToPreserveState(EagerReconstructionUtils.handleDeferredTokenAndReconstructReferences(interpreter, DeferredToken.builderFromImage(reconstructedTag, tagToken).addUsedDeferredWords(eagerExpressionResult.getDeferredWords()).build())));
        }
        Integer forindex = (Integer)interpreter.retraceVariable("loop.index0", tagToken.getLineNumber(), tagToken.getStartPosition());
        if (forindex == null) {
            forindex = 0;
        }
        if (values.size() == 1) {
            String var = values.get(0);
            if (!eagerExpressionResult.isFullyResolved()) {
                return EagerCycleTag.getIsIterable(var, forindex, tagToken);
            }
            return var;
        }
        String item = values.get(forindex % values.size());
        if (!eagerExpressionResult.isFullyResolved() && EagerExpressionResolver.shouldBeEvaluated(item, interpreter)) {
            return String.format("{{ %s }}", values.get(forindex % values.size()));
        }
        return item;
    }

    private String reconstructCycleTag(String expression, TagToken tagToken) {
        return String.format("%s cycle %s %s", tagToken.getSymbols().getExpressionStartWithTag(), expression, tagToken.getSymbols().getExpressionEndWithTag());
    }

    private static String getIsIterable(String var, int forIndex, TagToken tagToken) {
        String tokenStart = tagToken.getSymbols().getExpressionStartWithTag();
        String tokenEnd = tagToken.getSymbols().getExpressionEndWithTag();
        return String.format("%s if exptest:iterable.evaluate(%s, %s) %s", tokenStart, var, "____int3rpr3t3r____", tokenEnd) + String.format("{{ %s[%d %% filter:length.filter(%s, %s)] }}", var, forIndex, var, "____int3rpr3t3r____") + String.format("%s else %s", tokenStart, tokenEnd) + String.format("{{ %s }}", var) + String.format("%s endif %s", tokenStart, tokenEnd);
    }
}

