/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.tag;

import com.google.common.collect.ImmutableMap;
import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.doc.annotations.JinjavaSnippet;
import com.hubspot.jinjava.doc.annotations.JinjavaTextMateSnippet;
import com.hubspot.jinjava.interpret.DeferredValue;
import com.hubspot.jinjava.interpret.DeferredValueException;
import com.hubspot.jinjava.interpret.ImportTagCycleException;
import com.hubspot.jinjava.interpret.InterpretException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.TemplateError;
import com.hubspot.jinjava.interpret.TemplateSyntaxException;
import com.hubspot.jinjava.interpret.errorcategory.BasicTemplateErrorCategory;
import com.hubspot.jinjava.lib.fn.MacroFunction;
import com.hubspot.jinjava.lib.tag.Tag;
import com.hubspot.jinjava.tree.Node;
import com.hubspot.jinjava.tree.TagNode;
import com.hubspot.jinjava.tree.parse.TagToken;
import com.hubspot.jinjava.util.HelperStringTokenizer;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

@JinjavaDoc(value="Allows you to access and use macros from a different template", params={@JinjavaParam(value="path", desc="Design Manager path to file to import"), @JinjavaParam(value="import_name", desc="Give a name to the imported file to access macros from")}, snippets={@JinjavaSnippet(desc="This example uses an html file containing two macros.", code="{% macro header(tag, title_text) %}\n<header> <{{ tag }}>{{ title_text }} </{{tag}}> </header>\n{% endmacro %}\n{% macro footer(tag, footer_text) %}\n<footer> <{{ tag }}>{{ footer_text }} </{{tag}}> </footer>\n{% endmacro %}"), @JinjavaSnippet(desc="The macro html file is imported from a different template. Macros are then accessed from the name given to the import.", code="{% import 'custom/page/web_page_basic/my_macros.html' as header_footer %}\n{{ header_footer.header('h1', 'My page title') }}\n{{ header_footer.footer('h3', 'Company footer info') }}")})
@JinjavaTextMateSnippet(code="{% import '${1:path}' ${2: as ${3:import_name}} %}")
public class ImportTag
implements Tag {
    public static final String TAG_NAME = "import";
    private static final long serialVersionUID = 8433638845398005260L;

    @Override
    public String getName() {
        return TAG_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String interpret(TagNode tagNode, JinjavaInterpreter interpreter) {
        List<String> helper = ImportTag.getHelpers((TagToken)tagNode.getMaster());
        String contextVar = ImportTag.getContextVar(helper);
        Optional<String> maybeTemplateFile = ImportTag.getTemplateFile(helper, (TagToken)tagNode.getMaster(), interpreter);
        if (!maybeTemplateFile.isPresent()) {
            return "";
        }
        String templateFile = maybeTemplateFile.get();
        try {
            Node node = ImportTag.parseTemplateAsNode(interpreter, templateFile);
            JinjavaInterpreter child = interpreter.getConfig().getInterpreterFactory().newInstance(interpreter);
            child.getContext().put("import_resource_path", templateFile);
            JinjavaInterpreter.pushCurrent(child);
            try {
                child.render(node);
            }
            finally {
                JinjavaInterpreter.popCurrent();
            }
            interpreter.addAllChildErrors(templateFile, child.getErrorsCopy());
            Map<String, Object> childBindings = child.getContext().getSessionBindings();
            if (!child.getContext().getDeferredNodes().isEmpty()) {
                ImportTag.handleDeferredNodesDuringImport(node, contextVar, childBindings, child, interpreter);
                throw new DeferredValueException(templateFile, tagNode.getLineNumber(), tagNode.getStartPosition());
            }
            ImportTag.integrateChild(contextVar, childBindings, child, interpreter);
            String string = "";
            return string;
        }
        catch (IOException e) {
            throw new InterpretException(e.getMessage(), (Throwable)e, tagNode.getLineNumber(), tagNode.getStartPosition());
        }
        finally {
            interpreter.getContext().getCurrentPathStack().pop();
            interpreter.getContext().getImportPathStack().pop();
        }
    }

    public static void integrateChild(String contextVar, Map<String, Object> childBindings, JinjavaInterpreter child, JinjavaInterpreter parent) {
        if (StringUtils.isBlank((CharSequence)contextVar)) {
            for (MacroFunction macro : child.getContext().getGlobalMacros().values()) {
                parent.getContext().addGlobalMacro(macro);
            }
            childBindings.remove("__macros__");
            parent.getContext().putAll(ImportTag.getChildBindingsWithoutImportResourcePath(childBindings));
        } else {
            childBindings.putAll(child.getContext().getGlobalMacros());
            childBindings.remove("__macros__");
            parent.getContext().put(contextVar, childBindings);
        }
    }

    public static Map<String, Object> getChildBindingsWithoutImportResourcePath(Map<String, Object> childBindings) {
        HashMap<String, Object> filteredMap = new HashMap<String, Object>();
        childBindings.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("import_resource_path")).forEach(entry -> filteredMap.put((String)entry.getKey(), entry.getValue()));
        return filteredMap;
    }

    public static void handleDeferredNodesDuringImport(Node node, String contextVar, Map<String, Object> childBindings, JinjavaInterpreter child, JinjavaInterpreter interpreter) {
        node.getChildren().forEach(deferredChild -> interpreter.getContext().handleDeferredNode((Node)deferredChild));
        if (StringUtils.isBlank((CharSequence)contextVar)) {
            for (MacroFunction macro : child.getContext().getGlobalMacros().values()) {
                macro.setDeferred(true);
                interpreter.getContext().addGlobalMacro(macro);
            }
            childBindings.remove("__macros__");
            childBindings.keySet().forEach(key -> interpreter.getContext().put(key, DeferredValue.instance()));
        } else {
            for (Map.Entry<String, MacroFunction> macroEntry : child.getContext().getGlobalMacros().entrySet()) {
                MacroFunction macro = macroEntry.getValue();
                macro.setDeferred(true);
                childBindings.put(macroEntry.getKey(), macro);
            }
            childBindings.remove("__macros__");
            interpreter.getContext().put(contextVar, DeferredValue.instance(childBindings));
        }
    }

    public static Node parseTemplateAsNode(JinjavaInterpreter interpreter, String templateFile) throws IOException {
        interpreter.getContext().getCurrentPathStack().push(templateFile, interpreter.getLineNumber(), interpreter.getPosition());
        String template = interpreter.getResource(templateFile);
        return interpreter.parse(template);
    }

    public static Optional<String> getTemplateFile(List<String> helper, TagToken tagToken, JinjavaInterpreter interpreter) {
        String path = StringUtils.trimToEmpty((String)helper.get(0));
        String templateFile = interpreter.resolveString(path, tagToken.getLineNumber(), tagToken.getStartPosition());
        templateFile = interpreter.resolveResourceLocation(templateFile);
        interpreter.getContext().addDependency("coded_files", templateFile);
        try {
            interpreter.getContext().getImportPathStack().push(path, tagToken.getLineNumber(), tagToken.getStartPosition());
        }
        catch (ImportTagCycleException e) {
            interpreter.addError(new TemplateError(TemplateError.ErrorType.WARNING, TemplateError.ErrorReason.EXCEPTION, TemplateError.ErrorItem.TAG, "Import cycle detected for path: '" + path + "'", null, tagToken.getLineNumber(), tagToken.getStartPosition(), e, BasicTemplateErrorCategory.IMPORT_CYCLE_DETECTED, (Map<String, String>)ImmutableMap.of((Object)"path", (Object)path)));
            return Optional.empty();
        }
        return Optional.of(templateFile);
    }

    public static String getContextVar(List<String> helper) {
        String contextVar = "";
        if (helper.size() > 2 && "as".equals(helper.get(1))) {
            contextVar = helper.get(2);
        }
        return contextVar;
    }

    public static List<String> getHelpers(TagToken tagToken) {
        List<String> helper = new HelperStringTokenizer(tagToken.getHelpers()).allTokens();
        if (helper.isEmpty()) {
            throw new TemplateSyntaxException(tagToken.getImage(), "Tag 'import' expects 1 helper, was: " + helper.size(), tagToken.getLineNumber(), tagToken.getStartPosition());
        }
        return helper;
    }

    @Override
    public String getEndTagName() {
        return null;
    }
}

