/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.tag;

import com.google.common.collect.Lists;
import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaHasCodeBody;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.doc.annotations.JinjavaSnippet;
import com.hubspot.jinjava.doc.annotations.JinjavaTextMateSnippet;
import com.hubspot.jinjava.el.ext.DeferredParsingException;
import com.hubspot.jinjava.interpret.DeferredValue;
import com.hubspot.jinjava.interpret.DeferredValueException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.TemplateSyntaxException;
import com.hubspot.jinjava.lib.tag.Tag;
import com.hubspot.jinjava.tree.ExpressionNode;
import com.hubspot.jinjava.tree.TagNode;
import com.hubspot.jinjava.tree.parse.TagToken;
import com.hubspot.jinjava.util.HelperStringTokenizer;
import com.hubspot.jinjava.util.LengthLimitingStringBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.Pair;

@JinjavaDoc(value="Outputs the inner content for each item in the given iterable", params={@JinjavaParam(value="items_to_iterate", desc="Specifies the name of a single item in the sequence or dict.")}, snippets={@JinjavaSnippet(code="{% for item in items %}\n    {{ item }}\n{% endfor %}"), @JinjavaSnippet(desc="Iterating over dictionary values", code="{% for value in dictionary %}\n    {{ value }}\n{% endfor %}"), @JinjavaSnippet(desc="Iterating over dictionary entries", code="{% for key, value in dictionary.items() %}\n    {{ key }}: {{ value }}\n{% endfor %}"), @JinjavaSnippet(desc="Standard blog listing loop", code="{% for content in contents %}\n    Post content variables\n{% endfor %}")})
@JinjavaHasCodeBody
@JinjavaTextMateSnippet(code="{% for ${1:items} in ${2:list} %}\n$0\n{% endfor %}")
public class ForTag
implements Tag {
    public static final String TAG_NAME = "for";
    public static final String LOOP = "loop";
    private static final long serialVersionUID = 6175143875754966497L;
    private static final Pattern IN_PATTERN = Pattern.compile("\\sin\\s");
    public static final String TOO_LARGE_EXCEPTION_MESSAGE = "Loop too large";

    @Override
    public boolean isRenderedInValidationMode() {
        return true;
    }

    @Override
    public String interpret(TagNode tagNode, JinjavaInterpreter interpreter) {
        long numDeferredNodesBefore = interpreter.getContext().getDeferredNodes().stream().filter(n -> !(n instanceof ExpressionNode)).count();
        String result = this.interpretUnchecked(tagNode, interpreter);
        if (interpreter.getContext().getDeferredNodes().stream().filter(n -> !(n instanceof ExpressionNode)).count() > numDeferredNodesBefore) {
            throw new DeferredValueException("for loop", interpreter.getLineNumber(), interpreter.getPosition());
        }
        return result;
    }

    public String interpretUnchecked(TagNode tagNode, JinjavaInterpreter interpreter) {
        Object collection;
        Pair<List<String>, String> loopVarsAndExpression = this.getLoopVarsAndExpression((TagToken)tagNode.getMaster());
        List loopVars = (List)loopVarsAndExpression.getLeft();
        String loopExpression = (String)loopVarsAndExpression.getRight();
        try {
            collection = interpreter.resolveELExpression(loopExpression, tagNode.getLineNumber());
        }
        catch (DeferredParsingException e) {
            throw new DeferredParsingException(String.format("%s in %s", String.join((CharSequence)", ", loopVars), e.getDeferredEvalResult()));
        }
        return this.renderForCollection(tagNode, interpreter, loopVars, collection);
    }

    /*
     * Exception decompiling
     */
    public String renderForCollection(TagNode tagNode, JinjavaInterpreter interpreter, List<String> loopVars, Object collection) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String checkLoopVariable(JinjavaInterpreter interpreter, LengthLimitingStringBuilder buff) {
        if (interpreter.getContext().get(LOOP) instanceof DeferredValue) {
            throw new DeferredValueException("loop variable deferred", interpreter.getLineNumber(), interpreter.getPosition());
        }
        return buff.toString();
    }

    public Pair<List<String>, String> getLoopVarsAndExpression(TagToken tagToken) {
        List<String> helperTokens = new HelperStringTokenizer(tagToken.getHelpers()).splitComma(true).allTokens();
        List<String> loopVars = this.getLoopVars(helperTokens);
        Optional<String> maybeLoopExpr = this.getLoopExpression(tagToken.getHelpers());
        if (loopVars.size() >= helperTokens.size() || !maybeLoopExpr.isPresent()) {
            throw new TemplateSyntaxException(tagToken.getHelpers().trim(), "Tag 'for' expects valid 'in' clause, got: " + tagToken.getHelpers(), tagToken.getLineNumber(), tagToken.getStartPosition());
        }
        return Pair.of(loopVars, (Object)maybeLoopExpr.get());
    }

    private Optional<String> getLoopExpression(String helpers) {
        Matcher matcher = IN_PATTERN.matcher(helpers);
        if (matcher.find()) {
            return Optional.of(helpers.substring(matcher.end()).trim());
        }
        return Optional.empty();
    }

    private List<String> getLoopVars(List<String> helper) {
        String val;
        ArrayList loopVars = Lists.newArrayList();
        while (loopVars.size() < helper.size() && !"in".equals(val = helper.get(loopVars.size()))) {
            loopVars.add(val);
        }
        return loopVars;
    }

    @Override
    public String getName() {
        return TAG_NAME;
    }
}

