/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.filter;

import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.doc.annotations.JinjavaSnippet;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.filter.Filter;
import java.util.Objects;
import org.apache.commons.lang3.StringEscapeUtils;

@JinjavaDoc(value="Converts HTML entities in string s to Unicode characters.", input={@JinjavaParam(value="s", desc="String to unescape", required=true)}, snippets={@JinjavaSnippet(code="{% set escaped_string = \"<div>This &amp; that</div>\" %}\n{{ escaped_string|unescape_html }}")})
public class UnescapeHtmlFilter
implements Filter {
    @Override
    public Object filter(Object object, JinjavaInterpreter interpreter, String ... arg) {
        return StringEscapeUtils.unescapeHtml4((String)Objects.toString(object, ""));
    }

    @Override
    public String getName() {
        return "unescape_html";
    }
}

