/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.filter;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.doc.annotations.JinjavaSnippet;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.filter.Filter;
import java.util.Objects;
import org.apache.commons.lang3.math.NumberUtils;

@JinjavaDoc(value="Splits the input string into a list on the given separator", input={@JinjavaParam(value="string", desc="The string to split", required=true)}, params={@JinjavaParam(value="separator", defaultValue=" ", desc="Specifies the separator to split the variable by"), @JinjavaParam(value="limit", type="number", defaultValue="0", desc="Limits resulting list by putting remainder of string into last list item")}, snippets={@JinjavaSnippet(code="{% set string_to_split = \"Stephen; David; Cait; Nancy; Mike; Joe; Niall; Tim; Amanda\" %}\n{% set names = string_to_split|split(';', 4) %}\n<ul>\n   {% for name in names %}\n       <li>{{ name }}</li>\n   {% endfor %}\n</ul>")})
public class SplitFilter
implements Filter {
    @Override
    public String getName() {
        return "split";
    }

    @Override
    public Object filter(Object var, JinjavaInterpreter interpreter, String ... args) {
        int limit;
        Splitter splitter = args != null && args.length > 0 ? (args[0] != null ? Splitter.on((String)args[0]) : Splitter.on((CharMatcher)CharMatcher.whitespace())) : Splitter.on((CharMatcher)CharMatcher.whitespace());
        if (args != null && args.length > 1 && (limit = NumberUtils.toInt((String)args[1], (int)0)) > 0) {
            splitter = splitter.limit(limit);
        }
        return Lists.newArrayList((Iterable)splitter.omitEmptyStrings().trimResults().split((CharSequence)Objects.toString(var, "")));
    }
}

