/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.filter;

import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.doc.annotations.JinjavaSnippet;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.filter.Filter;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import org.apache.commons.lang3.math.NumberUtils;

@JinjavaDoc(value="Convert the value into an integer.", input={@JinjavaParam(value="value", desc="The value to convert to an integer", required=true)}, params={@JinjavaParam(value="default", type="number", defaultValue="0", desc="Value to return if the conversion fails")}, snippets={@JinjavaSnippet(desc="This example converts a text field string value to a integer", code="{% text \"my_text\" value='25', export_to_template_context=True %}\n{% widget_data.my_text.value|int + 28 %}")})
public class IntFilter
implements Filter {
    @Override
    public String getName() {
        return "int";
    }

    @Override
    public Object filter(Object var, JinjavaInterpreter interpreter, String ... args) {
        Long result;
        Long defaultVal = 0L;
        if (args.length > 0) {
            defaultVal = NumberUtils.toLong((String)args[0], (long)0L);
        }
        if (var == null) {
            return this.convertResult(defaultVal);
        }
        if (Number.class.isAssignableFrom(var.getClass())) {
            return this.convertResult(((Number)var).longValue());
        }
        String input = var.toString().trim();
        Locale locale = interpreter.getConfig().getLocale();
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        ParsePosition pp = new ParsePosition(0);
        try {
            result = numberFormat.parse(input, pp).longValue();
        }
        catch (Exception e) {
            result = defaultVal;
        }
        if (pp.getErrorIndex() != -1 || pp.getIndex() != input.length()) {
            result = defaultVal;
        }
        return this.convertResult(result);
    }

    private Object convertResult(Long result) {
        if (result < Integer.MIN_VALUE || result > Integer.MAX_VALUE) {
            return result;
        }
        return result.intValue();
    }
}

