/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.filter;

import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.doc.annotations.JinjavaSnippet;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.filter.Filter;
import java.util.Objects;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.math.NumberUtils;

@JinjavaDoc(value="Format the value like a \u2018human-readable\u2019 file size (i.e. 13 kB, 4.1 MB, 102 Bytes, etc).", input={@JinjavaParam(value="value", desc="The value to convert to filesize format", required=true)}, params={@JinjavaParam(value="binary", type="boolean", defaultValue="False", desc="Use binary prefixes (Mebi, Gibi)")}, snippets={@JinjavaSnippet(code="{% set bytes = 100000 %}\n{{ bytes|filesizeformat }}")})
public class FileSizeFormatFilter
implements Filter {
    private static final String[] BINARY_SIZES = new String[]{"KiB", "MiB", "GiB", "TiB", "PiB", "EiB", "ZiB", "YiB"};
    private static final String[] DECIMAL_SIZES = new String[]{"KB", "MB", "GB", "TB", "PB", "EB", "ZB", "YB"};

    @Override
    public String getName() {
        return "filesizeformat";
    }

    @Override
    public Object filter(Object var, JinjavaInterpreter interpreter, String ... args) {
        int base;
        float bytes = NumberUtils.toFloat((String)Objects.toString(var), (float)0.0f);
        if (bytes == 1.0f) {
            return "1 Byte";
        }
        boolean binary = false;
        if (args.length > 0) {
            binary = BooleanUtils.toBoolean((String)args[0]);
        }
        int n = base = binary ? 1024 : 1000;
        if (bytes < (float)base) {
            return (int)bytes + " Bytes";
        }
        String[] sizes = binary ? BINARY_SIZES : DECIMAL_SIZES;
        long unit = 1L;
        String prefix = "";
        for (int i = 0; i < sizes.length; ++i) {
            unit = (long)Math.pow(base, i + 2);
            prefix = sizes[i];
            if (!(bytes < (float)unit)) continue;
            return String.format("%.1f %s", (float)base * bytes / (float)unit, prefix);
        }
        return String.format("%.1f %s", (float)base * bytes / (float)unit, prefix);
    }
}

