/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.interpret;

import com.google.common.collect.ImmutableMap;
import com.hubspot.jinjava.interpret.InterpretException;
import com.hubspot.jinjava.interpret.InvalidArgumentException;
import com.hubspot.jinjava.interpret.InvalidInputException;
import com.hubspot.jinjava.interpret.TemplateSyntaxException;
import com.hubspot.jinjava.interpret.UnknownTagException;
import com.hubspot.jinjava.interpret.errorcategory.BasicTemplateErrorCategory;
import com.hubspot.jinjava.interpret.errorcategory.TemplateErrorCategory;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class TemplateError {
    private static final Pattern GENERIC_TOSTRING_PATTERN = Pattern.compile("@[0-9a-z]{4,}$");
    private static final int MAX_STRING_LENGTH = 1024;
    private final ErrorType severity;
    private final ErrorReason reason;
    private final ErrorItem item;
    private String message;
    private final String fieldName;
    private int lineno;
    private int startPosition;
    private final TemplateErrorCategory category;
    private final Map<String, String> categoryErrors;
    private String sourceTemplate;
    private int scopeDepth = 1;
    private final Exception exception;

    public TemplateError withScopeDepth(int scopeDepth) {
        TemplateError error = new TemplateError(this.getSeverity(), this.getReason(), this.getItem(), this.getMessage(), this.getFieldName(), this.getLineno(), this.getStartPosition(), this.getException(), this.getCategory(), this.getCategoryErrors(), scopeDepth);
        this.getSourceTemplate().ifPresent(error::setSourceTemplate);
        return error;
    }

    public static TemplateError fromSyntaxError(InterpretException ex) {
        return new TemplateError(ErrorType.FATAL, ErrorReason.SYNTAX_ERROR, ErrorItem.OTHER, ExceptionUtils.getMessage((Throwable)ex), null, ex.getLineNumber(), ex.getStartPosition(), ex);
    }

    public static TemplateError fromException(TemplateSyntaxException ex) {
        String fieldName = ex instanceof UnknownTagException ? ((UnknownTagException)ex).getTag() : ex.getCode();
        return new TemplateError(ErrorType.FATAL, ErrorReason.SYNTAX_ERROR, ErrorItem.OTHER, ex.getMessage(), fieldName, ex.getLineNumber(), ex.getStartPosition(), ex);
    }

    public static TemplateError fromInvalidArgumentException(InvalidArgumentException ex) {
        return new TemplateError(ErrorType.FATAL, ErrorReason.INVALID_ARGUMENT, ErrorItem.PROPERTY, ex.getMessage(), ex.getName(), ex.getLineNumber(), ex.getStartPosition(), ex);
    }

    public static TemplateError fromInvalidInputException(InvalidInputException ex) {
        return new TemplateError(ErrorType.FATAL, ErrorReason.INVALID_INPUT, ErrorItem.PROPERTY, ex.getMessage(), ex.getName(), ex.getLineNumber(), ex.getStartPosition(), ex);
    }

    public static TemplateError fromMissingFilterArgException(InvalidArgumentException ex) {
        return new TemplateError(ErrorType.WARNING, ErrorReason.INVALID_ARGUMENT, ErrorItem.FILTER, ex.getMessage(), ex.getName(), ex.getLineNumber(), ex.getStartPosition(), ex);
    }

    public static TemplateError fromException(Exception ex) {
        int lineNumber = -1;
        int startPosition = -1;
        if (ex instanceof InterpretException) {
            lineNumber = ((InterpretException)ex).getLineNumber();
            startPosition = ((InterpretException)ex).getStartPosition();
        }
        return new TemplateError(ErrorType.FATAL, ErrorReason.EXCEPTION, ErrorItem.OTHER, ExceptionUtils.getMessage((Throwable)ex), null, lineNumber, startPosition, ex, BasicTemplateErrorCategory.UNKNOWN, (Map<String, String>)ImmutableMap.of());
    }

    public static TemplateError fromOutputTooBigException(Exception ex) {
        return new TemplateError(ErrorType.FATAL, ErrorReason.OUTPUT_TOO_BIG, ErrorItem.OTHER, ExceptionUtils.getMessage((Throwable)ex), null, -1, -1, ex, BasicTemplateErrorCategory.UNKNOWN, (Map<String, String>)ImmutableMap.of());
    }

    public static TemplateError fromException(Exception ex, int lineNumber, int startPosition) {
        return new TemplateError(ErrorType.FATAL, ErrorReason.EXCEPTION, ErrorItem.OTHER, ExceptionUtils.getMessage((Throwable)ex), null, lineNumber, startPosition, ex);
    }

    public static TemplateError fromException(Exception ex, int lineNumber) {
        return new TemplateError(ErrorType.FATAL, ErrorReason.EXCEPTION, ErrorItem.OTHER, ExceptionUtils.getMessage((Throwable)ex), null, lineNumber, -1, ex);
    }

    public static TemplateError fromUnknownProperty(Object base, String variable, int lineNumber) {
        return TemplateError.fromUnknownProperty(base, variable, lineNumber, -1);
    }

    public static TemplateError fromUnknownProperty(Object base, String variable, int lineNumber, int startPosition) {
        return new TemplateError(ErrorType.WARNING, ErrorReason.UNKNOWN, ErrorItem.PROPERTY, String.format("Cannot resolve property '%s' in '%s'", variable, TemplateError.friendlyObjectToString(base)), variable, lineNumber, startPosition, null, BasicTemplateErrorCategory.UNKNOWN_PROPERTY, (Map<String, String>)ImmutableMap.of((Object)"property", (Object)variable, (Object)"lineNumber", (Object)String.valueOf(lineNumber), (Object)"startPosition", (Object)String.valueOf(startPosition)));
    }

    private static String friendlyObjectToString(Object o) {
        if (o == null) {
            return "null";
        }
        String s = o.toString();
        if (s.length() > 1024) {
            s = s.substring(0, 1024) + "...";
        }
        if (!GENERIC_TOSTRING_PATTERN.matcher(s).find()) {
            return s;
        }
        Class<?> c = o.getClass();
        return c.getSimpleName();
    }

    public TemplateError(ErrorType severity, ErrorReason reason, ErrorItem item, String message, String fieldName, int lineno, Exception exception) {
        this.severity = severity;
        this.reason = reason;
        this.item = item;
        this.message = message;
        this.fieldName = fieldName;
        this.lineno = lineno;
        this.startPosition = -1;
        this.exception = exception;
        this.category = BasicTemplateErrorCategory.UNKNOWN;
        this.categoryErrors = null;
    }

    public TemplateError(ErrorType severity, ErrorReason reason, ErrorItem item, String message, String fieldName, int lineno, int startPosition, Exception exception) {
        this.severity = severity;
        this.reason = reason;
        this.item = item;
        this.message = message;
        this.fieldName = fieldName;
        this.lineno = lineno;
        this.startPosition = startPosition;
        this.exception = exception;
        this.category = BasicTemplateErrorCategory.UNKNOWN;
        this.categoryErrors = null;
    }

    public TemplateError(ErrorType severity, ErrorReason reason, ErrorItem item, String message, String fieldName, int lineno, int startPosition, Exception exception, TemplateErrorCategory category, Map<String, String> categoryErrors, int scopeDepth) {
        this.severity = severity;
        this.reason = reason;
        this.item = item;
        this.message = message;
        this.fieldName = fieldName;
        this.lineno = lineno;
        this.startPosition = startPosition;
        this.exception = exception;
        this.category = category;
        this.categoryErrors = categoryErrors;
        this.scopeDepth = scopeDepth;
    }

    public TemplateError(ErrorType severity, ErrorReason reason, ErrorItem item, String message, String fieldName, int lineno, Exception exception, TemplateErrorCategory category, Map<String, String> categoryErrors) {
        this.severity = severity;
        this.reason = reason;
        this.item = item;
        this.message = message;
        this.fieldName = fieldName;
        this.lineno = lineno;
        this.startPosition = -1;
        this.exception = exception;
        this.category = category;
        this.categoryErrors = categoryErrors;
    }

    public TemplateError(ErrorType severity, ErrorReason reason, ErrorItem item, String message, String fieldName, int lineno, int startPosition, Exception exception, TemplateErrorCategory category, Map<String, String> categoryErrors) {
        this.severity = severity;
        this.reason = reason;
        this.item = item;
        this.message = message;
        this.fieldName = fieldName;
        this.lineno = lineno;
        this.startPosition = startPosition;
        this.exception = exception;
        this.category = category;
        this.categoryErrors = categoryErrors;
    }

    public TemplateError(ErrorType severity, ErrorReason reason, String message, String fieldName, int lineno, int startPosition, Exception exception) {
        this.severity = severity;
        this.reason = reason;
        this.item = ErrorItem.OTHER;
        this.message = message;
        this.fieldName = fieldName;
        this.lineno = lineno;
        this.startPosition = startPosition;
        this.exception = exception;
        this.category = BasicTemplateErrorCategory.UNKNOWN;
        this.categoryErrors = null;
    }

    public ErrorType getSeverity() {
        return this.severity;
    }

    public ErrorReason getReason() {
        return this.reason;
    }

    public ErrorItem getItem() {
        return this.item;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public int getLineno() {
        return this.lineno;
    }

    public void setLineno(int lineno) {
        this.lineno = lineno;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(int startPosition) {
        this.startPosition = startPosition;
    }

    public Exception getException() {
        return this.exception;
    }

    public TemplateErrorCategory getCategory() {
        return this.category;
    }

    public Map<String, String> getCategoryErrors() {
        return this.categoryErrors;
    }

    public int getScopeDepth() {
        return this.scopeDepth;
    }

    public Optional<String> getSourceTemplate() {
        return Optional.ofNullable(this.sourceTemplate);
    }

    public void setSourceTemplate(String sourceTemplate) {
        this.sourceTemplate = sourceTemplate;
    }

    public TemplateError serializable() {
        return new TemplateError(this.severity, this.reason, this.item, this.message, this.fieldName, this.lineno, this.startPosition, null, this.category, this.categoryErrors, this.scopeDepth);
    }

    public String toString() {
        return "TemplateError{severity=" + (Object)((Object)this.severity) + ", reason=" + (Object)((Object)this.reason) + ", item=" + (Object)((Object)this.item) + ", message='" + this.message + '\'' + ", fieldName='" + this.fieldName + '\'' + ", lineno=" + this.lineno + ", startPosition=" + this.startPosition + ", scopeDepth=" + this.scopeDepth + ", category=" + this.category + ", categoryErrors=" + this.categoryErrors + '}';
    }

    public boolean equals(Object o) {
        if (!(o instanceof TemplateError)) {
            return false;
        }
        TemplateError other = (TemplateError)o;
        return Objects.equals((Object)this.severity, (Object)other.severity) && Objects.equals((Object)this.reason, (Object)other.reason) && Objects.equals((Object)this.item, (Object)other.item) && Objects.equals(this.message, other.message) && Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.lineno, other.lineno) && Objects.equals(this.startPosition, other.startPosition) && Objects.equals(this.category, other.category) && Objects.equals(this.categoryErrors, other.categoryErrors) && Objects.equals(this.scopeDepth, other.scopeDepth);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.severity, this.reason, this.item, this.message, this.fieldName, this.lineno, this.startPosition, this.category, this.categoryErrors, this.scopeDepth, this.sourceTemplate});
    }

    public static enum ErrorItem {
        TEMPLATE,
        TOKEN,
        TAG,
        FUNCTION,
        PROPERTY,
        FILTER,
        EXPRESSION_TEST,
        OTHER;

    }

    public static enum ErrorReason {
        SYNTAX_ERROR,
        UNKNOWN,
        BAD_URL,
        EXCEPTION,
        MISSING,
        DISABLED,
        INVALID_ARGUMENT,
        INVALID_INPUT,
        OUTPUT_TOO_BIG,
        OVER_LIMIT,
        COLLECTION_TOO_BIG,
        OTHER;

    }

    public static enum ErrorType {
        FATAL,
        WARNING;

    }
}

