/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.el.ext.eager;

import com.hubspot.jinjava.el.ext.DeferredInvocationResolutionException;
import com.hubspot.jinjava.el.ext.DeferredParsingException;
import com.hubspot.jinjava.el.ext.IdentifierPreservationStrategy;
import com.hubspot.jinjava.el.ext.eager.EagerAstNodeDecorator;
import com.hubspot.jinjava.el.ext.eager.EvalResultHolder;
import com.hubspot.jinjava.interpret.DeferredValueException;
import jinjava.de.odysseus.el.tree.Bindings;
import jinjava.de.odysseus.el.tree.impl.ast.AstMethod;
import jinjava.de.odysseus.el.tree.impl.ast.AstParameters;
import jinjava.de.odysseus.el.tree.impl.ast.AstProperty;
import jinjava.javax.el.ELContext;
import jinjava.javax.el.ELException;

public class EagerAstMethod
extends AstMethod
implements EvalResultHolder {
    protected Object evalResult;
    protected boolean hasEvalResult;
    protected final EvalResultHolder property;
    protected final EvalResultHolder params;

    public EagerAstMethod(AstProperty property, AstParameters params) {
        this(EagerAstNodeDecorator.getAsEvalResultHolder(property), EagerAstNodeDecorator.getAsEvalResultHolder(params));
    }

    private EagerAstMethod(EvalResultHolder property, EvalResultHolder params) {
        super((AstProperty)((Object)property), (AstParameters)((Object)params));
        this.property = property;
        this.params = params;
    }

    @Override
    public Object eval(Bindings bindings, ELContext context) {
        try {
            this.setEvalResult(super.eval(bindings, context));
            return this.checkEvalResultSize(context);
        }
        catch (DeferredValueException | ELException originalException) {
            DeferredParsingException e = EvalResultHolder.convertToDeferredParsingException(originalException);
            throw new DeferredParsingException(this, this.getPartiallyResolved(bindings, context, e, IdentifierPreservationStrategy.PRESERVING), IdentifierPreservationStrategy.PRESERVING);
        }
    }

    @Override
    public Object getEvalResult() {
        return this.evalResult;
    }

    @Override
    public void setEvalResult(Object evalResult) {
        this.evalResult = evalResult;
        this.hasEvalResult = true;
    }

    @Override
    public boolean hasEvalResult() {
        return this.hasEvalResult;
    }

    @Override
    public String getPartiallyResolved(Bindings bindings, ELContext context, DeferredParsingException deferredParsingException, IdentifierPreservationStrategy identifierPreservationStrategy) {
        if (deferredParsingException instanceof DeferredInvocationResolutionException) {
            return deferredParsingException.getDeferredEvalResult();
        }
        String propertyResult = this.property.getPartiallyResolved(bindings, context, deferredParsingException, identifierPreservationStrategy);
        String paramString = EvalResultHolder.exceptionMatchesNode(deferredParsingException, this.params) ? deferredParsingException.getDeferredEvalResult() : this.params.getPartiallyResolved(bindings, context, deferredParsingException, identifierPreservationStrategy);
        return propertyResult + String.format("(%s)", paramString);
    }
}

