/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.el.ext;

import com.hubspot.jinjava.el.ext.eager.EagerAstBinary;
import jinjava.de.odysseus.el.misc.TypeConverter;
import jinjava.de.odysseus.el.tree.impl.Parser;
import jinjava.de.odysseus.el.tree.impl.Scanner;
import jinjava.de.odysseus.el.tree.impl.ast.AstBinary;
import jinjava.de.odysseus.el.tree.impl.ast.AstNode;

public class TruncDivOperator
extends AstBinary.SimpleOperator {
    public static final Scanner.ExtensionToken TOKEN = new Scanner.ExtensionToken("//");
    public static final TruncDivOperator OP = new TruncDivOperator();
    public static final Parser.ExtensionHandler HANDLER = TruncDivOperator.getHandler(false);

    @Override
    protected Object apply(TypeConverter converter, Object a, Object b) {
        boolean bNum;
        boolean aInt = a instanceof Integer || a instanceof Long;
        boolean bInt = b instanceof Integer || b instanceof Long;
        boolean aNum = aInt || a instanceof Double || a instanceof Float;
        boolean bl = bNum = bInt || b instanceof Double || b instanceof Float;
        if (aInt && bInt) {
            Long d = converter.convert(a, Long.class);
            Long e = converter.convert(b, Long.class);
            return Math.floorDiv((long)d, e);
        }
        if (aNum && bNum) {
            Double d = converter.convert(a, Double.class);
            Double e = converter.convert(b, Double.class);
            return Math.floor(d / e);
        }
        throw new IllegalArgumentException(String.format("Unsupported operand type(s) for //: '%s' (%s) and '%s' (%s)", a, a == null ? "null" : a.getClass().getSimpleName(), b, b == null ? "null" : b.getClass().getSimpleName()));
    }

    public String toString() {
        return TOKEN.getImage();
    }

    public static Parser.ExtensionHandler getHandler(final boolean eager) {
        return new Parser.ExtensionHandler(Parser.ExtensionPoint.MUL){

            @Override
            public AstNode createAstNode(AstNode ... children) {
                return eager ? new EagerAstBinary(children[0], children[1], (AstBinary.Operator)OP) : new AstBinary(children[0], children[1], OP);
            }
        };
    }
}

